(function(){
    var print = angular.module("print", []);

	print.factory('PrintAccessor', ['DashAPI', 'model', 'MessageLink',
		function (DashAPI, model, MessageLink) {
			var accessor = {
				getAvailableReports: function (data, callback, error) {
					return DashAPI.post('/dashboard/print/ws/getReports', data, callback, error);
				},
				print : function(data, callback, error){
					return DashAPI.post('/dashboard/print/ws/print', data, model.handlePrint(callback), error);
				},
				msgLinkMap:{},//Used for message/task link of current document.
				updateMessageLink: function (patient,scope){
					accessor.messageLinkKey = MessageLink.setLinkType({
						patient: patient.id,
						linkType: MessageLink.linkTypes.patient,
						id: patient.id,
						pat: patient
					},scope);
					accessor.msgLinkMap[patient.uid] = accessor.messageLinkKey
				}
			};
			return accessor;
		}]);

    print.controller('PrintController', ['$scope', 'model', '$filter', 'PrintAccessor',
       			 function($scope, model, $filter, PrintAccessor){
			
			$scope.activePanels = [];
			$scope.sortArray = [];
			for(let i = 0; i < model.print().currList.length; i++){
				$scope.activePanels.push(i);
			}
			
			$scope.checkForNewProf = function(report){
				for(const properties of Object.keys(report.properties)){
					if(properties.includes("prof")){
						if(!model.print().properties[report.id][properties]){
							model.print().properties[report.id][properties] = report.properties[properties]
						}
					}
				}
			}

			//téléchargement des préf utilisateurs			
//			let prop = model.prefSettings('user_settings_printReportProperties');
			if(model.prefSettings('user_settings_printReportProperties') != null){
				model.print().properties = model.prefSettings('user_settings_printReportProperties');
				if(model.prefSettings('user_settings_chosenReports')){
					model.print().chosenReportList = model.prefSettings('user_settings_chosenReports')
					if(model.print().chosenReportList[model.print().type.type]){
						for(const reports of  model.print().currList){
							for(const report of reports.reports){
								if (report.id == model.print().chosenReportList[model.print().type.type]){
									model.print().printDef = '/dashboard/resources/ofys/print/print_entry.html?v=bj';
									$scope.checkForNewProf(report);
									$scope.chosenReport = report;
									break;
								}
							}
							if(model.print().chosenReport){
								break;
							}
						}
					}
				}
			}
			
			$scope.orientation = [
					{name: "printNormal" , id:"PORTRAIT"},
					{name: "printRotate", id:"LANDSCAPE"}
				];
				
			$scope.printDynaDateOptions = {
				format: 'YYYY-MM-DD',
				acceptFutureDate: true,
				onDateSelected: function (mDate, dAssist) {
					if(mDate){
						model.print().properties[$scope.chosenReport.id].date.value = mDate.format("YYYY-MM-DD");
//						const splitHour = mDate.format("hh:mm").split(":");
//						model.print().properties[$scope.chosenReport.id].hour = (parseInt(splitHour[0]) * 60) + parseInt(splitHour[1]);
					}else{
						model.print().properties[$scope.chosenReport.id].date.value = null;
					}
				}
			};
			
			$scope.printDynaTimeOptions = {
				format: 'HH:mm',
				acceptFutureDate: true,
				onDateSelected: function (mDate, dAssist) {
					if(mDate){
						model.print().properties[$scope.chosenReport.id].hour.value = mDate.format("HH:mm");
					}else{
						model.print().properties[$scope.chosenReport.id].hour.value = null;
					}
				}
			};
			
			$scope.isActive = function(report){
				if($scope.chosenReport && $scope.chosenReport.id){
					return $scope.chosenReport.id == report.id;
				}
			}			
			
			$scope.openSection = function(def, listId){
				$scope.sortArray = [];
				if($scope.sortListerner){
					$scope.sortListerner();
				}
				model.print().printDef = '/dashboard/resources/ofys/print/print_entry.html?v=bj';
				if(model.print().chosenReport){
					var indexList = model.print().currList.findIndex(obj => {
					  return obj.id === listId
					})
					var indexReport = model.print().currList[indexList].reports.findIndex(obj => {
					  return obj.id === listId
					})
					model.print().currList[indexList].reports[indexReport] = model.print().chosenReport;
				}
				model.print().listId = listId;
				$scope.chosenReport = def;
				
				if(!model.print().properties[def.id]){
					model.print().properties[def.id] = angular.copy(def.properties);
					model.print().properties[def.id].orientation = {
						"value" : "PORTRAIT",
						"type" : "orientation"
						};
					if(def.id == "patient_prescription_list"){
						model.print().properties[def.id].active.value = true;
					}
				}
				$scope.checkForNewProf(def);
				for(const properties of Object.keys($scope.chosenReport.properties)){
					if(properties.includes("sortBy")){
						$scope.sortArray.push(model.print().properties[def.id][properties]);
					}
				}
				if($scope.sortArray.length>0){
					$scope.sortListerner = watchSort();
				}
			}
			
			/**
			 * COMMENT: PRINT PRINTCONTROLLER @watch
			 *
			 * Sert à vérifier si le "report" choisie contient des tries et s'assure qu'un seul trie est choisie
			 * 	
			 */
			function watchSort(){
				$scope.$watch('sortArray|filter:{value:true}', function (nv, ov) {
					if(nv.length>1){
						model.print().properties[$scope.chosenReport.id][ov[0].name].value = false;
					}
					return false;
				}, true)
			}	
			
			$scope.print = function(){
				if($scope.chosenReport){
					let report = angular.copy($scope.chosenReport);
					report.properties = angular.copy(model.print().properties[$scope.chosenReport.id]);
					Object.values(report.properties).find(obj => {
						if(obj.type === "LocalDateProperty"){
							if(obj.value == null){
								obj.value = moment().format(OfysUtils.DATEFORMAT);
								obj.value = moment(obj.value).startOf('day').valueOf()
							}else{
								obj.value = moment().format(OfysUtils.DATEFORMAT);
								obj.value = moment(report.properties.date.value).startOf('day').valueOf();
							}
						}else if(obj.type === "TimeProperty"&& obj.value != null){	
							const splitHour = (report.properties.hour.value).split(":");
							obj.value = (parseInt(splitHour[0]) * 60) + parseInt(splitHour[1])
						}
					})
					var data = {
						report : report,
						id : model.print().type.id ,
						type : model.print().type.type,
						date : model.print().type.date,
						ids : model.print().type.ids
					}
					 return PrintAccessor.print(data, function(res){
						model.print().chosenReportList[model.print().type.type] = $scope.chosenReport.id
						model.prefSettings('user_settings_printReportProperties', Object.assign({}, model.print().properties));
						model.prefSettings('user_settings_chosenReports', Object.assign({}, model.print().chosenReportList))
						return res;
					});		
				}						
			}
			
			$scope.printThenClose = function(){
				var promise = $scope.print().then(function(res) 
					{
						if(res.data && res.data.status && res.data.status.severity == "OK"){
							$scope.fl.cancel();
						}
					}
				);
			}
    }]);

})()