function init(formPropertiesData){
	if (formPropertiesData && formPropertiesData.jsonProperties) {
		setVariables(JSON.parse(formPropertiesData.jsonProperties));
		setLoaded(JSON.stringify(formPropertiesData.meta), JSON.stringify(formPropertiesData.auto), JSON.stringify(formPropertiesData.saved));
		ReloadImage();
	}
}

var properties = {};

function fillFormWithData(formDataObj){
	if(typeof setReadonly === "function"){
		setReadonly(formDataObj.prop.readonly);
	}
	formDataObj.prop.loadingData = true;
	backendAutofill(formDataObj);
}

function backendAutofill(formDataObj){
	if(typeof listFormInputs === 'undefined'){
		return;
	}

	var formInputs = listFormInputs(formDataObj.id);
	var postForData = { 
		formData: formDataObj,
		inputs: formInputs, 
		readonly: formDataObj.prop.readonly
	};
	var json = JSON.stringify(postForData);

	//Should be called only once per form.
	//Risk of overriding data if called multiple times per form

	$.ajax({
		type: "POST",
		url: "/dashboard/forms/ws/autoFill",
		data: json,
		contentType: "application/json",
		success: function(res) {
			if (res.status) {
				// un ReturnObject 
				if (res.status.severity=='OK') {
					properties = res.obj;
				} else {
					try {
						console.log(res.status.message);
					} catch(e){
						console.log("autoFill: "+e.message);
					}
				}
			} else {
				properties = res;
			}
			if(typeof setFormProperties === "function"){
				setFormProperties(properties);
			}
			if(typeof cnesstQuestion === "function" && formDataObj.prefillForm !== undefined){
				var prefillForm = $.extend(true, {}, formDataObj.prefillForm);
				setTimeout(function(){
					cnesstQuestion(prefillForm);
				}, 200);
				formDataObj.prefillForm = {};
			}

			formDataObj.prop.loadingData = false;
			init(properties);
		},
		dataType: "json"
	  });
}

var allDatePickers = [];

function setModeOfff(readonly){
	if(readonly){
		$(".button-div").hide();
		$("body").css('pointer-events','none');
		batchActions(allDatePickers, 'removeDatePicker');
	}else{
		$(".button-div").show();
		$("body").css('pointer-events','auto');
		batchActions(allDatePickers, 'addDatePicker');
	}
}

function goPrint(){
	var failedToPrint = !document.execCommand('print', false, null);

	if(failedToPrint)window.print();
}


function batchActions(selectorArray, action){
	for(i = 0; i< selectorArray.length; i++){
		window[action](selectorArray[i]);
	}
}

function addDatePicker(selector){
	$(selector).datepicker({
		dateFormat: "yy-mm-dd"
	});
}

function removeDatePicker(selector){
	$(selector).datepicker({
		dateFormat: "yy-mm-dd"
	});
}

$(document).ready(function(){
	//Called to patch ie bug to load html only on ie
	if(typeof formReady === "function"){
		formReady(window);
	}

	//Tâche bitrix #8890: Bug : Plateforme Ofyspro ouvre dans un formulaire du CRDS
	$('body').on('click', 'a', function(e) {
		//Empêcher l'ouveture des href anchor de rafraichir la page si c'est juste pour un scrollintoView
		var link = $(this).attr('href');
		if(link.startsWith('#')) {
			e.preventDefault();
			$(link)[0].scrollIntoView();
		}
	});

});

if(typeof isAForm == "undefined"){//infodata.js file is not present for crds with requestid
	window.HTMLFormElement.prototype.oldsubmit = window.HTMLFormElement.prototype.submit;
	window.HTMLFormElement.prototype.submit = function(){
		if(typeof InfodataOfys != "undefined" && InfodataOfys.getFormId != undefined){
			var id = InfodataOfys.getFormId();
			console.log("Form Id:"+id);
			var subForm = $('form');
			if (subForm[0].action.indexOf('?') > -1) {
				subForm[0].action = subForm[0].action+'&formDataId=' + id;	
			} else {
				subForm[0].action = subForm[0].action+'?formDataId=' + id;	
			}
			this.oldsubmit();
		}
	}
}