/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.rxdrugref.impl;

import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.middle.dataobjects.encounter.AHFS;
import ca.infodata.ofys.data.middle.dataobjects.encounter.DIN;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.util.math.NumberUtils;
import ca.infodata.rxdrugref.IRxDrugRefAccessor;
import ca.infodata.rxdrugref.Messages;
import ca.infodata.rxdrugref.RxDrufRefUtils;
import ca.infodata.rxdrugref.RxElement;
import ca.infodata.rxdrugref.RxTC;
import ca.infodata.rxdrugref.SEARCH_ELEMENT_TYPECODE;
import ca.infodata.rxdrugref.impl.MyDrugrefComparator;
import ca.infodata.rxdrugref.impl.TimingOutCallback;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

public class RxDrugRefAccessor
implements IRxDrugRefAccessor {
    private IConnectionInfoProvider connectionInfoProvider;
    private String myDrugRefUrl;

    public RxDrugRefAccessor(IConnectionInfoProvider connectionInfoProvider) {
        if (connectionInfoProvider == null) {
            throw new NullPointerException("connectionProvider is required");
        }
        this.connectionInfoProvider = connectionInfoProvider;
    }

    private long getTimeout() {
        return this.connectionInfoProvider.get().getTimeoutInMillis();
    }

    private String getDrugRef2Url() {
        return this.connectionInfoProvider.get().getServerAddress() + "/drugref2/DrugrefService";
    }

    private String getMyDrugRefUrl() {
        if (this.myDrugRefUrl == null) {
            this.myDrugRefUrl = "https://mydrugref.org/backend/api";
        }
        return this.myDrugRefUrl;
    }

    @Override
    public Map<String, Object> getByDin(String din) {
        Object obj = null;
        Map<String, Object> drug = new Hashtable<String, Object>();
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement("DIN;" + din);
            params.addElement(false);
            obj = this.callDrugRef2Webservice("get_drug_2", params);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "", e1);
        }
        if (obj != null) {
            Vector vector;
            if (obj instanceof XmlRpcException) {
                XmlRpcException xmle = (XmlRpcException)obj;
                xmle.printStackTrace();
                logger.log(Level.WARNING, "", obj);
            } else if (obj instanceof Object[]) {
                Object[] vec;
                for (Object m : vec = (Object[])obj) {
                    Map mm = (Map)m;
                    this.debug(mm.toString());
                }
            } else if (obj instanceof Hashtable) {
                drug = (Map)obj;
            } else if (obj instanceof Vector && (vector = (Vector)obj).size() > 0) {
                drug = (Map)vector.get(0);
            }
        }
        return drug;
    }

    @Override
    public DIN getDinByDin(String din) {
        Map<String, Object> rxDrug = this.getByDin(din);
        if (rxDrug == null || rxDrug.isEmpty()) {
            return null;
        }
        return this.fromRxDrugToDIN2(rxDrug);
    }

    private DIN fromRxDrugToDIN2(Map<String, Object> rxDrug) {
        String strength = "";
        List component = (List)rxDrug.get("components");
        String genericName = (String)rxDrug.get("name");
        String commercialName = (String)rxDrug.get("product");
        Integer din = NumberUtils.failsafeParseInt((String)((String)rxDrug.get("regional_identifier")));
        if (component != null) {
            if (component.size() == 1) {
                for (Map map : component) {
                    int fi;
                    Double fStrength = (Double)map.get("strength");
                    double fl = fStrength;
                    strength = fl == (double)(fi = fStrength.intValue()) ? String.valueOf(fi) : String.valueOf(fl);
                    strength = strength + map.get("unit");
                }
            } else {
                genericName = "";
                String totalStr = "";
                for (Map map : component) {
                    int fi;
                    Double fStrength = (Double)map.get("strength");
                    double fl = fStrength;
                    strength = fl == (double)(fi = fStrength.intValue()) ? String.valueOf(fi) : String.valueOf(fl);
                    totalStr = totalStr + strength + map.get("unit") + "-";
                    genericName = genericName + (String)map.get("name") + " / ";
                }
                strength = RxDrufRefUtils.removeEnd(totalStr, "-");
                genericName = RxDrufRefUtils.removeEnd(genericName, " / ");
            }
        }
        DIN dinObject = new DIN();
        dinObject.din = din;
        dinObject.commercialName = commercialName;
        dinObject.genericName = genericName;
        dinObject.strength = strength;
        return dinObject;
    }

    @Override
    public Set<String> getAhfsFromDin(Integer din) {
        List<Integer> dins = Arrays.asList(din);
        Map<Integer, Set<String>> map = this.getAhfsFromDins(dins);
        if (map.containsKey(din)) {
            return map.get(din);
        }
        return Collections.emptySet();
    }

    @Override
    public Vector<Map<String, Object>> getPedDosingInformation(String drugName, String strength) {
        if (StringUtils.isEmpty((String)drugName) || StringUtils.isEmpty((String)strength)) {
            return null;
        }
        Vector<String> params = new Vector<String>();
        params.addElement(drugName + ";" + strength);
        Vector vec = (Vector)this.callDrugRef2Webservice("get_ped_dosage_reco", params);
        return vec;
    }

    @Override
    public List<String> getAtcsFromDins(Set<String> dins) {
        String argument = new JoinList(",", dins).toString();
        Vector result = new Vector();
        Object obj = null;
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(argument);
            obj = this.callDrugRef2Webservice("get_atcs_from_dins", params);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception calling get_atcs_from_dins(" + argument + ")", e);
        }
        if (obj != null) {
            if (obj instanceof Vector) {
                result = (Vector)obj;
                for (Map map : result) {
                    this.debug(map.toString());
                }
            } else if (obj instanceof Throwable) {
                logger.log(Level.WARNING, "Received unexpected object from get_atcs_from_dins(" + argument + ") --> " + obj, (Throwable)obj);
            } else {
                logger.log(Level.WARNING, "Received unexpected object from get_atcs_from_dins(" + argument + ") --> " + obj);
            }
        }
        ArrayList<String> atcs = new ArrayList<String>();
        if (result != null) {
            for (Map r : result) {
                for (Object e : r.values()) {
                    atcs.add((String)e);
                }
            }
        }
        return atcs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Map<String, Object>> getInteractions(List<String> atcs) {
        logger.entering("RxDrugRef", "getInteractions", atcs);
        try {
            void var12_34;
            List<Map<String, Object>> vec;
            long start = System.currentTimeMillis();
            ArrayList<Map<String, Object>> all = new ArrayList<Map<String, Object>>();
            String[] commands = new String[]{"warnings_byATC,bulletins_byATC,interactions_byATC,get_guidelines"};
            String myDrugrefId = "pdrolet@infodata.ca";
            HashSet<Map> setInfo = new HashSet<Map>();
            for (String command : commands) {
                try {
                    List list = this.getMyDrugrefInfo(command, atcs, myDrugrefId);
                    if (list != null && list.size() > 0) {
                        for (Object object : list) {
                            Map map = (Map)object;
                            if (setInfo.contains(map)) continue;
                            all.add(map);
                            setInfo.add(map);
                        }
                    }
                    this.debug("command " + (String)command + " executed successfully");
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to execute command " + (String)command, exception);
                }
            }
            ArrayList<String> allCodesForDuplicates = new ArrayList<String>(atcs.size());
            for (String code : atcs) {
                if (code.equals("DEVICE")) continue;
                allCodesForDuplicates.add(code);
            }
            HashSet<Map> setDupl = new HashSet<Map>();
            if (allCodesForDuplicates.size() > 0 && (vec = this.checkDuplicate(allCodesForDuplicates)) != null) {
                for (Map map : vec) {
                    if (setDupl.contains(map)) continue;
                    all.add(map);
                    setDupl.add(map);
                }
            }
            Collections.sort(all, new MyDrugrefComparator());
            this.debug(((Object)all).toString());
            try {
                for (int i = 0; i < all.size(); ++i) {
                    Hashtable ht = (Hashtable)all.get(i);
                    this.debug("**ht=" + ht);
                    String string = (String)ht.get("effect");
                    this.debug("**effect=" + string);
                    String interactStr = "";
                    if (string != null) {
                        void var12_32;
                        if (string.equals("a")) {
                            String string2 = Messages.getString("oscarRx.interactions.msgAugmentsNoClinical");
                        } else if (string.equals("A")) {
                            String string3 = Messages.getString("oscarRx.interactions.msgAugments");
                        } else if (string.equals("i")) {
                            String string4 = Messages.getString("oscarRx.interactions.msgInhibitsNoClinical");
                        } else if (string.equals("I")) {
                            String string5 = Messages.getString("oscarRx.interactions.msgInhibits");
                        } else if (string.equals("n")) {
                            String string6 = Messages.getString("oscarRx.interactions.msgNoEffect");
                        } else if (string.equals("N")) {
                            String string7 = Messages.getString("oscarRx.interactions.msgNoEffect");
                        } else if (string.equals("D")) {
                            String string8 = " -DUPLICATION- ";
                        } else if (string.equals(" ")) {
                            String string9 = Messages.getString("oscarRx.interactions.msgUnknownEffect");
                        }
                        interactStr = ht.get("name") + " " + (String)var12_32 + " " + ht.get("drug2");
                    }
                    ht.put("interactStr", interactStr);
                    this.debug("ineractStr=" + interactStr);
                }
            }
            catch (NullPointerException npe) {
                logger.log(Level.WARNING, "Error", npe);
            }
            Vector<Hashtable> allRetVec = new Vector<Hashtable>();
            Vector<String> currentIdWarnings = new Vector<String>();
            boolean bl = false;
            while (var12_34 < all.size()) {
                Hashtable ht = (Hashtable)all.get((int)var12_34);
                Date dt = (Date)ht.get("updated_at");
                Long time = dt != null ? Long.valueOf(dt.getTime()) : Long.valueOf(Calendar.getInstance().getTimeInMillis());
                String idWarning = ht.get("id") + "." + time;
                if (!currentIdWarnings.contains(idWarning)) {
                    currentIdWarnings.add(idWarning);
                    allRetVec.add(ht);
                }
                ++var12_34;
            }
            this.debug("currentIdWarnings is  " + currentIdWarnings);
            this.debug("MyDrugref return time " + (System.currentTimeMillis() - start));
            return all;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to getInteractions for atcs " + atcs, e);
            return null;
        }
    }

    private List<Map<String, Object>> checkDuplicate(List<String> atcs) {
        if (atcs == null) {
            throw new NullPointerException("atcs");
        }
        Vector vec = new Vector();
        if (atcs.size() > 0) {
            String s = "'" + new JoinList("','", atcs).toString() + "'";
            Vector<String> v = new Vector<String>();
            v.addElement(s);
            vec = (Vector)this.callDrugRef2Webservice("check_duplicates", v);
        }
        return vec;
    }

    private List getMyDrugrefInfo(String command, List<String> atcNumbers, String myDrugrefId) throws Exception {
        this.removeNullFromVector(atcNumbers);
        Vector<Object> params = new Vector<Object>();
        params.addElement(command);
        params.addElement(new Vector<String>(atcNumbers));
        if (myDrugrefId != null && !myDrugrefId.trim().equals("")) {
            this.debug("putting >" + myDrugrefId + "< in the request");
            params.addElement(myDrugrefId);
        }
        Vector vec = new Vector();
        Object obj = this.callMyDrugRefWebservice("Fetch", params);
        this.debug("RETURNED " + obj);
        if (obj instanceof Vector) {
            vec = (Vector)obj;
        } else if (obj instanceof Hashtable) {
            Object holbrook = ((Hashtable)obj).get("Holbrook Drug Interactions");
            if (holbrook instanceof Vector) {
                vec = (Vector)holbrook;
            }
            Enumeration e = ((Hashtable)obj).keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                this.debug(s + " " + ((Hashtable)obj).get(s) + " " + ((Hashtable)obj).get(s).getClass().getName());
            }
        }
        return vec;
    }

    private void removeNullFromVector(Collection v) {
        while (v != null && v.contains(null)) {
            v.remove(null);
        }
    }

    @Override
    public Vector<Map<String, Object>> listTeneursForIngredient(String s, String commercialName) {
        Vector arrProposals;
        block5: {
            Vector obj;
            block8: {
                block7: {
                    Object[] vec;
                    block6: {
                        obj = null;
                        arrProposals = new Vector();
                        try {
                            obj = this.list_teneurs_for_ingredient(s, commercialName);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        if (obj == null) break block5;
                        if (!(obj instanceof XmlRpcException)) break block6;
                        XmlRpcException xmle = (XmlRpcException)obj;
                        xmle.printStackTrace();
                        this.debug("PROB with ");
                        break block5;
                    }
                    if (!(obj instanceof Object[])) break block7;
                    for (Object m : vec = (Object[])obj) {
                        Map mm = (Map)m;
                        this.debug(mm.toString());
                    }
                    break block5;
                }
                if (!(obj instanceof Hashtable)) break block8;
                Hashtable vec = (Hashtable)((Object)obj);
                Enumeration iter = vec.keys();
                while (iter.hasMoreElements()) {
                    Object oo = iter.nextElement();
                    this.debug(oo.toString() + ": " + vec.get(oo.toString()));
                }
                break block5;
            }
            if (!(obj instanceof Vector)) break block5;
            arrProposals = obj;
            for (Map map : arrProposals) {
                this.debug(map.toString());
            }
        }
        return arrProposals;
    }

    private Vector list_teneurs_for_ingredient(String searchStr, String commercialName) throws Exception {
        Vector<String> params = new Vector<String>();
        params.addElement(searchStr + (commercialName == null ? "" : "~" + commercialName));
        Vector vec = (Vector)this.callDrugRef2Webservice("list_teneurs_for_ingredient", params);
        return vec;
    }

    @Override
    public List<RxElement> searchElements(String text, Set<SEARCH_ELEMENT_TYPECODE> searchInType) {
        ArrayList<RxElement> allergies = new ArrayList<RxElement>();
        Vector<String> catVec = new Vector<String>();
        if (searchInType.contains((Object)SEARCH_ELEMENT_TYPECODE.BRAND_NAMES)) {
            catVec.add("13");
        }
        if (searchInType.contains((Object)SEARCH_ELEMENT_TYPECODE.DRUG_CLASSES)) {
            catVec.add("10");
        }
        if (searchInType.contains((Object)SEARCH_ELEMENT_TYPECODE.GENERIC_NAMES)) {
            catVec.add("11");
            catVec.add("12");
        }
        if (searchInType.contains((Object)SEARCH_ELEMENT_TYPECODE.INGREDIENTS)) {
            catVec.add("14");
        }
        if (catVec.isEmpty()) {
            throw new IllegalArgumentException("search types not supported " + searchInType);
        }
        Vector<Object> params = new Vector<Object>();
        params.addElement(text);
        params.addElement(catVec);
        Vector vec = (Vector)this.callDrugRef2Webservice("list_search_element_select_categories", params);
        if (vec != null) {
            for (Hashtable hash : vec) {
                Object atc;
                if ("None found".equals(hash.get("name"))) {
                    IRxDrugRefAccessor.logger.fine("IM FLAGGING IT AS NOT FOUND");
                    break;
                }
                int category = (Integer)hash.get("category");
                String id = hash.get("id").toString();
                String name = (String)hash.get("name");
                RxElement rxe = new RxElement(id, category, name);
                Object din = hash.get("din");
                if (din != null) {
                    rxe.din = Integer.valueOf((String)din);
                }
                if ((atc = hash.get("atc")) != null) {
                    rxe.atc = (String)atc;
                }
                allergies.add(rxe);
            }
        }
        return allergies;
    }

    @Override
    public List<Map<Integer, Object>> getRenalDosingInformation(String din_or_atc, int age, String sexe, boolean isBlack, double weight, double sCr, String dxCim10) {
        Vector params = new Vector();
        Hashtable<String, Object> hh = new Hashtable<String, Object>();
        hh.put("din_or_atc", din_or_atc);
        hh.put("isblack", isBlack ? "1" : "0");
        hh.put("age", new Integer(age));
        hh.put("sexe", sexe);
        hh.put("weight", new Double(weight));
        hh.put("sCr", new Double(sCr));
        if (StringUtils.isNotBlank((String)dxCim10)) {
            hh.put("dxcim10", dxCim10);
        }
        params.addElement(hh);
        Vector vec = (Vector)this.callDrugRef2Webservice("get_renal_dosing_information", params);
        return vec;
    }

    @Override
    public List<String> getAtcsFromDins(List<String> dins) {
        String argument = new JoinList(",", dins).toString();
        Vector result = new Vector();
        Object obj = null;
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(argument);
            obj = this.callDrugRef2Webservice("get_atcs_from_dins", params);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception calling get_atcs_from_dins(" + argument + ")", e);
        }
        if (obj != null) {
            if (obj instanceof Vector) {
                result = (Vector)obj;
                for (Map map : result) {
                    this.debug(map.toString());
                }
            } else if (obj instanceof Throwable) {
                logger.log(Level.WARNING, "Received unexpected object from get_atcs_from_dins(" + argument + ") --> " + obj, (Throwable)obj);
            } else {
                logger.log(Level.WARNING, "Received unexpected object from get_atcs_from_dins(" + argument + ") --> " + obj);
            }
        }
        ArrayList<String> atcs = new ArrayList<String>();
        if (result != null) {
            for (Map r : result) {
                for (Object e : r.values()) {
                    atcs.add((String)e);
                }
            }
        }
        return atcs;
    }

    @Override
    public List<Map<String, Object>> getAllergyWarnings(String drugs, List<RxElement> allergies) {
        if (allergies.isEmpty()) {
            return Collections.emptyList();
        }
        Vector pAllergies = new Vector(allergies.size());
        for (RxElement a : allergies) {
            Hashtable<String, String> map = new Hashtable<String, String>(3);
            if (a.id != null) {
                map.put("id", a.id.toString());
            }
            map.put("description", a.name);
            map.put("type", a.category.toString());
            map.put("atc", a.atc == null ? "" : a.atc);
            pAllergies.add(map);
        }
        Vector<Object> params = new Vector<Object>();
        params.addElement(drugs);
        params.addElement(pAllergies);
        Vector vec = (Vector)this.callDrugRef2Webservice("get_allergy_warnings", params);
        return vec;
    }

    @Override
    public Map<String, Object> getDrug(String pkey) {
        Hashtable obj = null;
        Map<String, Object> drug = new Hashtable<String, Object>();
        try {
            obj = this.getDrug2(pkey, Boolean.FALSE);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "", e1);
        }
        if (obj != null) {
            if (obj instanceof XmlRpcException) {
                XmlRpcException xmle = (XmlRpcException)obj;
                xmle.printStackTrace();
                logger.log(Level.WARNING, "", obj);
            } else if (obj instanceof Object[]) {
                Object[] vec;
                for (Object m : vec = (Object[])obj) {
                    Map mm = (Map)m;
                    this.debug(mm.toString());
                }
            } else if (obj instanceof Hashtable) {
                drug = obj;
            }
        }
        return drug;
    }

    private Hashtable getDrug2(String pKey, Boolean boolVal) throws Exception {
        Hashtable returnVal = null;
        Vector<Object> params = new Vector<Object>();
        params.addElement(pKey);
        params.addElement(boolVal);
        Vector vec = (Vector)this.callDrugRef2Webservice("get_drug_2", params);
        if (vec != null && vec.size() > 0) {
            returnVal = (Hashtable)vec.get(0);
        }
        return returnVal;
    }

    @Override
    public Vector<Map<String, Object>> getDrugsFromTherapeuticClass(String s) {
        Vector arrProposals;
        block5: {
            Vector obj;
            block8: {
                block7: {
                    Object[] vec;
                    block6: {
                        obj = null;
                        arrProposals = new Vector();
                        try {
                            obj = this.getDrugsFromTC(s);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        if (obj == null) break block5;
                        if (!(obj instanceof XmlRpcException)) break block6;
                        XmlRpcException xmle = (XmlRpcException)obj;
                        xmle.printStackTrace();
                        this.debug("PROB with ");
                        break block5;
                    }
                    if (!(obj instanceof Object[])) break block7;
                    for (Object m : vec = (Object[])obj) {
                        Map mm = (Map)m;
                        this.debug(mm.toString());
                    }
                    break block5;
                }
                if (!(obj instanceof Hashtable)) break block8;
                Hashtable vec = (Hashtable)((Object)obj);
                Enumeration iter = vec.keys();
                while (iter.hasMoreElements()) {
                    Object oo = iter.nextElement();
                    this.debug(oo.toString() + ": " + vec.get(oo.toString()));
                }
                break block5;
            }
            if (!(obj instanceof Vector)) break block5;
            arrProposals = obj;
            for (Map map : arrProposals) {
                this.debug(map.toString());
            }
        }
        return arrProposals;
    }

    private Vector getDrugsFromTC(String searchStr) throws Exception {
        Vector<String> params = new Vector<String>();
        params.addElement(searchStr);
        Vector vec = (Vector)this.callDrugRef2Webservice("get_drugs_from_therapeutic_class", params);
        return vec;
    }

    @Override
    public Vector<Map<String, Object>> searchDrugs(String s) {
        Vector arrProposals;
        block5: {
            Vector obj;
            block8: {
                block7: {
                    Object[] vec;
                    block6: {
                        obj = null;
                        arrProposals = new Vector();
                        try {
                            obj = this.list_drug_element(s);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        if (obj == null) break block5;
                        if (!(obj instanceof XmlRpcException)) break block6;
                        XmlRpcException xmle = (XmlRpcException)obj;
                        xmle.printStackTrace();
                        this.debug("PROB with ");
                        break block5;
                    }
                    if (!(obj instanceof Object[])) break block7;
                    for (Object m : vec = (Object[])obj) {
                        Map mm = (Map)m;
                        this.debug(mm.toString());
                    }
                    break block5;
                }
                if (!(obj instanceof Hashtable)) break block8;
                Hashtable vec = (Hashtable)((Object)obj);
                Enumeration iter = vec.keys();
                while (iter.hasMoreElements()) {
                    Object oo = iter.nextElement();
                    this.debug(oo.toString() + ": " + vec.get(oo.toString()));
                }
                break block5;
            }
            if (!(obj instanceof Vector)) break block5;
            arrProposals = obj;
            for (Map map : arrProposals) {
                this.debug(map.toString());
            }
        }
        return arrProposals;
    }

    private Vector list_drug_element(String searchStr) throws Exception {
        Vector<String> params = new Vector<String>();
        params.addElement(searchStr);
        Vector vec = (Vector)this.callDrugRef2Webservice("list_search_element3", params);
        return vec;
    }

    @Override
    public List<XDrugStrength> findDrugs(String name) {
        this.validThatDrugRefServerIsAccessible();
        Vector<Map<String, Object>> rxdrugs = null;
        if (name != null && name.trim().length() > 3) {
            String med = StringUtils.removeAccent((String)name.toUpperCase());
            this.debug("chercher " + med);
            rxdrugs = med.charAt(0) == '+' ? this.getDrugsFromTherapeuticClass(med.substring(1) + ";fr") : this.searchDrugs(med);
        }
        ArrayList<XDrugStrength> drugs = new ArrayList<XDrugStrength>(rxdrugs == null ? 0 : rxdrugs.size());
        if (rxdrugs != null) {
            for (Map map : rxdrugs) {
                XDrugStrength drug = this.fromRxDrugToXDrug(map);
                if (drug == null) continue;
                drugs.add(drug);
            }
        }
        return drugs;
    }

    private XDrugStrength fromRxDrugToXDrug(Map<String, Object> ref) {
        String pkey;
        XDrugStrength drug = null;
        if (ref != null && !StringUtils.isBlank((CharSequence)(pkey = ((Integer)ref.get("id")).toString())) && !"None found".equals(ref.get("name"))) {
            XMyOrderableDrugForm format;
            Map<String, Object> selectedDrug = this.getDrug(pkey);
            String strength = "";
            List component = (List)selectedDrug.get("components");
            String genericName = (String)selectedDrug.get("name");
            String commercialName = (String)selectedDrug.get("product");
            String dinS = (String)selectedDrug.get("regional_identifier");
            Integer din = null;
            if (dinS != null && NumberUtils.isNumber((String)dinS)) {
                try {
                    din = Integer.parseInt(dinS);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            format = (format = XMyOrderableDrugForm.getDrugForm((String)((String)selectedDrug.get("drugForm")))) == null ? XMyOrderableDrugForm.PILL : format;
            ArrayList<XDrugStrength> lstXDrugStrength = new ArrayList<XDrugStrength>();
            if (component != null) {
                if (component.size() == 1) {
                    for (Map map : component) {
                        this.debug("Component:" + map.toString() + " --> ");
                        Double fStrength = (Double)map.get("strength");
                        double fl = fStrength;
                        int fi = fStrength.intValue();
                        strength = fl == (double)fi ? String.valueOf(fi) : String.valueOf(fl);
                        strength = strength + map.get("unit");
                    }
                } else {
                    genericName = "";
                    String totalStr = "";
                    for (Map map : component) {
                        this.debug("Component:" + map.toString() + " --> ");
                        this.debug(map.get("name") + ", " + map.get("strength") + ", " + map.get("unit"));
                        Double fStrength = (Double)map.get("strength");
                        double fl = fStrength;
                        int fi = fStrength.intValue();
                        strength = fl == (double)fi ? String.valueOf(fi) : String.valueOf(fl);
                        totalStr = totalStr + strength + map.get("unit") + "-";
                        genericName = genericName + (String)map.get("name") + " / ";
                    }
                    strength = RxDrufRefUtils.removeEnd(totalStr, "-");
                    genericName = RxDrufRefUtils.removeEnd(genericName, " / ");
                }
                XDrugStrength xDS = new XDrugStrength();
                xDS.setStrength(strength);
                lstXDrugStrength.add(xDS);
            }
            drug = new XDrugStrength();
            drug.setDin(din);
            drug.setName(commercialName);
            drug.setGenericName(genericName);
            drug.setCompleteName(genericName + ", " + commercialName);
            drug.setDrugType(XDrugType.REGULAR);
        }
        return drug;
    }

    @Override
    public void putSavedPrescription(Integer din, String posologie, String frequence, Integer jrs, Integer qte, Integer repetator) {
        Vector params = new Vector();
        Hashtable<String, Object> hh = new Hashtable<String, Object>();
        hh.put("din", din);
        hh.put("pos", posologie);
        hh.put("freq", frequence);
        hh.put("jrs", jrs == null ? 0 : jrs);
        hh.put("qte", qte == null ? 0 : qte);
        hh.put("rep", repetator == null ? 0 : repetator);
        params.addElement(hh);
        this.callDrugRef2Webservice("put_rx_prescribed", params);
    }

    @Override
    public Map<String, List<RxTC>> getTherapeuticClassFromDrugs(List<String> drugClasseIds) {
        HashMap<String, List<RxTC>> drugMapClasses = new HashMap<String, List<RxTC>>();
        if (drugClasseIds.size() > 0) {
            Vector<List<String>> params = new Vector<List<String>>();
            params.addElement(drugClasseIds);
            Vector response = (Vector)this.callDrugRef2Webservice("list_drug_class", params);
            if (response != null) {
                for (Hashtable hash : response) {
                    IRxDrugRefAccessor.logger.fine("LOOPING");
                    String idDrug = String.valueOf(hash.get("id_drug"));
                    String idClass = String.valueOf(hash.get("id_class"));
                    String name = String.valueOf(hash.get("name"));
                    Object din = hash.get("din");
                    String sDin = "";
                    if (din != null) {
                        sDin = ((Integer)din).toString();
                    }
                    IRxDrugRefAccessor.logger.fine(" idDrug " + idDrug + " idClass " + idClass + " name " + name);
                    if (drugMapClasses.containsKey(idDrug)) {
                        ((List)drugMapClasses.get(idDrug)).add(new RxTC(idClass, name, sDin));
                        continue;
                    }
                    ArrayList<RxTC> list = new ArrayList<RxTC>();
                    list.add(new RxTC(idClass, name, sDin));
                    drugMapClasses.put(idDrug, list);
                }
            }
        }
        return drugMapClasses;
    }

    @Override
    public List<AHFS> listClassAHFS_an() {
        return this.listClassAHFS("an");
    }

    @Override
    public List<AHFS> listClassAHFS_fr() {
        return this.listClassAHFS("fr");
    }

    private List<AHFS> listClassAHFS(String lang) {
        Vector<String> params = new Vector<String>();
        params.addElement("fr");
        Vector vec = (Vector)this.callDrugRef2Webservice("list_class_ahfs", params);
        ArrayList<AHFS> list = new ArrayList<AHFS>();
        for (Hashtable e : vec) {
            AHFS ahfs = new AHFS();
            ahfs.id = (String)e.get("a");
            ahfs.desc = (String)e.get("d");
            list.add(ahfs);
        }
        Collections.sort(list, new Comparator<AHFS>(){

            @Override
            public int compare(AHFS o1, AHFS o2) {
                return o1.id.compareTo(o2.id);
            }
        });
        return list;
    }

    @Override
    public Map<Integer, Set<String>> getAhfsFromDins(Collection<Integer> dins) {
        Vector result = new Vector();
        Object obj = null;
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(new JoinList(",", dins).toString());
            obj = this.callDrugRef2Webservice("get_ahfs_from_dins", params);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception calling get_ahfs_from_dins(" + dins + ")", e);
        }
        if (obj != null) {
            if (obj instanceof Vector) {
                result = (Vector)obj;
            } else if (obj instanceof Throwable) {
                logger.log(Level.WARNING, "Received unexpected object from get_ahfs_from_dins(" + dins + ") --> " + obj, (Throwable)obj);
            } else {
                logger.log(Level.WARNING, "Received unexpected object from get_ahfs_from_dins(" + dins + ") --> " + obj);
            }
        }
        HashMap<Integer, Set<String>> dinMapAhfs = new HashMap<Integer, Set<String>>();
        if (result != null) {
            for (Map map : result) {
                for (Map.Entry e : map.entrySet()) {
                    String[] ahfsSplit;
                    Integer din = Integer.valueOf((String)e.getKey());
                    HashSet<String> set = (HashSet<String>)dinMapAhfs.get(din);
                    if (set == null) {
                        set = new HashSet<String>();
                        dinMapAhfs.put(din, set);
                    }
                    String ahfsJoinedList = (String)e.getValue();
                    for (String ahfs : ahfsSplit = ahfsJoinedList.split(",")) {
                        set.add(ahfs);
                    }
                }
            }
        }
        return dinMapAhfs;
    }

    @Override
    public List<DIN> findDins(String name) {
        this.validThatDrugRefServerIsAccessible();
        Vector<Map<String, Object>> rxdrugs = null;
        if (name != null && name.trim().length() > 3) {
            String med = StringUtils.removeAccent((String)name.toUpperCase());
            this.debug("chercher " + med);
            rxdrugs = med.charAt(0) == '+' ? this.getDrugsFromTherapeuticClass(med.substring(1) + ";fr") : this.searchDrugs(med);
        }
        ArrayList<DIN> dins = new ArrayList<DIN>(rxdrugs == null ? 0 : rxdrugs.size());
        if (rxdrugs != null) {
            for (Map map : rxdrugs) {
                DIN din = this.fromRxDrugToDIN(map);
                if (din == null) continue;
                dins.add(din);
            }
        }
        return dins;
    }

    private DIN fromRxDrugToDIN(Map<String, Object> ref) {
        String pkey;
        DIN dinObject = null;
        if (ref != null && !StringUtils.isBlank((CharSequence)(pkey = ((Integer)ref.get("id")).toString())) && !"None found".equals(ref.get("name"))) {
            Map<String, Object> selectedDrug = this.getDrug(pkey);
            dinObject = this.fromRxDrugToDIN2(selectedDrug);
        }
        return dinObject;
    }

    @Override
    public void validThatDrugRefServerIsAccessible() {
    }

    @Override
    public List<Map<String, Object>> getTreatments(String treatment) {
        Object holbrook;
        if (treatment == null || treatment.trim().length() == 0) {
            return null;
        }
        Vector<String> params = new Vector<String>();
        params.addElement(treatment);
        Vector vec = new Vector();
        Object obj = this.callMyDrugRefWebservice("GetTreatments", params);
        if (obj instanceof Vector) {
            vec = (Vector)obj;
        } else if (obj instanceof Hashtable && (holbrook = ((Hashtable)obj).get("Holbrook Drug Interactions")) instanceof Vector) {
            vec = (Vector)holbrook;
        }
        return vec;
    }

    private Object callDrugRef2Webservice(String procedureName, Vector params) {
        this.debug("call DrugRef2 Webservice - " + procedureName + " with params " + params);
        Object o = null;
        TimingOutCallback callback = new TimingOutCallback(this.getTimeout());
        try {
            XmlRpcClient server = new XmlRpcClient(this.getDrugRef2Url());
            server.executeAsync(procedureName, params, (AsyncCallback)callback);
            o = callback.waitForResponse();
        }
        catch (TimingOutCallback.TimeoutException e) {
            String log = this.getTextForLog(procedureName, params);
            logger.info("call Timed out. No response from server. " + log + " " + this.getDrugRef2Url());
        }
        catch (XmlRpcException e) {
            String log = this.getTextForLog(procedureName, params);
            logger.log(Level.WARNING, "XML-RPC Fault #" + e.code + " " + log, e);
        }
        catch (Throwable e) {
            String log = this.getTextForLog(procedureName, params);
            logger.log(Level.WARNING, "Throwing error " + log, e);
        }
        return o;
    }

    private Object callMyDrugRefWebservice(String procedureName, Vector params) {
        this.debug("call MyDruRef Webservice - " + procedureName + " with params " + params);
        Object object = null;
        TimingOutCallback callback = new TimingOutCallback(this.getTimeout());
        try {
            XmlRpcClientLite server = new XmlRpcClientLite(this.getMyDrugRefUrl());
            server.executeAsync(procedureName, params, (AsyncCallback)callback);
            object = callback.waitForResponse();
        }
        catch (TimingOutCallback.TimeoutException e) {
            String log = this.getTextForLog(procedureName, params);
            logger.info("call Timed out. No response from server. " + log + " " + this.getMyDrugRefUrl());
        }
        catch (XmlRpcException e) {
            String log = this.getTextForLog(procedureName, params);
            logger.log(Level.WARNING, "XML-RPC Fault #" + e.code + " " + log, e);
        }
        catch (Throwable e) {
            String log = this.getTextForLog(procedureName, params);
            logger.log(Level.WARNING, "Throwing error " + log, e);
        }
        return object;
    }

    private String getTextForLog(String procedureName, Vector params) {
        String debug = "procedureName=" + procedureName;
        try {
            debug = debug + ", params=" + String.valueOf(params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return debug;
    }

    private void debug(String string) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(string);
        }
    }
}

