/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionCategory;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionEndReason;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModif;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModifAction;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientRepresentativeType;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CVulnerability;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.date.IPartialDate;
import java.util.List;

public class CPatientB2bModif {
    public static final long serialVersionUID = 1L;
    public Integer idPatient;
    public Integer idTreatingProfessionnal;
    public Integer idPatientRepresentative;
    public Integer patientRepresentativeType;
    public Integer idProfessionnalResident;
    public Integer idSiteFollow;
    public String siteFollowStartDate;
    public Integer status;
    public Integer category;
    public String startDate;
    public String endDate;
    public Integer endReason;
    public List<CVulnerability> vulnerabilities;
    public CPatient source;
    public List<XPatientB2bModifAction> actions;

    public CPatientB2bModif(XPatientB2bModif x) {
        this.init(x);
    }

    public void init(XPatientB2bModif x) {
        this.idPatient = x.getIdPatient();
        this.idTreatingProfessionnal = x.getIdTreatingProfessionnal();
        this.idPatientRepresentative = x.getIdPatientRepresentative();
        if (x.getPatientRepresentativeType() != null) {
            this.patientRepresentativeType = x.getPatientRepresentativeType().value;
        }
        this.idProfessionnalResident = x.getIdProfessionnalResident();
        this.idSiteFollow = x.getIdSiteFollow();
        this.siteFollowStartDate = Utils.IPToNullableHyStr((IPartialDate)x.getSiteFollowStartDate());
        if (x.getStatus() != null) {
            this.status = x.getStatus().value;
        }
        if (x.getCategory() != null) {
            this.category = x.getCategory().value;
        }
        this.startDate = Utils.IPToNullableHyStr((IPartialDate)x.getStartDate());
        this.endDate = Utils.IPToNullableHyStr((IPartialDate)x.getEndDate());
        this.vulnerabilities = new CEditableDataObjectList<CVulnerability>(x.getVulnerabilities(), CVulnerability.class);
        this.actions = x.actions;
    }

    public static CPatientB2bModif c(XPatientB2bModif x) {
        return x == null ? null : new CPatientB2bModif(x);
    }

    public XPatientB2bModif x() {
        XPatientB2bModif res = new XPatientB2bModif();
        res.setIdPatient(this.idPatient);
        res.setIdTreatingProfessionnal(this.idTreatingProfessionnal);
        res.setIdPatientRepresentative(this.idPatientRepresentative);
        res.setPatientRepresentativeType(XPatientRepresentativeType.from((Integer)this.patientRepresentativeType));
        res.setIdProfessionnalResident(this.idProfessionnalResident);
        res.setIdSiteFollow(this.idSiteFollow);
        res.setSiteFollowStartDate(Utils.strToLocalDate(this.siteFollowStartDate));
        res.setStatus(XInscriptionStatus.from((Integer)this.status));
        res.setCategory(XInscriptionCategory.from((Integer)this.category));
        res.setStartDate(Utils.strToLocalDate(this.startDate));
        res.setEndDate(Utils.strToLocalDate(this.endDate));
        res.setEndReason(XInscriptionEndReason.from((Integer)this.endReason));
        res.setVulnerabilities(CEditableDataObjectList.x(this.vulnerabilities));
        if (this.source != null) {
            res.setSource(this.source.x());
        }
        res.actions = this.actions;
        return res;
    }
}

