/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

public class RestfulClientServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final ThreadLocal<Long> retryInterval;
    private final int maxRetries;
    private final long defaultRetryInterval;
    private final boolean disableRetryRequestOnHttp429;

    public RestfulClientServiceUnavailableRetryStrategy(int maxRetries, long defaultRetryInterval, TimeUnit unit) {
        this.maxRetries = maxRetries;
        this.defaultRetryInterval = unit.toMillis(defaultRetryInterval);
        this.retryInterval = ThreadLocal.withInitial(() -> defaultRetryInterval);
        this.disableRetryRequestOnHttp429 = Boolean.getBoolean("RestfulClientHttpResquestRetryHandler.disableRetryRequestOnHttp429");
    }

    public long getRetryInterval() {
        return this.retryInterval.get();
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        if (executionCount > this.maxRetries) {
            return false;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 503) {
            this.retryInterval.set(this.defaultRetryInterval);
            return true;
        }
        if (statusCode == 502) {
            this.retryInterval.set(this.defaultRetryInterval);
            return true;
        }
        if (!this.disableRetryRequestOnHttp429 && statusCode == 429) {
            if (response.containsHeader("Retry-After")) {
                try {
                    long retryAfter = Long.parseLong(response.getFirstHeader("Retry-After").getValue());
                    this.retryInterval.set(TimeUnit.SECONDS.toMillis(retryAfter));
                }
                catch (Exception e) {
                    this.retryInterval.set(this.defaultRetryInterval);
                }
            } else {
                this.retryInterval.set(this.defaultRetryInterval);
            }
            return true;
        }
        return false;
    }
}

