/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core;

import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.WebSocketResponse;
import ca.infodata.util1.ProviderR;
import java.util.Collection;

public class WebSocketChannelForwarder
implements IWebSocketChannel {
    private Collection<? extends IWebSocketChannel> channels;

    public WebSocketChannelForwarder(Collection<? extends IWebSocketChannel> channels) {
        this.channels = channels;
    }

    @Override
    public String getId() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? null : first.getId();
    }

    private final IWebSocketChannel getFirstOpenOrJustFirst() {
        IWebSocketChannel first = this.channels.stream().filter(c -> c.isOpen()).findFirst().orElse(null);
        if (first == null) {
            first = this.channels.stream().findFirst().orElse(null);
        }
        return first;
    }

    @Override
    public String getHttpSessionId() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? null : first.getHttpSessionId();
    }

    @Override
    public Integer getXClientId() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? null : first.getXClientId();
    }

    @Override
    public Integer getXSessionId() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? null : first.getXSessionId();
    }

    @Override
    public void send(WebSocketResponse wsResponse) {
        this.channels.stream().filter(c -> c.isOpen()).forEach(c -> c.send(wsResponse));
    }

    @Override
    public void send(String msg) {
        this.channels.stream().filter(c -> c.isOpen()).forEach(c -> c.send(msg));
    }

    @Override
    public void send(ProviderR<String> msgDelegate) {
        this.channels.stream().filter(c -> c.isOpen()).forEach(c -> c.send(msgDelegate));
    }

    @Override
    public boolean isOpen() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? false : first.isOpen();
    }
}

