/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.base64.Base64DecodedString;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBasePerson;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XMetabaseToken;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XResearchActivityCriteria;
import ca.infodata.ofys.data.middle.dataobjects.XResearchType;
import ca.infodata.ofys.data.middle.dataobjects.XRxVigilanceToken;
import ca.infodata.ofys.data.middle.dataobjects.XSearchPersonProfileCriteria;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserDashboardCounts;
import ca.infodata.ofys.data.middle.dataobjects.XUserForSelection;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.notification.SessionLockedNotification;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.dashboard.accessor.EmployeeSyncAccessor;
import ca.infodata.ofys.ui.dashboard.accessor.MetabaseSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.RxVigilanceSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.UserSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CBaseEmployee;
import ca.infodata.ofys.ui.dashboard.models.CBasePerson;
import ca.infodata.ofys.ui.dashboard.models.CBaseProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CBaseUser;
import ca.infodata.ofys.ui.dashboard.models.CEmployee;
import ca.infodata.ofys.ui.dashboard.models.CLaboFilter;
import ca.infodata.ofys.ui.dashboard.models.CLaboFollow;
import ca.infodata.ofys.ui.dashboard.models.CPerson;
import ca.infodata.ofys.ui.dashboard.models.CPersonGroup;
import ca.infodata.ofys.ui.dashboard.models.CProfessional;
import ca.infodata.ofys.ui.dashboard.models.CResearchActivityQuery;
import ca.infodata.ofys.ui.dashboard.models.CSession;
import ca.infodata.ofys.ui.dashboard.models.CSite;
import ca.infodata.ofys.ui.dashboard.models.CUser;
import ca.infodata.ofys.ui.dashboard.models.CUserForSelection;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.encryption.DesEncrypter;
import ca.infodata.util1.encryption.EncryptionException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class UserController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(UserController.class.getName());
    private EmployeeSyncAccessor employeeAccessor = new EmployeeSyncAccessor();
    private UserSyncAccessorClient userAccessor = new UserSyncAccessorClient();
    private RxVigilanceSyncAccessorClient rxvigilanceAccessor = new RxVigilanceSyncAccessorClient();
    private MetabaseSyncAccessorClient metabaseAccessor = new MetabaseSyncAccessorClient();

    public UserController() {
        this.getNotificationSystemConsumer().setHandleOtherMethod(this::handleNotification);
    }

    private void handleNotification(Notification notification) throws Exception {
        DataObjectUpdatedNotification doun;
        if (notification instanceof SessionLockedNotification) {
            XSession x = new XSession();
            x.setId(notification.getSessionId());
            x.setLocked(true);
            CSession jMsg = new CSession(x);
            ServerResponses.sendJsonToSessionId(notification.getSessionId(), "session.update", jMsg);
        } else if (notification instanceof DataObjectUpdatedNotification && (doun = (DataObjectUpdatedNotification)notification).getObject() instanceof XUser) {
            CUser jMsg = new CUser((XUser)doun.getObject());
            ServerResponses.sendJsonToClient(notification.getClientId(), "user.update", (Object)jMsg);
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/User/ws", RouterFunctions.routeAction("/profil", req -> ServerResponses.toJsonActionResult(this.getProfil())), RouterFunctions.routeAction("/lang", req -> ServerResponses.toJsonActionResult(this.getLang())), RouterFunctions.routeAction("/getSession", req -> ServerResponses.toJsonActionResult(this.getCSession())), RouterFunctions.routeAction("/getSessionUser", req -> ServerResponses.toJsonActionResult((Object)this.getSessionUser())), RouterFunctions.routeAction("/get", req -> {
            Integer id = req.getQueryParam("id", Integer.class);
            return ServerResponses.toJsonActionResult((Object)this.getUser(id != null ? id : Application.get().getGlobalInstances().getSessionIdUser()));
        }), RouterFunctions.routeAction("/list", req -> ServerResponses.toJsonActionResult(this.getUsers())), RouterFunctions.routeAction("/listUsersForSelection", req -> ServerResponses.toJsonActionResult(this.listUsersForSelection())), RouterFunctions.routeAction("/sites", req -> ServerResponses.toJsonActionResult(this.getSites())), RouterFunctions.routeAction("/groups", req -> ServerResponses.toJsonActionResult(this.getUserGroup())), RouterFunctions.routeAction("/metabasetoken", req -> {
            Integer q = req.getQueryParam("idQuestion", Integer.class);
            return ServerResponses.toJsonActionResult(this.getMetabaseToken(q));
        }), RouterFunctions.routeAction("/metabasequestion", req -> ServerResponses.toJsonActionResult(this.getMetabaseQuestion())), RouterFunctions.routeAction("/rxvigilancetoken", req -> ServerResponses.toJsonActionResult(this.getRxVigilanceToken())), RouterFunctions.routeAction("/newrxvigilancetoken", req -> {
            Application.get().getGlobalInstances().getSession().rxVigToken = null;
            return ServerResponses.toJsonActionResult(this.getRxVigilanceToken());
        }), RouterFunctions.routeAction("/userDashboardDocsLabosOnlyCounts", req -> {
            Integer idProf = req.getQueryParam("idProf", Integer.class);
            Boolean excludeMySeen = req.getQueryParam("excludeMySeen", Boolean.FALSE, Boolean.class);
            if (idProf != null) {
                XUserDashboardCounts labosDocsCount = this.getUserDashboardDocsLabosOnlyCounts(idProf, excludeMySeen);
                return ServerResponses.toJsonActionResult(labosDocsCount);
            }
            return null;
        }), RouterFunctions.routeAction("/userDashboardCountsAllButSafir", req -> {
            Integer idProf = req.getQueryParam("idProf", Integer.class);
            Boolean excludeMySeen = req.getQueryParam("excludeMySeen", Boolean.FALSE, Boolean.class);
            if (idProf != null) {
                XUserDashboardCounts allButSafir = this.getUserDashboardCountsAllButSafir(idProf, excludeMySeen);
                return ServerResponses.toJsonActionResult(allButSafir);
            }
            return null;
        }), RouterFunctions.routeAction("/userDashboardCountsSafir", req -> ServerResponses.toJsonActionResult(this.getUserDashboardCountsSafir())), RouterFunctions.routeAction("/searchProfiles", req -> ServerResponses.toJsonActionResult(this.searchProfiles(req))), RouterFunctions.routeAction("/getSearchProfilesPage", req -> ServerResponses.toJsonActionResult(this.getSearchProfilesPage(req))), RouterFunctions.routeAction("/employee", req -> {
            Integer id = req.getQueryParam("idPerson", Integer.class);
            if (id != null) {
                return ServerResponses.toJsonActionResult(this.getEmployee(id != null ? id : Application.get().getGlobalInstances().getSessionIdUser()));
            }
            return ServerResponses.ERROR("An idPerson is required to fulfil the request.");
        }), RouterFunctions.routeAction("/allemployees", req -> {
            Boolean getDeleted = req.getQueryParam("getDeleted", Boolean.class);
            getDeleted = getDeleted == null ? false : getDeleted;
            return ServerResponses.toJsonActionResult(ServerResponses.OKReturnObject(this.getAllEmployees(getDeleted)));
        }), RouterFunctions.routeAction("/replacements", req -> {
            Integer idProf = req.getQueryParam("id_prof", Integer.class);
            return ServerResponses.toJsonActionResult(ServerResponses.OKReturnObject(this.getReplacements(idProf)));
        }), RouterFunctions.routeAction("/person", req -> {
            Integer id = req.getQueryParam("idPerson", Integer.class);
            if (id != null) {
                return ServerResponses.toJsonActionResult(this.getPerson(id != null ? id : Application.get().getGlobalInstances().getSessionIdUser()));
            }
            return ServerResponses.ERROR("An idPerson is required to fulfil the request.");
        }), RouterFunctions.routeAction("/employee/typesinuse", req -> ServerResponses.toJsonActionResult(this.employeeAccessor.findEmployeeTypeInUse())), RouterFunctions.routeAction("/employee/save", req -> {
            CEmployee employee = req.getPostBody(CEmployee.class);
            return ServerResponses.toJsonActionResult(this.saveEmployee(employee));
        }), RouterFunctions.routeAction("/unblockUser", req -> {
            Integer idUserAnchor = req.getQueryParam("idUserAnchor", Integer.class);
            return ServerResponses.toJsonActionResult(this.unblockUser(idUserAnchor));
        }), RouterFunctions.routeAction("/prof", req -> {
            Integer id = req.getQueryParam("id", Integer.class);
            if (id != null) {
                return ServerResponses.toJsonActionResult(this.getProf(id));
            }
            return ServerResponses.ERROR("An idPerson is required to fulfil the request.");
        }), RouterFunctions.routeAction("/researchActivities", req -> {
            CResearchActivityQuery query = req.getPostBody(CResearchActivityQuery.class);
            XResearchActivityCriteria criteria = this.getResearchCriteria(query);
            return ServerResponses.toJsonActionResult(this.getResearchActivities(criteria));
        }));
    }

    private XResearchActivityCriteria getResearchCriteria(CResearchActivityQuery query) throws ParseException {
        XResearchActivityCriteria criteria = new XResearchActivityCriteria();
        if (query.dateRange != null) {
            LocalDate date = LocalDate.fromTimeInMillisUTC((Long)query.dateRange);
            criteria.setDateRange(new LocalDateRange(date, date, RangeNotation.CLOSED));
        }
        criteria.setIdProfessionnal(query.getIdProfessionnal());
        EnumSet<XResearchType> temp = EnumSet.noneOf(XResearchType.class);
        for (Integer typeInt : query.getResearchType()) {
            temp.add(XResearchType.from((Integer)typeInt));
        }
        criteria.setResearchType(temp);
        return criteria;
    }

    public ReturnObject unblockUser(Integer idUserAnchor) {
        return this.userAccessor.unblockUser(idUserAnchor);
    }

    public ReturnObject saveEmployee(CEmployee employee) {
        XEmployee xemployee;
        ReturnObject answer;
        XEmployee[] res;
        if (employee.user != null && employee.user.changePassword) {
            try {
                employee.user.encryptedPassword = DesEncrypter.encryptMe((String)new Base64DecodedString(employee.user.newPassword).getDecoded());
                employee.user.encryptedPasswordConfirm = DesEncrypter.encryptMe((String)new Base64DecodedString(employee.user.newPasswordConfirm).getDecoded());
                employee.user.mustChangePassword = true;
            }
            catch (EncryptionException e) {
                logger.log(Level.SEVERE, "password encryption error", e);
                return ServerResponses.ErrorReturnObject("Erreur de sauvegarde du professionel, format du mot de pass invalide");
            }
        }
        if ((res = (answer = this.employeeAccessor.save((IDataObject)(xemployee = employee.x()), true)).getObj() instanceof XEmployee ? new XEmployee[]{(XEmployee)answer.getObj()} : (XEmployee[])answer.getObj()) != null) {
            ArrayList<CEmployee> retour = new ArrayList<CEmployee>();
            for (XEmployee i : res) {
                retour.add(new CEmployee(i));
            }
            answer.setObj(retour);
        }
        return answer;
    }

    private ReturnObject getSearchProfilesPage(IServerRequest req) {
        String referenceId = req.getRequiredQueryParam("referenceId");
        int pageNumber = req.getRequiredQueryParam("pageNumber", Integer.class);
        int nbItemsPerPage = req.getRequiredQueryParam("nbItemsPerPage", Integer.class);
        ReturnObject ret = Application.get().getDataAccessors().getSearchAccessor().getPage(referenceId, pageNumber, nbItemsPerPage);
        ArrayList res = (ArrayList)ret.getObj();
        if (res != null) {
            ArrayList<CPerson> profiles = new ArrayList<CPerson>();
            for (int i = 0; i < res.size(); ++i) {
                if (res.get(i) instanceof XEmployee) {
                    profiles.add(new CEmployee((XEmployee)res.get(i)));
                    continue;
                }
                if (!(res.get(i) instanceof XProfessionnal)) continue;
                profiles.add(new CProfessional((XProfessionnal)res.get(i)));
            }
            ret.setObj(profiles);
        }
        return ret;
    }

    private Object searchProfiles(IServerRequest req) {
        XSearchPersonProfileCriteria criteria = req.getPostBody(XSearchPersonProfileCriteria.class);
        ReturnObject ret = Application.get().getDataAccessors().getSearchAccessor().search((Serializable)criteria);
        return ret;
    }

    public CBaseUser getUser(int id) {
        XBaseUser user = Application.get().getPersonPluginController().getUser(id);
        return new CBaseUser(user);
    }

    public CSession getCSession() {
        CSession cSession = null;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            cSession = new CSession(session);
        }
        return cSession;
    }

    public CUser getSessionUser() {
        XUser user;
        CUser sessionUser = null;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && (user = session.getUser()) != null) {
            sessionUser = new CUser(user);
        }
        return sessionUser;
    }

    public CBaseUser getUserByIdPerson(int id) {
        XBaseUser user = Application.get().getPersonPluginController().getUserByIdPerson(id);
        return new CBaseUser(user);
    }

    public List<CBaseUser> getUsers() {
        ArrayList<CBaseUser> users = new ArrayList<CBaseUser>();
        for (XBaseUser user : Application.get().getPersonPluginController().getUsers()) {
            users.add(new CBaseUser(user));
        }
        return users;
    }

    public List<CUserForSelection> listUsersForSelection() {
        ArrayList<CUserForSelection> res = new ArrayList<CUserForSelection>();
        for (XUserForSelection user : this.userAccessor.listUsersForSelection()) {
            res.add(new CUserForSelection(user));
        }
        return res;
    }

    public List<CPersonGroup> getUserGroup() {
        List<CPersonGroup> res = Application.get().getPersonPluginController().getActivePersonGroups().map(e -> new CPersonGroup((XPersonGroup)e)).collect(Collectors.toList());
        return res;
    }

    public XMetabaseToken getMetabaseToken(Integer q) {
        XMetabaseToken metabaseToken = null;
        ReturnObject newMetabaseToken = this.metabaseAccessor.newMetabaseToken(q);
        if (newMetabaseToken != null && newMetabaseToken.getObj() != null && newMetabaseToken.getObj() instanceof String) {
            String token = (String)newMetabaseToken.getObj();
            metabaseToken = new XMetabaseToken(token);
        } else {
            metabaseToken = null;
        }
        return metabaseToken;
    }

    public ReturnObject getMetabaseQuestion() {
        return this.metabaseAccessor.metabaseQuestion();
    }

    public XRxVigilanceToken getRxVigilanceToken() {
        XRxVigilanceToken rxVigToken = Application.get().getGlobalInstances().getSession().rxVigToken;
        if (rxVigToken == null || rxVigToken.getToken() == null) {
            ReturnObject newRxVigilanceToken = this.rxvigilanceAccessor.newRxVigilanceToken();
            if (newRxVigilanceToken != null && newRxVigilanceToken.getObj() != null && newRxVigilanceToken.getObj() instanceof String) {
                String token = (String)newRxVigilanceToken.getObj();
                rxVigToken = Application.get().getGlobalInstances().getSession().rxVigToken = new XRxVigilanceToken(token);
            } else {
                rxVigToken = null;
            }
        }
        return rxVigToken;
    }

    public XUserDashboardCounts getUserDashboardDocsLabosOnlyCounts(Integer idProf, Boolean excludeMySeen) {
        XUserDashboardCounts udc = null;
        udc = this.userAccessor.getUserDashboardDocsLabosOnlyCounts(idProf, excludeMySeen);
        return udc;
    }

    public XUserDashboardCounts getUserDashboardCountsAllButSafir(Integer idProf, Boolean excludeMySeen) {
        XUserDashboardCounts udc = null;
        udc = this.userAccessor.getUserDashboardCountsAllButSafir(idProf, excludeMySeen);
        XBaseProfessionnal prof = Application.get().getPersonPluginController().getSessionProfessionnal();
        udc.rxvLicence = prof == null || prof.getRxvLicence() == null ? 0 : prof.getRxvLicence().getValue();
        udc.rxvUrl = Application.get().getGlobalInstances().getRxVigilanceConnectionInfo().getServerAddress();
        ArrayList<CLaboFilter> lstLaboFilter = new ArrayList<CLaboFilter>();
        CLaboFilter.getListFromArrayString(lstLaboFilter, udc.laboFilter);
        ArrayList<CLaboFollow> lstLaboFollow = new ArrayList<CLaboFollow>();
        CLaboFollow.getListFromArrayString(lstLaboFollow, udc.laboFollow);
        return this.addEncounterInEdit(udc);
    }

    public XUserDashboardCounts getUserDashboardCountsSafir() {
        XUserDashboardCounts udc = null;
        udc = this.userAccessor.getUserDashboardCountsSafir();
        return udc;
    }

    private XUserDashboardCounts addEncounterInEdit(XUserDashboardCounts c) {
        List<Integer> li = Application.get().getPreSaveController().getAllEncountersPatientId();
        Integer[] edits = new Integer[li.size()];
        li.toArray(edits);
        c.enc_edits = li.size();
        c.enc_edits_id = edits;
        return c;
    }

    public List<CSite> getSites() {
        boolean isAdmin = Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(XUserRole.ADMIN);
        return Application.get().getSitePluginController().getSites().map(site -> {
            if (!isAdmin && Boolean.TRUE.equals(site.isWorkSite)) {
                site = site.clone();
                site.hideFaxCredentials();
            }
            return new CSite((XSite)site);
        }).collect(Collectors.toList());
    }

    public String getLang() {
        if (LocaleProvider.isFrench()) {
            return "fr";
        }
        if (LocaleProvider.isEnglish()) {
            return "en";
        }
        if (LocaleProvider.isSpanish()) {
            return "es";
        }
        return "fr";
    }

    public List<Object> allprofiles() {
        ArrayList<Object> users = new ArrayList<Object>();
        for (XBaseUser user : Application.get().getPersonPluginController().getUsers()) {
            XBaseEmployee e = Application.get().getPersonPluginController().getBaseEmployeeByIdPerson(user.idPerson);
            if (!e.equals(null)) continue;
            users.add(e);
        }
        return users;
    }

    public CBaseEmployee getEmployee(int id) {
        XBaseEmployee emp = Application.get().getPersonPluginController().getBaseEmployeeByIdPerson(id);
        return emp == null ? null : new CBaseEmployee(emp);
    }

    public List<CBaseEmployee> getAllEmployees(Boolean getDeleted) {
        List emp = Application.get().getPersonPluginController().getAllBaseEmployees().stream().distinct().collect(Collectors.toList());
        ArrayList<CBaseEmployee> res = new ArrayList<CBaseEmployee>();
        for (int i = 0; i < emp.size(); ++i) {
            if (!getDeleted.booleanValue() && ((XBaseEmployee)emp.get((int)i)).isDeleted) continue;
            res.add(new CBaseEmployee((XBaseEmployee)emp.get(i)));
        }
        return res;
    }

    public List<CBaseProfessionnal> getReplacements(Integer idProf) {
        List<Object> emp = new ArrayList();
        if (idProf != null) {
            emp = Application.get().getPersonPluginController().getWhoProfReplace(idProf, LocalDate.today()).distinct().collect(Collectors.toList());
        }
        ArrayList<CBaseProfessionnal> res = new ArrayList<CBaseProfessionnal>();
        for (int i = 0; i < emp.size(); ++i) {
            res.add(new CBaseProfessionnal((XBaseProfessionnal)emp.get(i)));
        }
        return res;
    }

    public CBasePerson getPerson(int id) {
        XBasePerson person = Application.get().getPersonPluginController().getBasePersonByIdPerson(id);
        return person == null ? null : new CBasePerson(person);
    }

    public CBasePerson getProfil() {
        XBaseProfessionnal prof = Application.get().getPersonPluginController().getSessionProfessionnal();
        if (prof == null) {
            XBaseEmployee employee = Application.get().getPersonPluginController().getSessionEmployee();
            return new CBaseEmployee(employee);
        }
        return new CBaseProfessionnal(prof);
    }

    public CBaseProfessionnal getProf(int id) {
        XBaseProfessionnal prof = Application.get().getPersonPluginController().getBaseProfessionnal(id);
        return new CBaseProfessionnal(prof);
    }

    public Object getResearchActivities(XResearchActivityCriteria criteria) {
        XResearchActivityCriteria research = this.userAccessor.getResearchActivities(criteria);
        CResearchActivityQuery re = new CResearchActivityQuery(research);
        if (re.getLstCEncounter() != null) {
            Integer sessionIdUser = Application.get().getGlobalInstances().getSessionIdUser();
            CEncounter.CEncounterMapArg arg = new CEncounter.CEncounterMapArg();
            arg.profNameResolver = new ProviderAR<Integer, String>(){

                public String get(Integer idProf) {
                    return UserController.getProfName(idProf);
                }
            };
            for (CEncounter x : re.getLstCEncounter()) {
                x.uid = Utils.getNewAtomicInteger();
                x.fromSearch = true;
                x.map(arg);
                if (x.getLstNote() == null) continue;
                for (CEncounter.EncounterNote p : x.getLstNote()) {
                    if (p.getIdUserAnchor() == null) continue;
                    p.isPrivate = Boolean.TRUE;
                    if (sessionIdUser.equals(p.getIdUserAnchor())) continue;
                    p.note = "\u2256*" + Messages.getString((String)"PrivateNoteOf", (String[])new String[0]) + "*";
                    p.isReadOnly = Boolean.TRUE;
                }
            }
        }
        return re;
    }

    private static String getProfName(Integer idProf) {
        XBaseProfessionnal prof;
        if (idProf != null && (prof = Application.get().getPersonPluginController().getBaseProfessionnal(idProf)) != null) {
            return String.format("%s (%s)", prof.getName(), prof.getCode());
        }
        return null;
    }
}

