/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.routes.RequestPredicates;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.dataaccess.IRTSSOAuthAccessor;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import java.net.MalformedURLException;
import java.net.URL;

public class RTSSOAuthController
extends AbstractWebController {
    private final IRTSSOAuthAccessor accessor = Application.get().getDataAccessors().getRtssOAuthAccessor();

    private String getRedirectUri() {
        URL publicURL = WebApplication.get().getPublicURL();
        try {
            URL redirectURL = new URL(publicURL.getProtocol(), publicURL.getHost(), publicURL.getPort(), "/AuthorizationCallback/Ramq");
            return redirectURL.toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to construct redirectUri from public url " + publicURL);
        }
    }

    private String getLogoutRedirectUri() {
        URL publicURL = WebApplication.get().getPublicURL();
        try {
            URL redirectURL = new URL(publicURL.getProtocol(), publicURL.getHost(), publicURL.getPort(), "/LogoutCallback/Ramq");
            return redirectURL.toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to construct redirectUri from public url " + publicURL);
        }
    }

    private String getRedirectUriForOffLineToken() {
        URL publicURL = WebApplication.get().getPublicURL();
        try {
            URL redirectURL = new URL(publicURL.getProtocol(), publicURL.getHost(), publicURL.getPort(), "/AuthorizationCallback/Ramq/OfflineToken");
            return redirectURL.toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to construct redirectUri from public url " + publicURL);
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes(RouterFunctions.routeAction(RequestPredicates.get("/AuthorizationCallback/Ramq"), this::authorizationCallback), RouterFunctions.routeAction(RequestPredicates.get("/AuthorizationCallback/Ramq/OfflineToken"), this::authorizationCallbackOfflineToken), RouterFunctions.routes("/dashboard/oauth/rtss", RouterFunctions.routeReturnObject("/getAuthUrl", this::getAuthUrl)));
    }

    private ReturnObject getAuthUrl(IServerRequest req) {
        String redirectUri = this.getRedirectUri();
        return this.accessor.getAuthUrl(redirectUri);
    }

    private ActionResult authorizationCallback(IServerRequest req) {
        String code = req.getQueryParam("code");
        String redirectUri = this.getRedirectUri();
        ReturnObject r = this.accessor.obtainAccessTokenWithAuthCode(redirectUri, code);
        if (r.getStatus().getStatus("rtss-oauth-noOfflineToken") != null || r.getStatus().getStatus("rtss-oauth-expiredOfflineToken") != null) {
            String redirectLocation = (String)this.accessor.getAuthUrl(this.getRedirectUriForOffLineToken()).getObj();
            return ServerResponses.REDIRECT(redirectLocation);
        }
        if (r.getStatus().isOkToProceed()) {
            MultiStatus status = new MultiStatus();
            status.add((IStatus)r.getStatus());
            status.add((IStatus)new Status(IStatus.Severity.INFO, "Vous pouvez fermer cette page"));
            return ServerResponses.statusPage("Ofys Pro - Obtenir un jeton d'acc\u00e8s", (IStatus)status);
        }
        MultiStatus status = new MultiStatus();
        status.add((IStatus)r.getStatus());
        status.add((IStatus)new Status(IStatus.Severity.INFO, "Veuillez fermer cette page et r\u00e9-essayer."));
        return ServerResponses.statusPage("Ofys Pro - Obtenir un jeton d'acc\u00e8s", (IStatus)status);
    }

    private ActionResult authorizationCallbackOfflineToken(IServerRequest req) {
        String code = req.getQueryParam("code");
        String redirectUri = this.getRedirectUriForOffLineToken();
        ReturnObject r = this.accessor.obtainAccessTokenWithAuthCode(redirectUri, code);
        if (r.getStatus().isOkToProceed()) {
            MultiStatus status = new MultiStatus();
            status.add((IStatus)r.getStatus());
            status.add((IStatus)new Status(IStatus.Severity.INFO, "Vous pouvez fermer cette page"));
            return ServerResponses.statusPage("Ofys Pro - Obtenir un jeton d'acc\u00e8s", (IStatus)status);
        }
        MultiStatus status = new MultiStatus();
        status.add((IStatus)r.getStatus());
        status.add((IStatus)new Status(IStatus.Severity.INFO, "Veuillez fermer cette page et r\u00e9-essayer."));
        return ServerResponses.statusPage("Ofys Pro - Obtenir un jeton d'acc\u00e8s", (IStatus)status);
    }

    public ReturnObject signOut(IServerRequest req) {
        return this.accessor.logOut(this.getRedirectUri());
    }
}

