/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import ca.infodata.dsq.domain.BasicProvider;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_I;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class IProviderJsonTypeAdapter
extends TypeAdapter<IProvider> {
    private TypeAdapter<Code> codeAdapter;
    private TypeAdapter<NIU> niuAdapter;

    public IProviderJsonTypeAdapter(TypeAdapter<Code> codeAdapter, TypeAdapter<NIU> niuAdapter) {
        this.codeAdapter = codeAdapter;
        this.niuAdapter = niuAdapter;
    }

    public void write(JsonWriter out, IProvider provider) throws IOException {
        if (provider != null) {
            out.beginObject();
            out.name("code");
            if (provider.getCode() == null) {
                out.nullValue();
            } else {
                this.codeAdapter.write(out, (Object)provider.getCode());
            }
            out.name("firstName");
            out.value(provider.getFirstName());
            out.name("lastName");
            out.value(provider.getLastName());
            out.name("niu_i");
            if (provider.getNIU_I() == null) {
                out.nullValue();
            } else {
                this.niuAdapter.write(out, (Object)provider.getNIU_I());
            }
            out.name("niu_college");
            if (provider.getNIU_COLLEGE() == null) {
                out.nullValue();
            } else {
                this.niuAdapter.write(out, (Object)provider.getNIU_COLLEGE());
            }
            out.endObject();
        } else {
            out.nullValue();
        }
    }

    public IProvider read(JsonReader in) throws IOException {
        Code code = null;
        String firstName = null;
        String lastName = null;
        NIU_I niuI = null;
        NIU niuCollege = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if ("code".equals(name)) {
                code = (Code)this.codeAdapter.read(in);
                continue;
            }
            if ("firstName".equals(name)) {
                firstName = in.nextString();
                continue;
            }
            if ("lastName".equals(name)) {
                lastName = in.nextString();
                continue;
            }
            if ("niu_i".equals(name)) {
                niuI = (NIU_I)this.niuAdapter.read(in);
                continue;
            }
            if (!"niu_college".equals(name)) continue;
            try {
                niuCollege = (NIU)this.niuAdapter.read(in);
            }
            catch (JsonIOException e) {
                e.printStackTrace();
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
        in.endObject();
        return new BasicProvider(niuI, niuCollege, firstName, lastName, null, code);
    }
}

