/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.lifecycle;

import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImplBuilder;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectBuilder;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.io.netty.channel.EventLoop;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.mqtt5.lifecycle.Mqtt5ClientReconnector;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class MqttClientReconnector
implements Mqtt5ClientReconnector {
    @NotNull
    private final EventLoop eventLoop;
    private final int attempts;
    private boolean reconnect = false;
    @Nullable
    private CompletableFuture<?> future;
    private boolean resubscribeIfSessionExpired = true;
    private boolean republishIfSessionExpired = false;
    private long delayNanos = TimeUnit.MILLISECONDS.toNanos(0L);
    @NotNull
    private MqttClientTransportConfigImpl transportConfig;
    @NotNull
    private MqttConnect connect;
    private boolean afterOnDisconnected;

    public MqttClientReconnector(@NotNull EventLoop eventLoop, int attempts, @NotNull MqttConnect connect, @NotNull MqttClientTransportConfigImpl transportConfig) {
        this.eventLoop = eventLoop;
        this.attempts = attempts;
        this.connect = connect;
        this.transportConfig = transportConfig;
    }

    @Override
    public int getAttempts() {
        this.checkInEventLoop();
        return this.attempts;
    }

    @Override
    @NotNull
    public MqttClientReconnector reconnect(boolean reconnect) {
        this.checkInEventLoop();
        this.reconnect = reconnect;
        return this;
    }

    @Override
    @NotNull
    public <T> MqttClientReconnector reconnectWhen(@Nullable CompletableFuture<T> future, @Nullable BiConsumer<? super T, ? super Throwable> callback) {
        this.checkInOnDisconnected("reconnectWhen");
        Checks.notNull(future, "Future");
        this.reconnect = true;
        if (callback != null) {
            future = future.whenCompleteAsync(callback, (Executor)this.eventLoop);
        }
        this.future = this.future == null ? future : CompletableFuture.allOf(new CompletableFuture[]{this.future, future});
        return this;
    }

    @Override
    public boolean isReconnect() {
        this.checkInEventLoop();
        return this.reconnect;
    }

    @NotNull
    public CompletableFuture<?> getFuture() {
        this.checkInEventLoop();
        return this.future == null ? CompletableFuture.completedFuture(null) : this.future;
    }

    @Override
    @NotNull
    public MqttClientReconnector resubscribeIfSessionExpired(boolean resubscribe) {
        this.checkInOnDisconnected("resubscribeIfSessionExpired");
        this.resubscribeIfSessionExpired = resubscribe;
        return this;
    }

    @Override
    public boolean isResubscribeIfSessionExpired() {
        this.checkInEventLoop();
        return this.resubscribeIfSessionExpired;
    }

    @Override
    @NotNull
    public MqttClientReconnector republishIfSessionExpired(boolean republish) {
        this.checkInOnDisconnected("republishIfSessionExpired");
        this.republishIfSessionExpired = republish;
        return this;
    }

    @Override
    public boolean isRepublishIfSessionExpired() {
        this.checkInEventLoop();
        return this.republishIfSessionExpired;
    }

    @Override
    @NotNull
    public MqttClientReconnector delay(long delay, @Nullable TimeUnit timeUnit) {
        this.checkInOnDisconnected("delay");
        Checks.notNull(timeUnit, "Time unit");
        this.delayNanos = timeUnit.toNanos(delay);
        return this;
    }

    @Override
    public long getDelay(@NotNull TimeUnit timeUnit) {
        this.checkInEventLoop();
        Checks.notNull(timeUnit, "Time unit");
        return timeUnit.convert(this.delayNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public MqttClientReconnector transportConfig(@Nullable MqttClientTransportConfig transportConfig) {
        this.checkInEventLoop();
        this.transportConfig = Checks.notImplemented(transportConfig, MqttClientTransportConfigImpl.class, "Transport config");
        return this;
    }

    public @NotNull MqttClientTransportConfigImplBuilder.Nested<MqttClientReconnector> transportConfig() {
        this.checkInEventLoop();
        return new MqttClientTransportConfigImplBuilder.Nested<MqttClientReconnector>(this.transportConfig, this::transportConfig);
    }

    @Override
    @NotNull
    public MqttClientTransportConfigImpl getTransportConfig() {
        this.checkInEventLoop();
        return this.transportConfig;
    }

    @Override
    @NotNull
    public MqttClientReconnector connect(@Nullable Mqtt5Connect connect) {
        this.checkInEventLoop();
        this.connect = MqttChecks.connect(connect);
        return this;
    }

    public  @NotNull MqttConnectBuilder.Nested<MqttClientReconnector> connectWith() {
        this.checkInEventLoop();
        return new MqttConnectBuilder.Nested<MqttClientReconnector>(this.connect, this::connect);
    }

    @Override
    @NotNull
    public MqttConnect getConnect() {
        this.checkInEventLoop();
        return this.connect;
    }

    public void afterOnDisconnected() {
        this.afterOnDisconnected = true;
    }

    private void checkInEventLoop() {
        Checks.state(this.eventLoop.inEventLoop(), "MqttClientReconnector must be called from the eventLoop.");
    }

    private void checkInOnDisconnected(@NotNull String method) {
        this.checkInEventLoop();
        if (this.afterOnDisconnected) {
            throw new UnsupportedOperationException(method + " must only be called in onDisconnected.");
        }
    }
}

