/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.restful;

import ca.infodata.util1.group.GAnd;
import ca.infodata.util1.group.GCriteria;
import ca.infodata.util1.group.GOperator;
import ca.infodata.util1.group.GOr;
import ca.infodata.util1.group.Group;
import ca.infodata.util1.restful.JsonTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.ext.Provider;

@Provider
public class GroupTypeAdapter
extends TypeAdapter<Group>
implements JsonTypeAdapter<Group> {
    private Gson gson;

    @Override
    public boolean asHierarchyAdapter() {
        return true;
    }

    @Override
    public Class<Group> type() {
        return Group.class;
    }

    public void write(JsonWriter out, Group value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("class");
        out.value(value.getClass().getSimpleName());
        if (value instanceof GCriteria) {
            out.name("id").value(((GCriteria)value).id);
            out.name("op").value(((GCriteria)value).operator.name());
            out.name("value");
            this.writeObject(out, ((GCriteria)value).value);
        } else {
            out.name("items");
            out.beginArray();
            for (Group item : value.items()) {
                this.write(out, item);
            }
            out.endArray();
        }
        out.endObject();
    }

    private void writeObject(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.beginObject();
            out.name("class");
            out.value(value.getClass().getName());
            out.name("value");
            this.getGson().toJson(value, value.getClass(), out);
            out.endObject();
        }
    }

    public Group read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String classname = null;
        String id = null;
        String op = null;
        Object value = null;
        ArrayList<Group> items = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if ("class".equals(name)) {
                classname = in.nextString();
                continue;
            }
            if ("id".equals(name)) {
                id = in.nextString();
                continue;
            }
            if ("op".equals(name)) {
                op = in.nextString();
                continue;
            }
            if ("value".equals(name)) {
                value = this.readObject(in);
                continue;
            }
            if (!"items".equals(name)) continue;
            in.beginArray();
            items = new ArrayList<Group>();
            while (in.hasNext()) {
                items.add(this.read(in));
            }
            in.endArray();
        }
        in.endObject();
        return this.newGroup(classname, id, op, value, items);
    }

    private Object readObject(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        String classname = null;
        String value = null;
        while (in.hasNext()) {
            String name = in.nextName();
            if ("class".equals(name)) {
                classname = in.nextString();
                continue;
            }
            if (!"value".equals(name)) continue;
            value = in.nextString();
        }
        in.endObject();
        try {
            return this.getGson().fromJson(value, Class.forName(classname));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private Group newGroup(String classname, String id, String op, Object value, List<Group> items) {
        GOr group = null;
        if ("GOr".equals(classname)) {
            group = new GOr();
            group.items().addAll(items);
        } else if ("GAnd".equals(classname)) {
            group = new GAnd();
            group.items().addAll(items);
        } else if ("GCriteria".equals(classname)) {
            GCriteria c = new GCriteria();
            c.id = id;
            c.operator = GOperator.valueOf((String)op);
            c.value = value;
            group = c;
        } else {
            throw new RuntimeException("invalid class " + classname);
        }
        return group;
    }

    @Override
    public void setGson(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }
}

