/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.group;

import ca.infodata.util1.group.GAnd;
import ca.infodata.util1.group.GOr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Group
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Group> items = new ArrayList<Group>();

    public List<Group> items() {
        return this.items;
    }

    public List<Group> getItems() {
        return this.items;
    }

    public abstract Group add(Group var1);

    public static void simplifiy(Group g) {
        Group.simplifyGroup(g);
    }

    private static boolean simplifyGroup(Group g) {
        if (g instanceof GAnd) {
            return Group.simplifyAnd((GAnd)g);
        }
        if (g instanceof GOr) {
            return Group.simplifyOr((GOr)g);
        }
        return false;
    }

    private static boolean simplifyOr(GOr g) {
        boolean simplified;
        do {
            simplified = false;
            for (Group e : g.items()) {
                simplified = Group.simplifyGroup(e) | simplified;
            }
        } while (simplified);
        simplified = false;
        ArrayList<Group> items2 = new ArrayList<Group>();
        for (Group group : g.items()) {
            if (group instanceof GOr) {
                items2.addAll(group.items());
                simplified = true;
                continue;
            }
            items2.add(group);
        }
        if (simplified) {
            g.items().clear();
            g.items().addAll(items2);
        }
        return simplified;
    }

    private static boolean simplifyAnd(GAnd g) {
        boolean simplified;
        do {
            simplified = false;
            for (Group e : g.items()) {
                simplified = Group.simplifyGroup(e) | simplified;
            }
        } while (simplified);
        simplified = false;
        ArrayList<Group> items2 = new ArrayList<Group>();
        for (Group group : g.items()) {
            if (group instanceof GAnd) {
                items2.addAll(group.items());
                simplified = true;
                continue;
            }
            items2.add(group);
        }
        if (simplified) {
            g.items().clear();
            g.items().addAll(items2);
        }
        return simplified;
    }
}

