/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.test;

import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class TimeTest {
    public static boolean enabled = false;
    private static ThreadLocal<Map<String, ArrayList<Long>>> cache = new ThreadLocal<Map<String, ArrayList<Long>>>(){

        @Override
        protected Map<String, ArrayList<Long>> initialValue() {
            return new LinkedHashMap<String, ArrayList<Long>>(20);
        }
    };

    public static void tick(String key) {
        if (enabled) {
            long time = System.currentTimeMillis();
            Map<String, ArrayList<Long>> map = cache.get();
            ArrayList<Long> list = map.get(key);
            if (list == null) {
                list = new ArrayList(100);
                map.put(key, list);
            }
            list.add(time);
        }
    }

    public static void reset() {
        if (enabled) {
            cache.get().clear();
        }
    }

    public static void printTimes() {
        if (enabled) {
            JoinList s = new JoinList("\n");
            Set<Map.Entry<String, ArrayList<Long>>> entrySet = cache.get().entrySet();
            for (Map.Entry<String, ArrayList<Long>> entry : entrySet) {
                String key = entry.getKey();
                ArrayList<Long> list = entry.getValue();
                if (list.size() != 0 && list.size() % 2 != 0) {
                    list.remove(list.size() - 1);
                }
                if (list.size() > 2) {
                    SummaryStatistics stats = new SummaryStatistics();
                    List<Long> times = TimeTest.computeTimes(list);
                    for (Long time : times) {
                        stats.addValue(time.doubleValue());
                    }
                    JoinList text = new JoinList(" | ");
                    text.add("count=", String.valueOf(times.size()));
                    text.add("mean=", String.valueOf((long)stats.getMean()));
                    text.add("standard-deviation=", String.valueOf((long)stats.getStandardDeviation()));
                    text.add("shortest=", String.valueOf((long)stats.getMin()));
                    text.add("longest=", String.valueOf((long)stats.getMax()));
                    text.add("total=", String.valueOf((long)stats.getSum()));
                    s.add("\n" + key + "= | ", text.toString());
                    continue;
                }
                if (list.size() != 2) continue;
                s.add("\n" + key + "=", String.valueOf(list.get(1) - list.get(0)));
            }
            System.out.println("TimeTest:\n" + s);
        }
    }

    private static List<Long> computeTimes(List<Long> list) {
        ArrayList<Long> times2 = new ArrayList<Long>(list.size() / 2);
        for (int i = 0; i < list.size(); i += 2) {
            times2.add(list.get(i + 1) - list.get(i));
        }
        Collections.sort(times2);
        return times2;
    }
}

