/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.config;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.config.ConfigKey;
import java.util.logging.Logger;

public class EnumConfigKey<T extends Enum<T>>
extends ConfigKey<T> {
    private static final Logger logger = Logger.getLogger(EnumConfigKey.class.getName());
    private Class<T> enumClass;

    public EnumConfigKey(String key, Class<T> enumClass) {
        super(key);
        this.enumClass = enumClass;
    }

    @Override
    public EnumConfigKey<T> setDefaultValue(T value) {
        return (EnumConfigKey)super.setDefaultValue(value);
    }

    @Override
    protected T convertFoundValueToT(Object value) {
        if (value == null) {
            return (T)((Enum)this.getDefaultValue());
        }
        if (this.enumClass.isAssignableFrom(value.getClass())) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            String s = (String)value;
            if (StringUtils.isBlank(s)) {
                return (T)((Enum)this.getDefaultValue());
            }
            try {
                return Enum.valueOf(this.enumClass, s.toUpperCase());
            }
            catch (Exception e) {
                try {
                    return Enum.valueOf(this.enumClass, s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        logger.severe("invalid value type for property with key " + this + ". expected enum value of type " + this.enumClass.getName() + " was " + value.getClass().getName() + ". using default value.");
        return (T)((Enum)this.getDefaultValue());
    }
}

