/*
 * Decompiled with CFR 0.152.
 */
package org.ga.log.ro;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.ga.log.ro.RolloverStrategy;

class FileSizeRolloverStrategy
implements RolloverStrategy {
    private static final String KEY_FILE_SIZE = "simplelog.rollover.fileSize.size";
    private static final String FILE_SIZE_DEFAULT = "100M";
    private static final char[] factorUnits = new char[]{'B', 'K', 'M', 'G', 'T'};
    private long rolloverSize;
    private boolean rolloverSizeSetProgramatically = false;

    FileSizeRolloverStrategy() {
        this.rolloverSize = -1L;
    }

    public FileSizeRolloverStrategy(long rolloverSize) {
        this.setRolloverSize(rolloverSize);
    }

    @Override
    public void configure(Map<?, ?> properties) throws IOException {
        if (this.rolloverSizeSetProgramatically) {
            return;
        }
        String fileSizeString = (String)properties.get(KEY_FILE_SIZE);
        fileSizeString = fileSizeString == null ? FILE_SIZE_DEFAULT : fileSizeString.trim();
        if (fileSizeString.length() == 0) {
            fileSizeString = FILE_SIZE_DEFAULT;
        }
        long fileSize = this.decodeFileSize(fileSizeString);
        this.setRolloverSizeInernal(fileSize);
    }

    private long decodeFileSize(String fileSizeString) throws IOException {
        try {
            int lastCharacterIndex = fileSizeString.length() - 1;
            String sizeOnlyString = fileSizeString.substring(0, lastCharacterIndex);
            long fileSize = Long.parseLong(sizeOnlyString);
            char lastCharacter = fileSizeString.charAt(lastCharacterIndex);
            lastCharacter = Character.toUpperCase(lastCharacter);
            boolean factorIdentified = false;
            for (int factor = 0; !factorIdentified && factor < factorUnits.length; ++factor) {
                char factorAbbreviation = factorUnits[factor];
                if (lastCharacter != factorAbbreviation) continue;
                factorIdentified = true;
                fileSize *= 1L << factor * 10;
            }
            if (!factorIdentified) {
                throw new IOException("The specified file size does not conform to the required pattern: " + fileSizeString);
            }
            return fileSize;
        }
        catch (NumberFormatException e) {
            throw new IOException("Specified file size does not conform to the required pattern: " + fileSizeString);
        }
    }

    @Override
    public boolean rolloverNow(Date fileCreated, long fileLength) {
        if (this.rolloverSize == -1L) {
            throw new IllegalStateException("FileSizeRolloverStrategy has not been configured.");
        }
        return fileLength >= this.rolloverSize;
    }

    public long getRolloverSize() {
        return this.rolloverSize;
    }

    public void setRolloverSize(long rolloverSize) {
        this.setRolloverSizeInernal(rolloverSize);
        this.rolloverSizeSetProgramatically = true;
    }

    private void setRolloverSizeInernal(long rolloverSize) {
        if (rolloverSize < 1L) {
            throw new IllegalArgumentException("rolloverSize must be > 0");
        }
        this.rolloverSize = rolloverSize;
    }
}

