/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.RCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RDF
extends AbstractSegment {
    public RDF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Number of Columns per Row");
            this.add(RCD.class, true, 0, 0, new Object[]{this.getMessage()}, "Column Description");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDF - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getNumberOfColumnsPerRow() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRdf1_NumberOfColumnsPerRow() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public RCD[] getColumnDescription() {
        RCD[] retVal = (RCD[])this.getTypedField(2, new RCD[0]);
        return retVal;
    }

    public RCD[] getRdf2_ColumnDescription() {
        RCD[] retVal = (RCD[])this.getTypedField(2, new RCD[0]);
        return retVal;
    }

    public int getColumnDescriptionReps() {
        return this.getReps(2);
    }

    public RCD getColumnDescription(int rep) {
        RCD retVal = (RCD)this.getTypedField(2, rep);
        return retVal;
    }

    public RCD getRdf2_ColumnDescription(int rep) {
        RCD retVal = (RCD)this.getTypedField(2, rep);
        return retVal;
    }

    public int getRdf2_ColumnDescriptionReps() {
        return this.getReps(2);
    }

    public RCD insertColumnDescription(int rep) throws HL7Exception {
        return (RCD)super.insertRepetition(2, rep);
    }

    public RCD insertRdf2_ColumnDescription(int rep) throws HL7Exception {
        return (RCD)super.insertRepetition(2, rep);
    }

    public RCD removeColumnDescription(int rep) throws HL7Exception {
        return (RCD)super.removeRepetition(2, rep);
    }

    public RCD removeRdf2_ColumnDescription(int rep) throws HL7Exception {
        return (RCD)super.removeRepetition(2, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new RCD(this.getMessage());
            }
        }
        return null;
    }
}

