/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.group.OPR_O38_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v281.group.OPR_O38_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v281.group.OPR_O38_TIMING;
import ca.uhn.hl7v2.model.v281.segment.SAC;
import ca.uhn.hl7v2.model.v281.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPR_O38_SPECIMEN
extends AbstractGroup {
    public OPR_O38_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OPR_O38_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(SAC.class, false, true, false);
            this.add(OPR_O38_OBSERVATION_REQUEST.class, false, true, false);
            this.add(OPR_O38_TIMING.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPR_O38_SPECIMEN - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OPR_O38_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OPR_O38_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", OPR_O38_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OPR_O38_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OPR_O38_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", rep, OPR_O38_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OPR_O38_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OPR_O38_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OPR_O38_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", structure, rep);
    }

    public OPR_O38_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPR_O38_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OPR_O38_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPR_O38_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public SAC getSAC() {
        SAC retVal = this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public SAC getSAC(int rep) {
        SAC retVal = this.getTyped("SAC", rep, SAC.class);
        return retVal;
    }

    public int getSACReps() {
        return this.getReps("SAC");
    }

    public List<SAC> getSACAll() throws HL7Exception {
        return this.getAllAsList("SAC", SAC.class);
    }

    public void insertSAC(SAC structure, int rep) throws HL7Exception {
        super.insertRepetition("SAC", structure, rep);
    }

    public SAC insertSAC(int rep) throws HL7Exception {
        return (SAC)super.insertRepetition("SAC", rep);
    }

    public SAC removeSAC(int rep) throws HL7Exception {
        return (SAC)super.removeRepetition("SAC", rep);
    }

    public OPR_O38_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        OPR_O38_OBSERVATION_REQUEST retVal = this.getTyped("OBSERVATION_REQUEST", OPR_O38_OBSERVATION_REQUEST.class);
        return retVal;
    }

    public OPR_O38_OBSERVATION_REQUEST getOBSERVATION_REQUEST(int rep) {
        OPR_O38_OBSERVATION_REQUEST retVal = this.getTyped("OBSERVATION_REQUEST", rep, OPR_O38_OBSERVATION_REQUEST.class);
        return retVal;
    }

    public int getOBSERVATION_REQUESTReps() {
        return this.getReps("OBSERVATION_REQUEST");
    }

    public List<OPR_O38_OBSERVATION_REQUEST> getOBSERVATION_REQUESTAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION_REQUEST", OPR_O38_OBSERVATION_REQUEST.class);
    }

    public void insertOBSERVATION_REQUEST(OPR_O38_OBSERVATION_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION_REQUEST", structure, rep);
    }

    public OPR_O38_OBSERVATION_REQUEST insertOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPR_O38_OBSERVATION_REQUEST)super.insertRepetition("OBSERVATION_REQUEST", rep);
    }

    public OPR_O38_OBSERVATION_REQUEST removeOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPR_O38_OBSERVATION_REQUEST)super.removeRepetition("OBSERVATION_REQUEST", rep);
    }

    public OPR_O38_TIMING getTIMING() {
        OPR_O38_TIMING retVal = this.getTyped("TIMING", OPR_O38_TIMING.class);
        return retVal;
    }

    public OPR_O38_TIMING getTIMING(int rep) {
        OPR_O38_TIMING retVal = this.getTyped("TIMING", rep, OPR_O38_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<OPR_O38_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", OPR_O38_TIMING.class);
    }

    public void insertTIMING(OPR_O38_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public OPR_O38_TIMING insertTIMING(int rep) throws HL7Exception {
        return (OPR_O38_TIMING)super.insertRepetition("TIMING", rep);
    }

    public OPR_O38_TIMING removeTIMING(int rep) throws HL7Exception {
        return (OPR_O38_TIMING)super.removeRepetition("TIMING", rep);
    }
}

