/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.segment.ADJ;
import ca.uhn.hl7v2.model.v281.segment.LOC;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.PSL;
import ca.uhn.hl7v2.model.v281.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E20_PSL_ITEM_INFO
extends AbstractGroup {
    public EHC_E20_PSL_ITEM_INFO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSL.class, true, false, true);
            this.add(NTE.class, false, true, true);
            this.add(ADJ.class, false, true, true);
            this.add(LOC.class, false, true, true);
            this.add(PRT.class, false, true, true);
            this.add(ROL.class, false, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E20_PSL_ITEM_INFO - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PSL getPSL() {
        PSL retVal = this.getTyped("PSL", PSL.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ADJ getADJ() {
        ADJ retVal = this.getTyped("ADJ", ADJ.class);
        return retVal;
    }

    public ADJ getADJ(int rep) {
        ADJ retVal = this.getTyped("ADJ", rep, ADJ.class);
        return retVal;
    }

    public int getADJReps() {
        return this.getReps("ADJ");
    }

    public List<ADJ> getADJAll() throws HL7Exception {
        return this.getAllAsList("ADJ", ADJ.class);
    }

    public void insertADJ(ADJ structure, int rep) throws HL7Exception {
        super.insertRepetition("ADJ", structure, rep);
    }

    public ADJ insertADJ(int rep) throws HL7Exception {
        return (ADJ)super.insertRepetition("ADJ", rep);
    }

    public ADJ removeADJ(int rep) throws HL7Exception {
        return (ADJ)super.removeRepetition("ADJ", rep);
    }

    public LOC getLOC() {
        LOC retVal = this.getTyped("LOC", LOC.class);
        return retVal;
    }

    public LOC getLOC(int rep) {
        LOC retVal = this.getTyped("LOC", rep, LOC.class);
        return retVal;
    }

    public int getLOCReps() {
        return this.getReps("LOC");
    }

    public List<LOC> getLOCAll() throws HL7Exception {
        return this.getAllAsList("LOC", LOC.class);
    }

    public void insertLOC(LOC structure, int rep) throws HL7Exception {
        super.insertRepetition("LOC", structure, rep);
    }

    public LOC insertLOC(int rep) throws HL7Exception {
        return (LOC)super.insertRepetition("LOC", rep);
    }

    public LOC removeLOC(int rep) throws HL7Exception {
        return (LOC)super.removeRepetition("LOC", rep);
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ROL getROL() {
        ROL retVal = this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }
}

