/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CNE;
import ca.uhn.hl7v2.model.v28.datatype.CQ;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.CX;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.SN;
import ca.uhn.hl7v2.model.v28.datatype.TM;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SCD
extends AbstractSegment {
    public SCD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TM.class, false, 1, 0, new Object[]{this.getMessage()}, "Cycle Start Time");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Cycle Count");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Temp Max");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Temp Min");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Load Number");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Condition Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Sterilize Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Exhaust Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Cycle Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Device Status");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Cycle Start Date/Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Dry Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Leak Rate");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Control Temperature");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Sterilizer Temperature");
            this.add(TM.class, false, 1, 0, new Object[]{this.getMessage()}, "Cycle Complete Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Under Temperature");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Over Temperature");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Abort Cycle");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Alarm");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Long in Charge Phase");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Long in Exhaust Phase");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Long in Fast Exhaust Phase");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Reset");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Operator - Unload");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Door Open");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Reading Failure");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Cycle Type");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Thermal Rinse Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Wash Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Injection Rate");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Patient Identifier List");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Attending Doctor");
            this.add(SN.class, false, 1, 0, new Object[]{this.getMessage()}, "Dilution Factor");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Fill Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Inlet Temperature");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SCD - this is probably a bug in the source code generator.", e);
        }
    }

    public TM getCycleStartTime() {
        TM retVal = (TM)this.getTypedField(1, 0);
        return retVal;
    }

    public TM getScd1_CycleStartTime() {
        TM retVal = (TM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getCycleCount() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getScd2_CycleCount() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public CQ getTempMax() {
        CQ retVal = (CQ)this.getTypedField(3, 0);
        return retVal;
    }

    public CQ getScd3_TempMax() {
        CQ retVal = (CQ)this.getTypedField(3, 0);
        return retVal;
    }

    public CQ getTempMin() {
        CQ retVal = (CQ)this.getTypedField(4, 0);
        return retVal;
    }

    public CQ getScd4_TempMin() {
        CQ retVal = (CQ)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getLoadNumber() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getScd5_LoadNumber() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CQ getConditionTime() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getScd6_ConditionTime() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getSterilizeTime() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getScd7_SterilizeTime() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getExhaustTime() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getScd8_ExhaustTime() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getTotalCycleTime() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getScd9_TotalCycleTime() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getDeviceStatus() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getScd10_DeviceStatus() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM getCycleStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getScd11_CycleStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getDryTime() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getScd12_DryTime() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getLeakRate() {
        CQ retVal = (CQ)this.getTypedField(13, 0);
        return retVal;
    }

    public CQ getScd13_LeakRate() {
        CQ retVal = (CQ)this.getTypedField(13, 0);
        return retVal;
    }

    public CQ getControlTemperature() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    public CQ getScd14_ControlTemperature() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    public CQ getSterilizerTemperature() {
        CQ retVal = (CQ)this.getTypedField(15, 0);
        return retVal;
    }

    public CQ getScd15_SterilizerTemperature() {
        CQ retVal = (CQ)this.getTypedField(15, 0);
        return retVal;
    }

    public TM getCycleCompleteTime() {
        TM retVal = (TM)this.getTypedField(16, 0);
        return retVal;
    }

    public TM getScd16_CycleCompleteTime() {
        TM retVal = (TM)this.getTypedField(16, 0);
        return retVal;
    }

    public CQ getUnderTemperature() {
        CQ retVal = (CQ)this.getTypedField(17, 0);
        return retVal;
    }

    public CQ getScd17_UnderTemperature() {
        CQ retVal = (CQ)this.getTypedField(17, 0);
        return retVal;
    }

    public CQ getOverTemperature() {
        CQ retVal = (CQ)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ getScd18_OverTemperature() {
        CQ retVal = (CQ)this.getTypedField(18, 0);
        return retVal;
    }

    public CNE getAbortCycle() {
        CNE retVal = (CNE)this.getTypedField(19, 0);
        return retVal;
    }

    public CNE getScd19_AbortCycle() {
        CNE retVal = (CNE)this.getTypedField(19, 0);
        return retVal;
    }

    public CNE getAlarm() {
        CNE retVal = (CNE)this.getTypedField(20, 0);
        return retVal;
    }

    public CNE getScd20_Alarm() {
        CNE retVal = (CNE)this.getTypedField(20, 0);
        return retVal;
    }

    public CNE getLongInChargePhase() {
        CNE retVal = (CNE)this.getTypedField(21, 0);
        return retVal;
    }

    public CNE getScd21_LongInChargePhase() {
        CNE retVal = (CNE)this.getTypedField(21, 0);
        return retVal;
    }

    public CNE getLongInExhaustPhase() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public CNE getScd22_LongInExhaustPhase() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public CNE getLongInFastExhaustPhase() {
        CNE retVal = (CNE)this.getTypedField(23, 0);
        return retVal;
    }

    public CNE getScd23_LongInFastExhaustPhase() {
        CNE retVal = (CNE)this.getTypedField(23, 0);
        return retVal;
    }

    public CNE getReset() {
        CNE retVal = (CNE)this.getTypedField(24, 0);
        return retVal;
    }

    public CNE getScd24_Reset() {
        CNE retVal = (CNE)this.getTypedField(24, 0);
        return retVal;
    }

    public XCN getOperatorUnload() {
        XCN retVal = (XCN)this.getTypedField(25, 0);
        return retVal;
    }

    public XCN getScd25_OperatorUnload() {
        XCN retVal = (XCN)this.getTypedField(25, 0);
        return retVal;
    }

    public CNE getDoorOpen() {
        CNE retVal = (CNE)this.getTypedField(26, 0);
        return retVal;
    }

    public CNE getScd26_DoorOpen() {
        CNE retVal = (CNE)this.getTypedField(26, 0);
        return retVal;
    }

    public CNE getReadingFailure() {
        CNE retVal = (CNE)this.getTypedField(27, 0);
        return retVal;
    }

    public CNE getScd27_ReadingFailure() {
        CNE retVal = (CNE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getCycleType() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getScd28_CycleType() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CQ getThermalRinseTime() {
        CQ retVal = (CQ)this.getTypedField(29, 0);
        return retVal;
    }

    public CQ getScd29_ThermalRinseTime() {
        CQ retVal = (CQ)this.getTypedField(29, 0);
        return retVal;
    }

    public CQ getWashTime() {
        CQ retVal = (CQ)this.getTypedField(30, 0);
        return retVal;
    }

    public CQ getScd30_WashTime() {
        CQ retVal = (CQ)this.getTypedField(30, 0);
        return retVal;
    }

    public CQ getInjectionRate() {
        CQ retVal = (CQ)this.getTypedField(31, 0);
        return retVal;
    }

    public CQ getScd31_InjectionRate() {
        CQ retVal = (CQ)this.getTypedField(31, 0);
        return retVal;
    }

    public CNE getProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(32, 0);
        return retVal;
    }

    public CNE getScd32_ProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(32, 0);
        return retVal;
    }

    public CX[] getPatientIdentifierList() {
        CX[] retVal = (CX[])this.getTypedField(33, new CX[0]);
        return retVal;
    }

    public CX[] getScd33_PatientIdentifierList() {
        CX[] retVal = (CX[])this.getTypedField(33, new CX[0]);
        return retVal;
    }

    public int getPatientIdentifierListReps() {
        return this.getReps(33);
    }

    public CX getPatientIdentifierList(int rep) {
        CX retVal = (CX)this.getTypedField(33, rep);
        return retVal;
    }

    public CX getScd33_PatientIdentifierList(int rep) {
        CX retVal = (CX)this.getTypedField(33, rep);
        return retVal;
    }

    public int getScd33_PatientIdentifierListReps() {
        return this.getReps(33);
    }

    public CX insertPatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX insertScd33_PatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX removePatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public CX removeScd33_PatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public XCN getAttendingDoctor() {
        XCN retVal = (XCN)this.getTypedField(34, 0);
        return retVal;
    }

    public XCN getScd34_AttendingDoctor() {
        XCN retVal = (XCN)this.getTypedField(34, 0);
        return retVal;
    }

    public SN getDilutionFactor() {
        SN retVal = (SN)this.getTypedField(35, 0);
        return retVal;
    }

    public SN getScd35_DilutionFactor() {
        SN retVal = (SN)this.getTypedField(35, 0);
        return retVal;
    }

    public CQ getFillTime() {
        CQ retVal = (CQ)this.getTypedField(36, 0);
        return retVal;
    }

    public CQ getScd36_FillTime() {
        CQ retVal = (CQ)this.getTypedField(36, 0);
        return retVal;
    }

    public CQ getInletTemperature() {
        CQ retVal = (CQ)this.getTypedField(37, 0);
        return retVal;
    }

    public CQ getScd37_InletTemperature() {
        CQ retVal = (CQ)this.getTypedField(37, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TM(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new CQ(this.getMessage());
            }
            case 3: {
                return new CQ(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CQ(this.getMessage());
            }
            case 6: {
                return new CQ(this.getMessage());
            }
            case 7: {
                return new CQ(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new DTM(this.getMessage());
            }
            case 11: {
                return new CQ(this.getMessage());
            }
            case 12: {
                return new CQ(this.getMessage());
            }
            case 13: {
                return new CQ(this.getMessage());
            }
            case 14: {
                return new CQ(this.getMessage());
            }
            case 15: {
                return new TM(this.getMessage());
            }
            case 16: {
                return new CQ(this.getMessage());
            }
            case 17: {
                return new CQ(this.getMessage());
            }
            case 18: {
                return new CNE(this.getMessage());
            }
            case 19: {
                return new CNE(this.getMessage());
            }
            case 20: {
                return new CNE(this.getMessage());
            }
            case 21: {
                return new CNE(this.getMessage());
            }
            case 22: {
                return new CNE(this.getMessage());
            }
            case 23: {
                return new CNE(this.getMessage());
            }
            case 24: {
                return new XCN(this.getMessage());
            }
            case 25: {
                return new CNE(this.getMessage());
            }
            case 26: {
                return new CNE(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new CQ(this.getMessage());
            }
            case 29: {
                return new CQ(this.getMessage());
            }
            case 30: {
                return new CQ(this.getMessage());
            }
            case 31: {
                return new CNE(this.getMessage());
            }
            case 32: {
                return new CX(this.getMessage());
            }
            case 33: {
                return new XCN(this.getMessage());
            }
            case 34: {
                return new SN(this.getMessage());
            }
            case 35: {
                return new CQ(this.getMessage());
            }
            case 36: {
                return new CQ(this.getMessage());
            }
        }
        return null;
    }
}

