/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.CX;
import ca.uhn.hl7v2.model.v28.datatype.DDI;
import ca.uhn.hl7v2.model.v28.datatype.DT;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.JCC;
import ca.uhn.hl7v2.model.v28.datatype.PTA;
import ca.uhn.hl7v2.model.v28.datatype.RMC;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.model.v28.datatype.XON;
import ca.uhn.hl7v2.model.v28.datatype.XPN;
import ca.uhn.hl7v2.model.v28.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN2
extends AbstractSegment {
    public IN2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured's Employee ID");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Insured's Social Security Number");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured's Employer's Name and ID");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Employer Information Data");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Mail Claim Party");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Medicare Health Ins Card Number");
            this.add(XPN.class, false, 0, 0, new Object[]{this.getMessage()}, "Medicaid Case Name");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Medicaid Case Number");
            this.add(XPN.class, false, 0, 0, new Object[]{this.getMessage()}, "Military Sponsor Name");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Military ID Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dependent Of Military Recipient");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Organization");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Station");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Service");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Rank/Grade");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Status");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Retire Date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Military Non-Avail Cert On File");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Baby Coverage");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Combine Baby Bill");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Blood Deductible");
            this.add(XPN.class, false, 0, 0, new Object[]{this.getMessage()}, "Special Coverage Approval Name");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Special Coverage Approval Title");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Non-Covered Insurance Code");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Payor ID");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Payor Subscriber ID");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Eligibility Source");
            this.add(RMC.class, false, 0, 0, new Object[]{this.getMessage()}, "Room Coverage Type/Amount");
            this.add(PTA.class, false, 0, 0, new Object[]{this.getMessage()}, "Policy Type/Amount");
            this.add(DDI.class, false, 1, 0, new Object[]{this.getMessage()}, "Daily Deductible");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Living Dependency");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Ambulatory Status");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Citizenship");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Primary Language");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Living Arrangement");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Publicity Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Protection Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Student Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Religion");
            this.add(XPN.class, false, 0, 0, new Object[]{this.getMessage()}, "Mother's Maiden Name");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Nationality");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Ethnic Group");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Marital Status");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Insured's Employment Start Date");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Employment Stop Date");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Job Title");
            this.add(JCC.class, false, 1, 0, new Object[]{this.getMessage()}, "Job Code/Class");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Job Status");
            this.add(XPN.class, false, 0, 0, new Object[]{this.getMessage()}, "Employer Contact Person Name");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Employer Contact Person Phone Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Employer Contact Reason");
            this.add(XPN.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured's Contact Person's Name");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured's Contact Person Phone Number");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured's Contact Person Reason");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Relationship to the Patient Start Date");
            this.add(DT.class, false, 0, 0, new Object[]{this.getMessage()}, "Relationship to the Patient Stop Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Insurance Co Contact Reason");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Insurance Co Contact Phone Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Policy Scope");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Policy Source");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Member Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Guarantor's Relationship to Insured");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured's Phone Number - Home");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured's Employer Phone Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Handicapped Program");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Suspend Flag");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Copay Limit Flag");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Stoploss Limit Flag");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured Organization Name and ID");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Insured Employer Organization Name and ID");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Race");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient's Relationship to Insured");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IN2 - this is probably a bug in the source code generator.", e);
        }
    }

    public CX[] getInsuredSEmployeeID() {
        CX[] retVal = (CX[])this.getTypedField(1, new CX[0]);
        return retVal;
    }

    public CX[] getIn21_InsuredSEmployeeID() {
        CX[] retVal = (CX[])this.getTypedField(1, new CX[0]);
        return retVal;
    }

    public int getInsuredSEmployeeIDReps() {
        return this.getReps(1);
    }

    public CX getInsuredSEmployeeID(int rep) {
        CX retVal = (CX)this.getTypedField(1, rep);
        return retVal;
    }

    public CX getIn21_InsuredSEmployeeID(int rep) {
        CX retVal = (CX)this.getTypedField(1, rep);
        return retVal;
    }

    public int getIn21_InsuredSEmployeeIDReps() {
        return this.getReps(1);
    }

    public CX insertInsuredSEmployeeID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(1, rep);
    }

    public CX insertIn21_InsuredSEmployeeID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(1, rep);
    }

    public CX removeInsuredSEmployeeID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(1, rep);
    }

    public CX removeIn21_InsuredSEmployeeID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(1, rep);
    }

    public ST getInsuredSSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getIn22_InsuredSSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN[] getInsuredSEmployerSNameAndID() {
        XCN[] retVal = (XCN[])this.getTypedField(3, new XCN[0]);
        return retVal;
    }

    public XCN[] getIn23_InsuredSEmployerSNameAndID() {
        XCN[] retVal = (XCN[])this.getTypedField(3, new XCN[0]);
        return retVal;
    }

    public int getInsuredSEmployerSNameAndIDReps() {
        return this.getReps(3);
    }

    public XCN getInsuredSEmployerSNameAndID(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public XCN getIn23_InsuredSEmployerSNameAndID(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getIn23_InsuredSEmployerSNameAndIDReps() {
        return this.getReps(3);
    }

    public XCN insertInsuredSEmployerSNameAndID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN insertIn23_InsuredSEmployerSNameAndID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN removeInsuredSEmployerSNameAndID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public XCN removeIn23_InsuredSEmployerSNameAndID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public CWE getEmployerInformationData() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getIn24_EmployerInformationData() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE[] getMailClaimParty() {
        CWE[] retVal = (CWE[])this.getTypedField(5, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn25_MailClaimParty() {
        CWE[] retVal = (CWE[])this.getTypedField(5, new CWE[0]);
        return retVal;
    }

    public int getMailClaimPartyReps() {
        return this.getReps(5);
    }

    public CWE getMailClaimParty(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public CWE getIn25_MailClaimParty(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getIn25_MailClaimPartyReps() {
        return this.getReps(5);
    }

    public CWE insertMailClaimParty(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE insertIn25_MailClaimParty(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE removeMailClaimParty(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE removeIn25_MailClaimParty(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public ST getMedicareHealthInsCardNumber() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getIn26_MedicareHealthInsCardNumber() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public XPN[] getMedicaidCaseName() {
        XPN[] retVal = (XPN[])this.getTypedField(7, new XPN[0]);
        return retVal;
    }

    public XPN[] getIn27_MedicaidCaseName() {
        XPN[] retVal = (XPN[])this.getTypedField(7, new XPN[0]);
        return retVal;
    }

    public int getMedicaidCaseNameReps() {
        return this.getReps(7);
    }

    public XPN getMedicaidCaseName(int rep) {
        XPN retVal = (XPN)this.getTypedField(7, rep);
        return retVal;
    }

    public XPN getIn27_MedicaidCaseName(int rep) {
        XPN retVal = (XPN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getIn27_MedicaidCaseNameReps() {
        return this.getReps(7);
    }

    public XPN insertMedicaidCaseName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(7, rep);
    }

    public XPN insertIn27_MedicaidCaseName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(7, rep);
    }

    public XPN removeMedicaidCaseName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(7, rep);
    }

    public XPN removeIn27_MedicaidCaseName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(7, rep);
    }

    public ST getMedicaidCaseNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getIn28_MedicaidCaseNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public XPN[] getMilitarySponsorName() {
        XPN[] retVal = (XPN[])this.getTypedField(9, new XPN[0]);
        return retVal;
    }

    public XPN[] getIn29_MilitarySponsorName() {
        XPN[] retVal = (XPN[])this.getTypedField(9, new XPN[0]);
        return retVal;
    }

    public int getMilitarySponsorNameReps() {
        return this.getReps(9);
    }

    public XPN getMilitarySponsorName(int rep) {
        XPN retVal = (XPN)this.getTypedField(9, rep);
        return retVal;
    }

    public XPN getIn29_MilitarySponsorName(int rep) {
        XPN retVal = (XPN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getIn29_MilitarySponsorNameReps() {
        return this.getReps(9);
    }

    public XPN insertMilitarySponsorName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN insertIn29_MilitarySponsorName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN removeMilitarySponsorName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public XPN removeIn29_MilitarySponsorName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public ST getMilitaryIDNumber() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getIn210_MilitaryIDNumber() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getDependentOfMilitaryRecipient() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getIn211_DependentOfMilitaryRecipient() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getMilitaryOrganization() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getIn212_MilitaryOrganization() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getMilitaryStation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getIn213_MilitaryStation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getMilitaryService() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getIn214_MilitaryService() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getMilitaryRankGrade() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getIn215_MilitaryRankGrade() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getMilitaryStatus() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getIn216_MilitaryStatus() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public DT getMilitaryRetireDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getIn217_MilitaryRetireDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getMilitaryNonAvailCertOnFile() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getIn218_MilitaryNonAvailCertOnFile() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getBabyCoverage() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getIn219_BabyCoverage() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getCombineBabyBill() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getIn220_CombineBabyBill() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getBloodDeductible() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getIn221_BloodDeductible() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public XPN[] getSpecialCoverageApprovalName() {
        XPN[] retVal = (XPN[])this.getTypedField(22, new XPN[0]);
        return retVal;
    }

    public XPN[] getIn222_SpecialCoverageApprovalName() {
        XPN[] retVal = (XPN[])this.getTypedField(22, new XPN[0]);
        return retVal;
    }

    public int getSpecialCoverageApprovalNameReps() {
        return this.getReps(22);
    }

    public XPN getSpecialCoverageApprovalName(int rep) {
        XPN retVal = (XPN)this.getTypedField(22, rep);
        return retVal;
    }

    public XPN getIn222_SpecialCoverageApprovalName(int rep) {
        XPN retVal = (XPN)this.getTypedField(22, rep);
        return retVal;
    }

    public int getIn222_SpecialCoverageApprovalNameReps() {
        return this.getReps(22);
    }

    public XPN insertSpecialCoverageApprovalName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(22, rep);
    }

    public XPN insertIn222_SpecialCoverageApprovalName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(22, rep);
    }

    public XPN removeSpecialCoverageApprovalName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(22, rep);
    }

    public XPN removeIn222_SpecialCoverageApprovalName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(22, rep);
    }

    public ST getSpecialCoverageApprovalTitle() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getIn223_SpecialCoverageApprovalTitle() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE[] getNonCoveredInsuranceCode() {
        CWE[] retVal = (CWE[])this.getTypedField(24, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn224_NonCoveredInsuranceCode() {
        CWE[] retVal = (CWE[])this.getTypedField(24, new CWE[0]);
        return retVal;
    }

    public int getNonCoveredInsuranceCodeReps() {
        return this.getReps(24);
    }

    public CWE getNonCoveredInsuranceCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public CWE getIn224_NonCoveredInsuranceCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public int getIn224_NonCoveredInsuranceCodeReps() {
        return this.getReps(24);
    }

    public CWE insertNonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE insertIn224_NonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE removeNonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CWE removeIn224_NonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CX[] getPayorID() {
        CX[] retVal = (CX[])this.getTypedField(25, new CX[0]);
        return retVal;
    }

    public CX[] getIn225_PayorID() {
        CX[] retVal = (CX[])this.getTypedField(25, new CX[0]);
        return retVal;
    }

    public int getPayorIDReps() {
        return this.getReps(25);
    }

    public CX getPayorID(int rep) {
        CX retVal = (CX)this.getTypedField(25, rep);
        return retVal;
    }

    public CX getIn225_PayorID(int rep) {
        CX retVal = (CX)this.getTypedField(25, rep);
        return retVal;
    }

    public int getIn225_PayorIDReps() {
        return this.getReps(25);
    }

    public CX insertPayorID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(25, rep);
    }

    public CX insertIn225_PayorID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(25, rep);
    }

    public CX removePayorID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(25, rep);
    }

    public CX removeIn225_PayorID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(25, rep);
    }

    public CX[] getPayorSubscriberID() {
        CX[] retVal = (CX[])this.getTypedField(26, new CX[0]);
        return retVal;
    }

    public CX[] getIn226_PayorSubscriberID() {
        CX[] retVal = (CX[])this.getTypedField(26, new CX[0]);
        return retVal;
    }

    public int getPayorSubscriberIDReps() {
        return this.getReps(26);
    }

    public CX getPayorSubscriberID(int rep) {
        CX retVal = (CX)this.getTypedField(26, rep);
        return retVal;
    }

    public CX getIn226_PayorSubscriberID(int rep) {
        CX retVal = (CX)this.getTypedField(26, rep);
        return retVal;
    }

    public int getIn226_PayorSubscriberIDReps() {
        return this.getReps(26);
    }

    public CX insertPayorSubscriberID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(26, rep);
    }

    public CX insertIn226_PayorSubscriberID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(26, rep);
    }

    public CX removePayorSubscriberID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(26, rep);
    }

    public CX removeIn226_PayorSubscriberID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(26, rep);
    }

    public CWE getEligibilitySource() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getIn227_EligibilitySource() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public RMC[] getRoomCoverageTypeAmount() {
        RMC[] retVal = (RMC[])this.getTypedField(28, new RMC[0]);
        return retVal;
    }

    public RMC[] getIn228_RoomCoverageTypeAmount() {
        RMC[] retVal = (RMC[])this.getTypedField(28, new RMC[0]);
        return retVal;
    }

    public int getRoomCoverageTypeAmountReps() {
        return this.getReps(28);
    }

    public RMC getRoomCoverageTypeAmount(int rep) {
        RMC retVal = (RMC)this.getTypedField(28, rep);
        return retVal;
    }

    public RMC getIn228_RoomCoverageTypeAmount(int rep) {
        RMC retVal = (RMC)this.getTypedField(28, rep);
        return retVal;
    }

    public int getIn228_RoomCoverageTypeAmountReps() {
        return this.getReps(28);
    }

    public RMC insertRoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (RMC)super.insertRepetition(28, rep);
    }

    public RMC insertIn228_RoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (RMC)super.insertRepetition(28, rep);
    }

    public RMC removeRoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (RMC)super.removeRepetition(28, rep);
    }

    public RMC removeIn228_RoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (RMC)super.removeRepetition(28, rep);
    }

    public PTA[] getPolicyTypeAmount() {
        PTA[] retVal = (PTA[])this.getTypedField(29, new PTA[0]);
        return retVal;
    }

    public PTA[] getIn229_PolicyTypeAmount() {
        PTA[] retVal = (PTA[])this.getTypedField(29, new PTA[0]);
        return retVal;
    }

    public int getPolicyTypeAmountReps() {
        return this.getReps(29);
    }

    public PTA getPolicyTypeAmount(int rep) {
        PTA retVal = (PTA)this.getTypedField(29, rep);
        return retVal;
    }

    public PTA getIn229_PolicyTypeAmount(int rep) {
        PTA retVal = (PTA)this.getTypedField(29, rep);
        return retVal;
    }

    public int getIn229_PolicyTypeAmountReps() {
        return this.getReps(29);
    }

    public PTA insertPolicyTypeAmount(int rep) throws HL7Exception {
        return (PTA)super.insertRepetition(29, rep);
    }

    public PTA insertIn229_PolicyTypeAmount(int rep) throws HL7Exception {
        return (PTA)super.insertRepetition(29, rep);
    }

    public PTA removePolicyTypeAmount(int rep) throws HL7Exception {
        return (PTA)super.removeRepetition(29, rep);
    }

    public PTA removeIn229_PolicyTypeAmount(int rep) throws HL7Exception {
        return (PTA)super.removeRepetition(29, rep);
    }

    public DDI getDailyDeductible() {
        DDI retVal = (DDI)this.getTypedField(30, 0);
        return retVal;
    }

    public DDI getIn230_DailyDeductible() {
        DDI retVal = (DDI)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getLivingDependency() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getIn231_LivingDependency() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE[] getAmbulatoryStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(32, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn232_AmbulatoryStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(32, new CWE[0]);
        return retVal;
    }

    public int getAmbulatoryStatusReps() {
        return this.getReps(32);
    }

    public CWE getAmbulatoryStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(32, rep);
        return retVal;
    }

    public CWE getIn232_AmbulatoryStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(32, rep);
        return retVal;
    }

    public int getIn232_AmbulatoryStatusReps() {
        return this.getReps(32);
    }

    public CWE insertAmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(32, rep);
    }

    public CWE insertIn232_AmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(32, rep);
    }

    public CWE removeAmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(32, rep);
    }

    public CWE removeIn232_AmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(32, rep);
    }

    public CWE[] getCitizenship() {
        CWE[] retVal = (CWE[])this.getTypedField(33, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn233_Citizenship() {
        CWE[] retVal = (CWE[])this.getTypedField(33, new CWE[0]);
        return retVal;
    }

    public int getCitizenshipReps() {
        return this.getReps(33);
    }

    public CWE getCitizenship(int rep) {
        CWE retVal = (CWE)this.getTypedField(33, rep);
        return retVal;
    }

    public CWE getIn233_Citizenship(int rep) {
        CWE retVal = (CWE)this.getTypedField(33, rep);
        return retVal;
    }

    public int getIn233_CitizenshipReps() {
        return this.getReps(33);
    }

    public CWE insertCitizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(33, rep);
    }

    public CWE insertIn233_Citizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(33, rep);
    }

    public CWE removeCitizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(33, rep);
    }

    public CWE removeIn233_Citizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(33, rep);
    }

    public CWE getPrimaryLanguage() {
        CWE retVal = (CWE)this.getTypedField(34, 0);
        return retVal;
    }

    public CWE getIn234_PrimaryLanguage() {
        CWE retVal = (CWE)this.getTypedField(34, 0);
        return retVal;
    }

    public CWE getLivingArrangement() {
        CWE retVal = (CWE)this.getTypedField(35, 0);
        return retVal;
    }

    public CWE getIn235_LivingArrangement() {
        CWE retVal = (CWE)this.getTypedField(35, 0);
        return retVal;
    }

    public CWE getPublicityCode() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public CWE getIn236_PublicityCode() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    public ID getIn237_ProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    public CWE getStudentIndicator() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getIn238_StudentIndicator() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getReligion() {
        CWE retVal = (CWE)this.getTypedField(39, 0);
        return retVal;
    }

    public CWE getIn239_Religion() {
        CWE retVal = (CWE)this.getTypedField(39, 0);
        return retVal;
    }

    public XPN[] getMotherSMaidenName() {
        XPN[] retVal = (XPN[])this.getTypedField(40, new XPN[0]);
        return retVal;
    }

    public XPN[] getIn240_MotherSMaidenName() {
        XPN[] retVal = (XPN[])this.getTypedField(40, new XPN[0]);
        return retVal;
    }

    public int getMotherSMaidenNameReps() {
        return this.getReps(40);
    }

    public XPN getMotherSMaidenName(int rep) {
        XPN retVal = (XPN)this.getTypedField(40, rep);
        return retVal;
    }

    public XPN getIn240_MotherSMaidenName(int rep) {
        XPN retVal = (XPN)this.getTypedField(40, rep);
        return retVal;
    }

    public int getIn240_MotherSMaidenNameReps() {
        return this.getReps(40);
    }

    public XPN insertMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(40, rep);
    }

    public XPN insertIn240_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(40, rep);
    }

    public XPN removeMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(40, rep);
    }

    public XPN removeIn240_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(40, rep);
    }

    public CWE getNationality() {
        CWE retVal = (CWE)this.getTypedField(41, 0);
        return retVal;
    }

    public CWE getIn241_Nationality() {
        CWE retVal = (CWE)this.getTypedField(41, 0);
        return retVal;
    }

    public CWE[] getEthnicGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(42, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn242_EthnicGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(42, new CWE[0]);
        return retVal;
    }

    public int getEthnicGroupReps() {
        return this.getReps(42);
    }

    public CWE getEthnicGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(42, rep);
        return retVal;
    }

    public CWE getIn242_EthnicGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(42, rep);
        return retVal;
    }

    public int getIn242_EthnicGroupReps() {
        return this.getReps(42);
    }

    public CWE insertEthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(42, rep);
    }

    public CWE insertIn242_EthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(42, rep);
    }

    public CWE removeEthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(42, rep);
    }

    public CWE removeIn242_EthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(42, rep);
    }

    public CWE[] getMaritalStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(43, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn243_MaritalStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(43, new CWE[0]);
        return retVal;
    }

    public int getMaritalStatusReps() {
        return this.getReps(43);
    }

    public CWE getMaritalStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(43, rep);
        return retVal;
    }

    public CWE getIn243_MaritalStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(43, rep);
        return retVal;
    }

    public int getIn243_MaritalStatusReps() {
        return this.getReps(43);
    }

    public CWE insertMaritalStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(43, rep);
    }

    public CWE insertIn243_MaritalStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(43, rep);
    }

    public CWE removeMaritalStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(43, rep);
    }

    public CWE removeIn243_MaritalStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(43, rep);
    }

    public DT getInsuredSEmploymentStartDate() {
        DT retVal = (DT)this.getTypedField(44, 0);
        return retVal;
    }

    public DT getIn244_InsuredSEmploymentStartDate() {
        DT retVal = (DT)this.getTypedField(44, 0);
        return retVal;
    }

    public DT getEmploymentStopDate() {
        DT retVal = (DT)this.getTypedField(45, 0);
        return retVal;
    }

    public DT getIn245_EmploymentStopDate() {
        DT retVal = (DT)this.getTypedField(45, 0);
        return retVal;
    }

    public ST getJobTitle() {
        ST retVal = (ST)this.getTypedField(46, 0);
        return retVal;
    }

    public ST getIn246_JobTitle() {
        ST retVal = (ST)this.getTypedField(46, 0);
        return retVal;
    }

    public JCC getJobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(47, 0);
        return retVal;
    }

    public JCC getIn247_JobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(47, 0);
        return retVal;
    }

    public CWE getJobStatus() {
        CWE retVal = (CWE)this.getTypedField(48, 0);
        return retVal;
    }

    public CWE getIn248_JobStatus() {
        CWE retVal = (CWE)this.getTypedField(48, 0);
        return retVal;
    }

    public XPN[] getEmployerContactPersonName() {
        XPN[] retVal = (XPN[])this.getTypedField(49, new XPN[0]);
        return retVal;
    }

    public XPN[] getIn249_EmployerContactPersonName() {
        XPN[] retVal = (XPN[])this.getTypedField(49, new XPN[0]);
        return retVal;
    }

    public int getEmployerContactPersonNameReps() {
        return this.getReps(49);
    }

    public XPN getEmployerContactPersonName(int rep) {
        XPN retVal = (XPN)this.getTypedField(49, rep);
        return retVal;
    }

    public XPN getIn249_EmployerContactPersonName(int rep) {
        XPN retVal = (XPN)this.getTypedField(49, rep);
        return retVal;
    }

    public int getIn249_EmployerContactPersonNameReps() {
        return this.getReps(49);
    }

    public XPN insertEmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(49, rep);
    }

    public XPN insertIn249_EmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(49, rep);
    }

    public XPN removeEmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(49, rep);
    }

    public XPN removeIn249_EmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(49, rep);
    }

    public XTN[] getEmployerContactPersonPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(50, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn250_EmployerContactPersonPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(50, new XTN[0]);
        return retVal;
    }

    public int getEmployerContactPersonPhoneNumberReps() {
        return this.getReps(50);
    }

    public XTN getEmployerContactPersonPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(50, rep);
        return retVal;
    }

    public XTN getIn250_EmployerContactPersonPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(50, rep);
        return retVal;
    }

    public int getIn250_EmployerContactPersonPhoneNumberReps() {
        return this.getReps(50);
    }

    public XTN insertEmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(50, rep);
    }

    public XTN insertIn250_EmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(50, rep);
    }

    public XTN removeEmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(50, rep);
    }

    public XTN removeIn250_EmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(50, rep);
    }

    public CWE getEmployerContactReason() {
        CWE retVal = (CWE)this.getTypedField(51, 0);
        return retVal;
    }

    public CWE getIn251_EmployerContactReason() {
        CWE retVal = (CWE)this.getTypedField(51, 0);
        return retVal;
    }

    public XPN[] getInsuredSContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(52, new XPN[0]);
        return retVal;
    }

    public XPN[] getIn252_InsuredSContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(52, new XPN[0]);
        return retVal;
    }

    public int getInsuredSContactPersonSNameReps() {
        return this.getReps(52);
    }

    public XPN getInsuredSContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(52, rep);
        return retVal;
    }

    public XPN getIn252_InsuredSContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(52, rep);
        return retVal;
    }

    public int getIn252_InsuredSContactPersonSNameReps() {
        return this.getReps(52);
    }

    public XPN insertInsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(52, rep);
    }

    public XPN insertIn252_InsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(52, rep);
    }

    public XPN removeInsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(52, rep);
    }

    public XPN removeIn252_InsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(52, rep);
    }

    public XTN[] getInsuredSContactPersonPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(53, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn253_InsuredSContactPersonPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(53, new XTN[0]);
        return retVal;
    }

    public int getInsuredSContactPersonPhoneNumberReps() {
        return this.getReps(53);
    }

    public XTN getInsuredSContactPersonPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(53, rep);
        return retVal;
    }

    public XTN getIn253_InsuredSContactPersonPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(53, rep);
        return retVal;
    }

    public int getIn253_InsuredSContactPersonPhoneNumberReps() {
        return this.getReps(53);
    }

    public XTN insertInsuredSContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(53, rep);
    }

    public XTN insertIn253_InsuredSContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(53, rep);
    }

    public XTN removeInsuredSContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(53, rep);
    }

    public XTN removeIn253_InsuredSContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(53, rep);
    }

    public CWE[] getInsuredSContactPersonReason() {
        CWE[] retVal = (CWE[])this.getTypedField(54, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn254_InsuredSContactPersonReason() {
        CWE[] retVal = (CWE[])this.getTypedField(54, new CWE[0]);
        return retVal;
    }

    public int getInsuredSContactPersonReasonReps() {
        return this.getReps(54);
    }

    public CWE getInsuredSContactPersonReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(54, rep);
        return retVal;
    }

    public CWE getIn254_InsuredSContactPersonReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(54, rep);
        return retVal;
    }

    public int getIn254_InsuredSContactPersonReasonReps() {
        return this.getReps(54);
    }

    public CWE insertInsuredSContactPersonReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(54, rep);
    }

    public CWE insertIn254_InsuredSContactPersonReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(54, rep);
    }

    public CWE removeInsuredSContactPersonReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(54, rep);
    }

    public CWE removeIn254_InsuredSContactPersonReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(54, rep);
    }

    public DT getRelationshipToThePatientStartDate() {
        DT retVal = (DT)this.getTypedField(55, 0);
        return retVal;
    }

    public DT getIn255_RelationshipToThePatientStartDate() {
        DT retVal = (DT)this.getTypedField(55, 0);
        return retVal;
    }

    public DT[] getRelationshipToThePatientStopDate() {
        DT[] retVal = (DT[])this.getTypedField(56, new DT[0]);
        return retVal;
    }

    public DT[] getIn256_RelationshipToThePatientStopDate() {
        DT[] retVal = (DT[])this.getTypedField(56, new DT[0]);
        return retVal;
    }

    public int getRelationshipToThePatientStopDateReps() {
        return this.getReps(56);
    }

    public DT getRelationshipToThePatientStopDate(int rep) {
        DT retVal = (DT)this.getTypedField(56, rep);
        return retVal;
    }

    public DT getIn256_RelationshipToThePatientStopDate(int rep) {
        DT retVal = (DT)this.getTypedField(56, rep);
        return retVal;
    }

    public int getIn256_RelationshipToThePatientStopDateReps() {
        return this.getReps(56);
    }

    public DT insertRelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(56, rep);
    }

    public DT insertIn256_RelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(56, rep);
    }

    public DT removeRelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(56, rep);
    }

    public DT removeIn256_RelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(56, rep);
    }

    public CWE getInsuranceCoContactReason() {
        CWE retVal = (CWE)this.getTypedField(57, 0);
        return retVal;
    }

    public CWE getIn257_InsuranceCoContactReason() {
        CWE retVal = (CWE)this.getTypedField(57, 0);
        return retVal;
    }

    public XTN[] getInsuranceCoContactPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(58, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn258_InsuranceCoContactPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(58, new XTN[0]);
        return retVal;
    }

    public int getInsuranceCoContactPhoneNumberReps() {
        return this.getReps(58);
    }

    public XTN getInsuranceCoContactPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(58, rep);
        return retVal;
    }

    public XTN getIn258_InsuranceCoContactPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(58, rep);
        return retVal;
    }

    public int getIn258_InsuranceCoContactPhoneNumberReps() {
        return this.getReps(58);
    }

    public XTN insertInsuranceCoContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(58, rep);
    }

    public XTN insertIn258_InsuranceCoContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(58, rep);
    }

    public XTN removeInsuranceCoContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(58, rep);
    }

    public XTN removeIn258_InsuranceCoContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(58, rep);
    }

    public CWE getPolicyScope() {
        CWE retVal = (CWE)this.getTypedField(59, 0);
        return retVal;
    }

    public CWE getIn259_PolicyScope() {
        CWE retVal = (CWE)this.getTypedField(59, 0);
        return retVal;
    }

    public CWE getPolicySource() {
        CWE retVal = (CWE)this.getTypedField(60, 0);
        return retVal;
    }

    public CWE getIn260_PolicySource() {
        CWE retVal = (CWE)this.getTypedField(60, 0);
        return retVal;
    }

    public CX getPatientMemberNumber() {
        CX retVal = (CX)this.getTypedField(61, 0);
        return retVal;
    }

    public CX getIn261_PatientMemberNumber() {
        CX retVal = (CX)this.getTypedField(61, 0);
        return retVal;
    }

    public CWE getGuarantorSRelationshipToInsured() {
        CWE retVal = (CWE)this.getTypedField(62, 0);
        return retVal;
    }

    public CWE getIn262_GuarantorSRelationshipToInsured() {
        CWE retVal = (CWE)this.getTypedField(62, 0);
        return retVal;
    }

    public XTN[] getInsuredSPhoneNumberHome() {
        XTN[] retVal = (XTN[])this.getTypedField(63, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn263_InsuredSPhoneNumberHome() {
        XTN[] retVal = (XTN[])this.getTypedField(63, new XTN[0]);
        return retVal;
    }

    public int getInsuredSPhoneNumberHomeReps() {
        return this.getReps(63);
    }

    public XTN getInsuredSPhoneNumberHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(63, rep);
        return retVal;
    }

    public XTN getIn263_InsuredSPhoneNumberHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(63, rep);
        return retVal;
    }

    public int getIn263_InsuredSPhoneNumberHomeReps() {
        return this.getReps(63);
    }

    public XTN insertInsuredSPhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(63, rep);
    }

    public XTN insertIn263_InsuredSPhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(63, rep);
    }

    public XTN removeInsuredSPhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(63, rep);
    }

    public XTN removeIn263_InsuredSPhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(63, rep);
    }

    public XTN[] getInsuredSEmployerPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(64, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn264_InsuredSEmployerPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(64, new XTN[0]);
        return retVal;
    }

    public int getInsuredSEmployerPhoneNumberReps() {
        return this.getReps(64);
    }

    public XTN getInsuredSEmployerPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(64, rep);
        return retVal;
    }

    public XTN getIn264_InsuredSEmployerPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(64, rep);
        return retVal;
    }

    public int getIn264_InsuredSEmployerPhoneNumberReps() {
        return this.getReps(64);
    }

    public XTN insertInsuredSEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(64, rep);
    }

    public XTN insertIn264_InsuredSEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(64, rep);
    }

    public XTN removeInsuredSEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(64, rep);
    }

    public XTN removeIn264_InsuredSEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(64, rep);
    }

    public CWE getMilitaryHandicappedProgram() {
        CWE retVal = (CWE)this.getTypedField(65, 0);
        return retVal;
    }

    public CWE getIn265_MilitaryHandicappedProgram() {
        CWE retVal = (CWE)this.getTypedField(65, 0);
        return retVal;
    }

    public ID getSuspendFlag() {
        ID retVal = (ID)this.getTypedField(66, 0);
        return retVal;
    }

    public ID getIn266_SuspendFlag() {
        ID retVal = (ID)this.getTypedField(66, 0);
        return retVal;
    }

    public ID getCopayLimitFlag() {
        ID retVal = (ID)this.getTypedField(67, 0);
        return retVal;
    }

    public ID getIn267_CopayLimitFlag() {
        ID retVal = (ID)this.getTypedField(67, 0);
        return retVal;
    }

    public ID getStoplossLimitFlag() {
        ID retVal = (ID)this.getTypedField(68, 0);
        return retVal;
    }

    public ID getIn268_StoplossLimitFlag() {
        ID retVal = (ID)this.getTypedField(68, 0);
        return retVal;
    }

    public XON[] getInsuredOrganizationNameAndID() {
        XON[] retVal = (XON[])this.getTypedField(69, new XON[0]);
        return retVal;
    }

    public XON[] getIn269_InsuredOrganizationNameAndID() {
        XON[] retVal = (XON[])this.getTypedField(69, new XON[0]);
        return retVal;
    }

    public int getInsuredOrganizationNameAndIDReps() {
        return this.getReps(69);
    }

    public XON getInsuredOrganizationNameAndID(int rep) {
        XON retVal = (XON)this.getTypedField(69, rep);
        return retVal;
    }

    public XON getIn269_InsuredOrganizationNameAndID(int rep) {
        XON retVal = (XON)this.getTypedField(69, rep);
        return retVal;
    }

    public int getIn269_InsuredOrganizationNameAndIDReps() {
        return this.getReps(69);
    }

    public XON insertInsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(69, rep);
    }

    public XON insertIn269_InsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(69, rep);
    }

    public XON removeInsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(69, rep);
    }

    public XON removeIn269_InsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(69, rep);
    }

    public XON[] getInsuredEmployerOrganizationNameAndID() {
        XON[] retVal = (XON[])this.getTypedField(70, new XON[0]);
        return retVal;
    }

    public XON[] getIn270_InsuredEmployerOrganizationNameAndID() {
        XON[] retVal = (XON[])this.getTypedField(70, new XON[0]);
        return retVal;
    }

    public int getInsuredEmployerOrganizationNameAndIDReps() {
        return this.getReps(70);
    }

    public XON getInsuredEmployerOrganizationNameAndID(int rep) {
        XON retVal = (XON)this.getTypedField(70, rep);
        return retVal;
    }

    public XON getIn270_InsuredEmployerOrganizationNameAndID(int rep) {
        XON retVal = (XON)this.getTypedField(70, rep);
        return retVal;
    }

    public int getIn270_InsuredEmployerOrganizationNameAndIDReps() {
        return this.getReps(70);
    }

    public XON insertInsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(70, rep);
    }

    public XON insertIn270_InsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(70, rep);
    }

    public XON removeInsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(70, rep);
    }

    public XON removeIn270_InsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(70, rep);
    }

    public CWE[] getRace() {
        CWE[] retVal = (CWE[])this.getTypedField(71, new CWE[0]);
        return retVal;
    }

    public CWE[] getIn271_Race() {
        CWE[] retVal = (CWE[])this.getTypedField(71, new CWE[0]);
        return retVal;
    }

    public int getRaceReps() {
        return this.getReps(71);
    }

    public CWE getRace(int rep) {
        CWE retVal = (CWE)this.getTypedField(71, rep);
        return retVal;
    }

    public CWE getIn271_Race(int rep) {
        CWE retVal = (CWE)this.getTypedField(71, rep);
        return retVal;
    }

    public int getIn271_RaceReps() {
        return this.getReps(71);
    }

    public CWE insertRace(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(71, rep);
    }

    public CWE insertIn271_Race(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(71, rep);
    }

    public CWE removeRace(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(71, rep);
    }

    public CWE removeIn271_Race(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(71, rep);
    }

    public CWE getPatientSRelationshipToInsured() {
        CWE retVal = (CWE)this.getTypedField(72, 0);
        return retVal;
    }

    public CWE getIn272_PatientSRelationshipToInsured() {
        CWE retVal = (CWE)this.getTypedField(72, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CX(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new XPN(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new XPN(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new DT(this.getMessage());
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new XPN(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new CX(this.getMessage());
            }
            case 25: {
                return new CX(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new RMC(this.getMessage());
            }
            case 28: {
                return new PTA(this.getMessage());
            }
            case 29: {
                return new DDI(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new CWE(this.getMessage());
            }
            case 32: {
                return new CWE(this.getMessage());
            }
            case 33: {
                return new CWE(this.getMessage());
            }
            case 34: {
                return new CWE(this.getMessage());
            }
            case 35: {
                return new CWE(this.getMessage());
            }
            case 36: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new CWE(this.getMessage());
            }
            case 39: {
                return new XPN(this.getMessage());
            }
            case 40: {
                return new CWE(this.getMessage());
            }
            case 41: {
                return new CWE(this.getMessage());
            }
            case 42: {
                return new CWE(this.getMessage());
            }
            case 43: {
                return new DT(this.getMessage());
            }
            case 44: {
                return new DT(this.getMessage());
            }
            case 45: {
                return new ST(this.getMessage());
            }
            case 46: {
                return new JCC(this.getMessage());
            }
            case 47: {
                return new CWE(this.getMessage());
            }
            case 48: {
                return new XPN(this.getMessage());
            }
            case 49: {
                return new XTN(this.getMessage());
            }
            case 50: {
                return new CWE(this.getMessage());
            }
            case 51: {
                return new XPN(this.getMessage());
            }
            case 52: {
                return new XTN(this.getMessage());
            }
            case 53: {
                return new CWE(this.getMessage());
            }
            case 54: {
                return new DT(this.getMessage());
            }
            case 55: {
                return new DT(this.getMessage());
            }
            case 56: {
                return new CWE(this.getMessage());
            }
            case 57: {
                return new XTN(this.getMessage());
            }
            case 58: {
                return new CWE(this.getMessage());
            }
            case 59: {
                return new CWE(this.getMessage());
            }
            case 60: {
                return new CX(this.getMessage());
            }
            case 61: {
                return new CWE(this.getMessage());
            }
            case 62: {
                return new XTN(this.getMessage());
            }
            case 63: {
                return new XTN(this.getMessage());
            }
            case 64: {
                return new CWE(this.getMessage());
            }
            case 65: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 66: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 67: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 68: {
                return new XON(this.getMessage());
            }
            case 69: {
                return new XON(this.getMessage());
            }
            case 70: {
                return new CWE(this.getMessage());
            }
            case 71: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

