/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v28.group.EHC_E10_INVOICE_PROCESSING_RESULTS_INFO;
import ca.uhn.hl7v2.model.v28.segment.ERR;
import ca.uhn.hl7v2.model.v28.segment.MSA;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E10
extends AbstractMessage {
    public EHC_E10() {
        this(new DefaultModelClassFactory());
    }

    public EHC_E10(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(EHC_E10_INVOICE_PROCESSING_RESULTS_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E10 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public EHC_E10_INVOICE_PROCESSING_RESULTS_INFO getINVOICE_PROCESSING_RESULTS_INFO() {
        return this.getTyped("INVOICE_PROCESSING_RESULTS_INFO", EHC_E10_INVOICE_PROCESSING_RESULTS_INFO.class);
    }

    public EHC_E10_INVOICE_PROCESSING_RESULTS_INFO getINVOICE_PROCESSING_RESULTS_INFO(int rep) {
        return this.getTyped("INVOICE_PROCESSING_RESULTS_INFO", rep, EHC_E10_INVOICE_PROCESSING_RESULTS_INFO.class);
    }

    public int getINVOICE_PROCESSING_RESULTS_INFOReps() {
        return this.getReps("INVOICE_PROCESSING_RESULTS_INFO");
    }

    public List<EHC_E10_INVOICE_PROCESSING_RESULTS_INFO> getINVOICE_PROCESSING_RESULTS_INFOAll() throws HL7Exception {
        return this.getAllAsList("INVOICE_PROCESSING_RESULTS_INFO", EHC_E10_INVOICE_PROCESSING_RESULTS_INFO.class);
    }

    public void insertINVOICE_PROCESSING_RESULTS_INFO(EHC_E10_INVOICE_PROCESSING_RESULTS_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("INVOICE_PROCESSING_RESULTS_INFO", structure, rep);
    }

    public EHC_E10_INVOICE_PROCESSING_RESULTS_INFO insertINVOICE_PROCESSING_RESULTS_INFO(int rep) throws HL7Exception {
        return (EHC_E10_INVOICE_PROCESSING_RESULTS_INFO)super.insertRepetition("INVOICE_PROCESSING_RESULTS_INFO", rep);
    }

    public EHC_E10_INVOICE_PROCESSING_RESULTS_INFO removeINVOICE_PROCESSING_RESULTS_INFO(int rep) throws HL7Exception {
        return (EHC_E10_INVOICE_PROCESSING_RESULTS_INFO)super.removeRepetition("INVOICE_PROCESSING_RESULTS_INFO", rep);
    }
}

