/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.RDE_O11_COMPONENTS;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.model.v28.segment.RXO;
import ca.uhn.hl7v2.model.v28.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RDE_O11_ORDER_DETAIL
extends AbstractGroup {
    public RDE_O11_ORDER_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXO.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(RXR.class, true, true, false);
            this.add(RDE_O11_COMPONENTS.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDE_O11_ORDER_DETAIL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public RXO getRXO() {
        RXO retVal = this.getTyped("RXO", RXO.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RXR getRXR() {
        RXR retVal = this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RDE_O11_COMPONENTS getCOMPONENTS() {
        RDE_O11_COMPONENTS retVal = this.getTyped("COMPONENTS", RDE_O11_COMPONENTS.class);
        return retVal;
    }

    public RDE_O11_COMPONENTS getCOMPONENTS(int rep) {
        RDE_O11_COMPONENTS retVal = this.getTyped("COMPONENTS", rep, RDE_O11_COMPONENTS.class);
        return retVal;
    }

    public int getCOMPONENTSReps() {
        return this.getReps("COMPONENTS");
    }

    public List<RDE_O11_COMPONENTS> getCOMPONENTSAll() throws HL7Exception {
        return this.getAllAsList("COMPONENTS", RDE_O11_COMPONENTS.class);
    }

    public void insertCOMPONENTS(RDE_O11_COMPONENTS structure, int rep) throws HL7Exception {
        super.insertRepetition("COMPONENTS", structure, rep);
    }

    public RDE_O11_COMPONENTS insertCOMPONENTS(int rep) throws HL7Exception {
        return (RDE_O11_COMPONENTS)super.insertRepetition("COMPONENTS", rep);
    }

    public RDE_O11_COMPONENTS removeCOMPONENTS(int rep) throws HL7Exception {
        return (RDE_O11_COMPONENTS)super.removeRepetition("COMPONENTS", rep);
    }
}

