/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CP;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.CX;
import ca.uhn.hl7v2.model.v27.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PCE
extends AbstractSegment {
    public PCE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - PCE");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Cost Center Account Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Transaction Code");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Transaction amount - unit");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PCE - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDPCE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPce1_SetIDPCE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CX getCostCenterAccountNumber() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CX getPce2_CostCenterAccountNumber() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getTransactionCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getPce3_TransactionCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CP getTransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(4, 0);
        return retVal;
    }

    public CP getPce4_TransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CP(this.getMessage());
            }
        }
        return null;
    }
}

