/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MFE
extends AbstractSegment {
    public MFE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(180)}, "Record-Level Event Code");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "MFN Control ID");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Date/Time");
            this.add(Varies.class, true, 0, 0, new Object[]{this.getMessage()}, "Primary Key Value - MFE");
            this.add(ID.class, true, 0, 3, new Object[]{this.getMessage(), new Integer(355)}, "Primary Key Value Type");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Entered Date/Time");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Entered By");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFE - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getRecordLevelEventCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getMfe1_RecordLevelEventCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMFNControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMfe2_MFNControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getMfe3_EffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public Varies[] getPrimaryKeyValueMFE() {
        Varies[] retVal = (Varies[])this.getTypedField(4, new Varies[0]);
        return retVal;
    }

    public Varies[] getMfe4_PrimaryKeyValueMFE() {
        Varies[] retVal = (Varies[])this.getTypedField(4, new Varies[0]);
        return retVal;
    }

    public int getPrimaryKeyValueMFEReps() {
        return this.getReps(4);
    }

    public Varies getPrimaryKeyValueMFE(int rep) {
        Varies retVal = (Varies)this.getTypedField(4, rep);
        return retVal;
    }

    public Varies getMfe4_PrimaryKeyValueMFE(int rep) {
        Varies retVal = (Varies)this.getTypedField(4, rep);
        return retVal;
    }

    public int getMfe4_PrimaryKeyValueMFEReps() {
        return this.getReps(4);
    }

    public Varies insertPrimaryKeyValueMFE(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(4, rep);
    }

    public Varies insertMfe4_PrimaryKeyValueMFE(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(4, rep);
    }

    public Varies removePrimaryKeyValueMFE(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(4, rep);
    }

    public Varies removeMfe4_PrimaryKeyValueMFE(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(4, rep);
    }

    public ID[] getPrimaryKeyValueType() {
        ID[] retVal = (ID[])this.getTypedField(5, new ID[0]);
        return retVal;
    }

    public ID[] getMfe5_PrimaryKeyValueType() {
        ID[] retVal = (ID[])this.getTypedField(5, new ID[0]);
        return retVal;
    }

    public int getPrimaryKeyValueTypeReps() {
        return this.getReps(5);
    }

    public ID getPrimaryKeyValueType(int rep) {
        ID retVal = (ID)this.getTypedField(5, rep);
        return retVal;
    }

    public ID getMfe5_PrimaryKeyValueType(int rep) {
        ID retVal = (ID)this.getTypedField(5, rep);
        return retVal;
    }

    public int getMfe5_PrimaryKeyValueTypeReps() {
        return this.getReps(5);
    }

    public ID insertPrimaryKeyValueType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(5, rep);
    }

    public ID insertMfe5_PrimaryKeyValueType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(5, rep);
    }

    public ID removePrimaryKeyValueType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(5, rep);
    }

    public ID removeMfe5_PrimaryKeyValueType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(5, rep);
    }

    public DTM getEnteredDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getMfe6_EnteredDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public XCN getEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN getMfe7_EnteredBy() {
        XCN retVal = (XCN)this.getTypedField(7, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(180));
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new Varies(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(355));
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

