/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.ERL;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.NULLDT;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.TX;
import ca.uhn.hl7v2.model.v27.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ERR
extends AbstractSegment {
    public ERR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Error Code and Location");
            this.add(ERL.class, false, 0, 0, new Object[]{this.getMessage()}, "Error Location");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "HL7 Error Code");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(516)}, "Severity");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Application Error Code");
            this.add(ST.class, false, 10, 0, new Object[]{this.getMessage()}, "Application Error Parameter");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnostic Information");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "User Message");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Inform Person Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Override Type");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Override Reason Code");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Help Desk Contact Point");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ERR - this is probably a bug in the source code generator.", e);
        }
    }

    public NULLDT getErrorCodeAndLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(1, 0);
        return retVal;
    }

    public NULLDT getErr1_ErrorCodeAndLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(1, 0);
        return retVal;
    }

    public ERL[] getErrorLocation() {
        ERL[] retVal = (ERL[])this.getTypedField(2, new ERL[0]);
        return retVal;
    }

    public ERL[] getErr2_ErrorLocation() {
        ERL[] retVal = (ERL[])this.getTypedField(2, new ERL[0]);
        return retVal;
    }

    public int getErrorLocationReps() {
        return this.getReps(2);
    }

    public ERL getErrorLocation(int rep) {
        ERL retVal = (ERL)this.getTypedField(2, rep);
        return retVal;
    }

    public ERL getErr2_ErrorLocation(int rep) {
        ERL retVal = (ERL)this.getTypedField(2, rep);
        return retVal;
    }

    public int getErr2_ErrorLocationReps() {
        return this.getReps(2);
    }

    public ERL insertErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.insertRepetition(2, rep);
    }

    public ERL insertErr2_ErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.insertRepetition(2, rep);
    }

    public ERL removeErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.removeRepetition(2, rep);
    }

    public ERL removeErr2_ErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.removeRepetition(2, rep);
    }

    public CWE getHL7ErrorCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getErr3_HL7ErrorCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getSeverity() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getErr4_Severity() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getApplicationErrorCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getErr5_ApplicationErrorCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public ST[] getApplicationErrorParameter() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getErr6_ApplicationErrorParameter() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getApplicationErrorParameterReps() {
        return this.getReps(6);
    }

    public ST getApplicationErrorParameter(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getErr6_ApplicationErrorParameter(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getErr6_ApplicationErrorParameterReps() {
        return this.getReps(6);
    }

    public ST insertApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertErr6_ApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeErr6_ApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public TX getDiagnosticInformation() {
        TX retVal = (TX)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getErr7_DiagnosticInformation() {
        TX retVal = (TX)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getUserMessage() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getErr8_UserMessage() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getInformPersonIndicator() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public CWE[] getErr9_InformPersonIndicator() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public int getInformPersonIndicatorReps() {
        return this.getReps(9);
    }

    public CWE getInformPersonIndicator(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getErr9_InformPersonIndicator(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getErr9_InformPersonIndicatorReps() {
        return this.getReps(9);
    }

    public CWE insertInformPersonIndicator(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertErr9_InformPersonIndicator(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeInformPersonIndicator(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeErr9_InformPersonIndicator(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE getOverrideType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getErr10_OverrideType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getOverrideReasonCode() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public CWE[] getErr11_OverrideReasonCode() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public int getOverrideReasonCodeReps() {
        return this.getReps(11);
    }

    public CWE getOverrideReasonCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getErr11_OverrideReasonCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getErr11_OverrideReasonCodeReps() {
        return this.getReps(11);
    }

    public CWE insertOverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertErr11_OverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeOverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removeErr11_OverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public XTN[] getHelpDeskContactPoint() {
        XTN[] retVal = (XTN[])this.getTypedField(12, new XTN[0]);
        return retVal;
    }

    public XTN[] getErr12_HelpDeskContactPoint() {
        XTN[] retVal = (XTN[])this.getTypedField(12, new XTN[0]);
        return retVal;
    }

    public int getHelpDeskContactPointReps() {
        return this.getReps(12);
    }

    public XTN getHelpDeskContactPoint(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public XTN getErr12_HelpDeskContactPoint(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getErr12_HelpDeskContactPointReps() {
        return this.getReps(12);
    }

    public XTN insertHelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN insertErr12_HelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN removeHelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    public XTN removeErr12_HelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NULLDT(this.getMessage());
            }
            case 1: {
                return new ERL(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(516));
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new TX(this.getMessage());
            }
            case 7: {
                return new TX(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new XTN(this.getMessage());
            }
        }
        return null;
    }
}

