/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.TQ;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SCH
extends AbstractSegment {
    public SCH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Placer Appointment ID");
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Filler Appointment ID");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Occurrence Number");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Placer Group Number");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Schedule ID");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Event Reason");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Appointment Reason");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Appointment Type");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Appointment Duration");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Appointment Duration Units");
            this.add(TQ.class, false, 0, 0, new Object[]{this.getMessage()}, "Appointment Timing Quantity");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Placer Contact Person");
            this.add(XTN.class, false, 1, 250, new Object[]{this.getMessage()}, "Placer Contact Phone Number");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Placer Contact Address");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Placer Contact Location");
            this.add(XCN.class, true, 0, 250, new Object[]{this.getMessage()}, "Filler Contact Person");
            this.add(XTN.class, false, 1, 250, new Object[]{this.getMessage()}, "Filler Contact Phone Number");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Filler Contact Address");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Filler Contact Location");
            this.add(XCN.class, true, 0, 250, new Object[]{this.getMessage()}, "Entered By Person");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Entered By Phone Number");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Entered By Location");
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Parent Placer Appointment ID");
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Parent Filler Appointment ID");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Filler Status Code");
            this.add(EI.class, false, 0, 427, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(EI.class, false, 0, 427, new Object[]{this.getMessage()}, "Filler Order Number");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SCH - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getSch1_PlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSch2_FillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOccurrenceNumber() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getSch3_OccurrenceNumber() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getPlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getSch4_PlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getScheduleID() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getSch5_ScheduleID() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getEventReason() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getSch6_EventReason() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getAppointmentReason() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getSch7_AppointmentReason() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getAppointmentType() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getSch8_AppointmentType() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getAppointmentDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getSch9_AppointmentDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CNE getAppointmentDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public CNE getSch10_AppointmentDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public TQ[] getAppointmentTimingQuantity() {
        TQ[] retVal = (TQ[])this.getTypedField(11, new TQ[0]);
        return retVal;
    }

    public TQ[] getSch11_AppointmentTimingQuantity() {
        TQ[] retVal = (TQ[])this.getTypedField(11, new TQ[0]);
        return retVal;
    }

    public int getAppointmentTimingQuantityReps() {
        return this.getReps(11);
    }

    public TQ getAppointmentTimingQuantity(int rep) {
        TQ retVal = (TQ)this.getTypedField(11, rep);
        return retVal;
    }

    public TQ getSch11_AppointmentTimingQuantity(int rep) {
        TQ retVal = (TQ)this.getTypedField(11, rep);
        return retVal;
    }

    public int getSch11_AppointmentTimingQuantityReps() {
        return this.getReps(11);
    }

    public TQ insertAppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(11, rep);
    }

    public TQ insertSch11_AppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(11, rep);
    }

    public TQ removeAppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(11, rep);
    }

    public TQ removeSch11_AppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(11, rep);
    }

    public XCN[] getPlacerContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(12, new XCN[0]);
        return retVal;
    }

    public XCN[] getSch12_PlacerContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(12, new XCN[0]);
        return retVal;
    }

    public int getPlacerContactPersonReps() {
        return this.getReps(12);
    }

    public XCN getPlacerContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public XCN getSch12_PlacerContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getSch12_PlacerContactPersonReps() {
        return this.getReps(12);
    }

    public XCN insertPlacerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN insertSch12_PlacerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN removePlacerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public XCN removeSch12_PlacerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public XTN getPlacerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(13, 0);
        return retVal;
    }

    public XTN getSch13_PlacerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(13, 0);
        return retVal;
    }

    public XAD[] getPlacerContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(14, new XAD[0]);
        return retVal;
    }

    public XAD[] getSch14_PlacerContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(14, new XAD[0]);
        return retVal;
    }

    public int getPlacerContactAddressReps() {
        return this.getReps(14);
    }

    public XAD getPlacerContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(14, rep);
        return retVal;
    }

    public XAD getSch14_PlacerContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(14, rep);
        return retVal;
    }

    public int getSch14_PlacerContactAddressReps() {
        return this.getReps(14);
    }

    public XAD insertPlacerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(14, rep);
    }

    public XAD insertSch14_PlacerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(14, rep);
    }

    public XAD removePlacerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(14, rep);
    }

    public XAD removeSch14_PlacerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(14, rep);
    }

    public PL getPlacerContactLocation() {
        PL retVal = (PL)this.getTypedField(15, 0);
        return retVal;
    }

    public PL getSch15_PlacerContactLocation() {
        PL retVal = (PL)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getFillerContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public XCN[] getSch16_FillerContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public int getFillerContactPersonReps() {
        return this.getReps(16);
    }

    public XCN getFillerContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getSch16_FillerContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getSch16_FillerContactPersonReps() {
        return this.getReps(16);
    }

    public XCN insertFillerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertSch16_FillerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeFillerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeSch16_FillerContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XTN getFillerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public XTN getSch17_FillerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public XAD[] getFillerContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(18, new XAD[0]);
        return retVal;
    }

    public XAD[] getSch18_FillerContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(18, new XAD[0]);
        return retVal;
    }

    public int getFillerContactAddressReps() {
        return this.getReps(18);
    }

    public XAD getFillerContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(18, rep);
        return retVal;
    }

    public XAD getSch18_FillerContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(18, rep);
        return retVal;
    }

    public int getSch18_FillerContactAddressReps() {
        return this.getReps(18);
    }

    public XAD insertFillerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(18, rep);
    }

    public XAD insertSch18_FillerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(18, rep);
    }

    public XAD removeFillerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(18, rep);
    }

    public XAD removeSch18_FillerContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(18, rep);
    }

    public PL getFillerContactLocation() {
        PL retVal = (PL)this.getTypedField(19, 0);
        return retVal;
    }

    public PL getSch19_FillerContactLocation() {
        PL retVal = (PL)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN[] getEnteredByPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(20, new XCN[0]);
        return retVal;
    }

    public XCN[] getSch20_EnteredByPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(20, new XCN[0]);
        return retVal;
    }

    public int getEnteredByPersonReps() {
        return this.getReps(20);
    }

    public XCN getEnteredByPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(20, rep);
        return retVal;
    }

    public XCN getSch20_EnteredByPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(20, rep);
        return retVal;
    }

    public int getSch20_EnteredByPersonReps() {
        return this.getReps(20);
    }

    public XCN insertEnteredByPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(20, rep);
    }

    public XCN insertSch20_EnteredByPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(20, rep);
    }

    public XCN removeEnteredByPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(20, rep);
    }

    public XCN removeSch20_EnteredByPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(20, rep);
    }

    public XTN[] getEnteredByPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(21, new XTN[0]);
        return retVal;
    }

    public XTN[] getSch21_EnteredByPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(21, new XTN[0]);
        return retVal;
    }

    public int getEnteredByPhoneNumberReps() {
        return this.getReps(21);
    }

    public XTN getEnteredByPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(21, rep);
        return retVal;
    }

    public XTN getSch21_EnteredByPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(21, rep);
        return retVal;
    }

    public int getSch21_EnteredByPhoneNumberReps() {
        return this.getReps(21);
    }

    public XTN insertEnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN insertSch21_EnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN removeEnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public XTN removeSch21_EnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public PL getEnteredByLocation() {
        PL retVal = (PL)this.getTypedField(22, 0);
        return retVal;
    }

    public PL getSch22_EnteredByLocation() {
        PL retVal = (PL)this.getTypedField(22, 0);
        return retVal;
    }

    public EI getParentPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public EI getSch23_ParentPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public EI getParentFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(24, 0);
        return retVal;
    }

    public EI getSch24_ParentFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getFillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getSch25_FillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public EI[] getPlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(26, new EI[0]);
        return retVal;
    }

    public EI[] getSch26_PlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(26, new EI[0]);
        return retVal;
    }

    public int getPlacerOrderNumberReps() {
        return this.getReps(26);
    }

    public EI getPlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(26, rep);
        return retVal;
    }

    public EI getSch26_PlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(26, rep);
        return retVal;
    }

    public int getSch26_PlacerOrderNumberReps() {
        return this.getReps(26);
    }

    public EI insertPlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(26, rep);
    }

    public EI insertSch26_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(26, rep);
    }

    public EI removePlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(26, rep);
    }

    public EI removeSch26_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(26, rep);
    }

    public EI[] getFillerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(27, new EI[0]);
        return retVal;
    }

    public EI[] getSch27_FillerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(27, new EI[0]);
        return retVal;
    }

    public int getFillerOrderNumberReps() {
        return this.getReps(27);
    }

    public EI getFillerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(27, rep);
        return retVal;
    }

    public EI getSch27_FillerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(27, rep);
        return retVal;
    }

    public int getSch27_FillerOrderNumberReps() {
        return this.getReps(27);
    }

    public EI insertFillerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(27, rep);
    }

    public EI insertSch27_FillerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(27, rep);
    }

    public EI removeFillerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(27, rep);
    }

    public EI removeSch27_FillerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(27, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CNE(this.getMessage());
            }
            case 10: {
                return new TQ(this.getMessage());
            }
            case 11: {
                return new XCN(this.getMessage());
            }
            case 12: {
                return new XTN(this.getMessage());
            }
            case 13: {
                return new XAD(this.getMessage());
            }
            case 14: {
                return new PL(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new XTN(this.getMessage());
            }
            case 17: {
                return new XAD(this.getMessage());
            }
            case 18: {
                return new PL(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new XTN(this.getMessage());
            }
            case 21: {
                return new PL(this.getMessage());
            }
            case 22: {
                return new EI(this.getMessage());
            }
            case 23: {
                return new EI(this.getMessage());
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new EI(this.getMessage());
            }
            case 26: {
                return new EI(this.getMessage());
            }
        }
        return null;
    }
}

