/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.NULLDT;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MSA
extends AbstractSegment {
    public MSA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(8)}, "Acknowledgment Code");
            this.add(ST.class, true, 1, 199, new Object[]{this.getMessage()}, "Message Control ID");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Text Message");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "Expected Sequence Number");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Delayed Acknowledgment Type");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Error Condition");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Message Waiting Number");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(520)}, "Message Waiting Priority");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MSA - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getAcknowledgmentCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getMsa1_AcknowledgmentCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMessageControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMsa2_MessageControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getTextMessage() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getMsa3_TextMessage() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getExpectedSequenceNumber() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getMsa4_ExpectedSequenceNumber() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NULLDT getDelayedAcknowledgmentType() {
        NULLDT retVal = (NULLDT)this.getTypedField(5, 0);
        return retVal;
    }

    public NULLDT getMsa5_DelayedAcknowledgmentType() {
        NULLDT retVal = (NULLDT)this.getTypedField(5, 0);
        return retVal;
    }

    public CNE getErrorCondition() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getMsa6_ErrorCondition() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getMessageWaitingNumber() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getMsa7_MessageWaitingNumber() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getMessageWaitingPriority() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getMsa8_MessageWaitingPriority() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(8));
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new NULLDT(this.getMessage());
            }
            case 5: {
                return new CNE(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(520));
            }
        }
        return null;
    }
}

