/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.RSP_K11_ROW_DEFINITION;
import ca.uhn.hl7v2.model.v26.segment.DSC;
import ca.uhn.hl7v2.model.v26.segment.ERR;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.QAK;
import ca.uhn.hl7v2.model.v26.segment.QPD;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_K11
extends AbstractMessage {
    public RSP_K11() {
        this(new DefaultModelClassFactory());
    }

    public RSP_K11(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, true, false);
            this.add(QPD.class, true, false);
            this.add(RSP_K11_ROW_DEFINITION.class, false, false);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_K11 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QPD getQPD() {
        return this.getTyped("QPD", QPD.class);
    }

    public RSP_K11_ROW_DEFINITION getROW_DEFINITION() {
        return this.getTyped("ROW_DEFINITION", RSP_K11_ROW_DEFINITION.class);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

