/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.ORG_O20_OBSERVATION_GROUP;
import ca.uhn.hl7v2.model.v26.group.ORG_O20_SPECIMEN;
import ca.uhn.hl7v2.model.v26.group.ORG_O20_TIMING;
import ca.uhn.hl7v2.model.v26.segment.CTI;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORG_O20_ORDER
extends AbstractGroup {
    public ORG_O20_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(ORG_O20_TIMING.class, false, true, false);
            this.add(ORG_O20_OBSERVATION_GROUP.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(CTI.class, false, true, false);
            this.add(ORG_O20_SPECIMEN.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORG_O20_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public ORG_O20_TIMING getTIMING() {
        ORG_O20_TIMING retVal = this.getTyped("TIMING", ORG_O20_TIMING.class);
        return retVal;
    }

    public ORG_O20_TIMING getTIMING(int rep) {
        ORG_O20_TIMING retVal = this.getTyped("TIMING", rep, ORG_O20_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<ORG_O20_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", ORG_O20_TIMING.class);
    }

    public void insertTIMING(ORG_O20_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public ORG_O20_TIMING insertTIMING(int rep) throws HL7Exception {
        return (ORG_O20_TIMING)super.insertRepetition("TIMING", rep);
    }

    public ORG_O20_TIMING removeTIMING(int rep) throws HL7Exception {
        return (ORG_O20_TIMING)super.removeRepetition("TIMING", rep);
    }

    public ORG_O20_OBSERVATION_GROUP getOBSERVATION_GROUP() {
        ORG_O20_OBSERVATION_GROUP retVal = this.getTyped("OBSERVATION_GROUP", ORG_O20_OBSERVATION_GROUP.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CTI getCTI() {
        CTI retVal = this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }

    public ORG_O20_SPECIMEN getSPECIMEN() {
        ORG_O20_SPECIMEN retVal = this.getTyped("SPECIMEN", ORG_O20_SPECIMEN.class);
        return retVal;
    }

    public ORG_O20_SPECIMEN getSPECIMEN(int rep) {
        ORG_O20_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, ORG_O20_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<ORG_O20_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", ORG_O20_SPECIMEN.class);
    }

    public void insertSPECIMEN(ORG_O20_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public ORG_O20_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORG_O20_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORG_O20_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORG_O20_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

