/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.MO;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IIM
extends AbstractSegment {
    public IIM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Primary Key Value - IIM");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Service Item Code");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Lot Number");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Inventory Expiration Date");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Manufacturer Name");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Location");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Inventory Received Date");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Inventory Received Quantity");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Received Quantity Unit");
            this.add(MO.class, false, 1, 12, new Object[]{this.getMessage()}, "Inventory Received Item Cost");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Inventory On Hand Date");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Inventory On Hand Quantity");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory On Hand Quantity Unit");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Procedure Code Modifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IIM - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getPrimaryKeyValueIIM() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getIim1_PrimaryKeyValueIIM() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getServiceItemCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getIim2_ServiceItemCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getInventoryLotNumber() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getIim3_InventoryLotNumber() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getInventoryExpirationDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getIim4_InventoryExpirationDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getInventoryManufacturerName() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getIim5_InventoryManufacturerName() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getInventoryLocation() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getIim6_InventoryLocation() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getInventoryReceivedDate() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getIim7_InventoryReceivedDate() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getInventoryReceivedQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getIim8_InventoryReceivedQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getInventoryReceivedQuantityUnit() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getIim9_InventoryReceivedQuantityUnit() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public MO getInventoryReceivedItemCost() {
        MO retVal = (MO)this.getTypedField(10, 0);
        return retVal;
    }

    public MO getIim10_InventoryReceivedItemCost() {
        MO retVal = (MO)this.getTypedField(10, 0);
        return retVal;
    }

    public TS getInventoryOnHandDate() {
        TS retVal = (TS)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getIim11_InventoryOnHandDate() {
        TS retVal = (TS)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getInventoryOnHandQuantity() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getIim12_InventoryOnHandQuantity() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getInventoryOnHandQuantityUnit() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getIim13_InventoryOnHandQuantityUnit() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getProcedureCode() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getIim14_ProcedureCode() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE[] getProcedureCodeModifier() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public CE[] getIim15_ProcedureCodeModifier() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public int getProcedureCodeModifierReps() {
        return this.getReps(15);
    }

    public CE getProcedureCodeModifier(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public CE getIim15_ProcedureCodeModifier(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getIim15_ProcedureCodeModifierReps() {
        return this.getReps(15);
    }

    public CE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE insertIim15_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public CE removeIim15_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new MO(this.getMessage());
            }
            case 10: {
                return new TS(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

