/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_PATHWAY;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPG_PCG
extends AbstractMessage {
    public PPG_PCG() {
        this(new DefaultModelClassFactory());
    }

    public PPG_PCG(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(PID.class, true, false);
            this.add(PPG_PCG_PATIENT_VISIT.class, false, false);
            this.add(PPG_PCG_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPG_PCG - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PPG_PCG_PATIENT_VISIT getPATIENT_VISIT() {
        return this.getTyped("PATIENT_VISIT", PPG_PCG_PATIENT_VISIT.class);
    }

    public PPG_PCG_PATHWAY getPATHWAY() {
        return this.getTyped("PATHWAY", PPG_PCG_PATHWAY.class);
    }

    public PPG_PCG_PATHWAY getPATHWAY(int rep) {
        return this.getTyped("PATHWAY", rep, PPG_PCG_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PPG_PCG_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPG_PCG_PATHWAY.class);
    }

    public void insertPATHWAY(PPG_PCG_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", structure, rep);
    }

    public PPG_PCG_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPG_PCG_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

