/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CNE;
import ca.uhn.hl7v2.model.v25.datatype.DT;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import ca.uhn.hl7v2.model.v25.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IAM
extends AbstractSegment {
    public IAM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - IAM");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Allergen Type Code");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Allergen Code/Mnemonic/Description");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Allergy Severity Code");
            this.add(ST.class, false, 0, 15, new Object[]{this.getMessage()}, "Allergy Reaction Code");
            this.add(CNE.class, true, 1, 250, new Object[]{this.getMessage()}, "Allergy Action Code");
            this.add(EI.class, false, 1, 427, new Object[]{this.getMessage()}, "Allergy Unique Identifier");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Action Reason");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Sensitivity to Causative Agent Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Allergen Group Code/Mnemonic/Description");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Onset Date");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Onset Date Text");
            this.add(TS.class, false, 1, 8, new Object[]{this.getMessage()}, "Reported Date/Time");
            this.add(XPN.class, false, 1, 250, new Object[]{this.getMessage()}, "Reported By");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Relationship to Patient Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Alert Device Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Allergy Clinical Status Code");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Statused by Person");
            this.add(XON.class, false, 1, 250, new Object[]{this.getMessage()}, "Statused by Organization");
            this.add(TS.class, false, 1, 8, new Object[]{this.getMessage()}, "Statused at Date/Time");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IAM - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDIAM() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIam1_SetIDIAM() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAllergenTypeCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getIam2_AllergenTypeCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAllergenCodeMnemonicDescription() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getIam3_AllergenCodeMnemonicDescription() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getAllergySeverityCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getIam4_AllergySeverityCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getAllergyReactionCode() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getIam5_AllergyReactionCode() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getAllergyReactionCodeReps() {
        return this.getReps(5);
    }

    public ST getAllergyReactionCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getIam5_AllergyReactionCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getIam5_AllergyReactionCodeReps() {
        return this.getReps(5);
    }

    public ST insertAllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertIam5_AllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeAllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeIam5_AllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public CNE getAllergyActionCode() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getIam6_AllergyActionCode() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getAllergyUniqueIdentifier() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public EI getIam7_AllergyUniqueIdentifier() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getActionReason() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getIam8_ActionReason() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getSensitivityToCausativeAgentCode() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getIam9_SensitivityToCausativeAgentCode() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getAllergenGroupCodeMnemonicDescription() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getIam10_AllergenGroupCodeMnemonicDescription() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getOnsetDate() {
        DT retVal = (DT)this.getTypedField(11, 0);
        return retVal;
    }

    public DT getIam11_OnsetDate() {
        DT retVal = (DT)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getOnsetDateText() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getIam12_OnsetDateText() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getReportedDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getIam13_ReportedDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public XPN getReportedBy() {
        XPN retVal = (XPN)this.getTypedField(14, 0);
        return retVal;
    }

    public XPN getIam14_ReportedBy() {
        XPN retVal = (XPN)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getRelationshipToPatientCode() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getIam15_RelationshipToPatientCode() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getAlertDeviceCode() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getIam16_AlertDeviceCode() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getAllergyClinicalStatusCode() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getIam17_AllergyClinicalStatusCode() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public XCN getStatusedByPerson() {
        XCN retVal = (XCN)this.getTypedField(18, 0);
        return retVal;
    }

    public XCN getIam18_StatusedByPerson() {
        XCN retVal = (XCN)this.getTypedField(18, 0);
        return retVal;
    }

    public XON getStatusedByOrganization() {
        XON retVal = (XON)this.getTypedField(19, 0);
        return retVal;
    }

    public XON getIam19_StatusedByOrganization() {
        XON retVal = (XON)this.getTypedField(19, 0);
        return retVal;
    }

    public TS getStatusedAtDateTime() {
        TS retVal = (TS)this.getTypedField(20, 0);
        return retVal;
    }

    public TS getIam20_StatusedAtDateTime() {
        TS retVal = (TS)this.getTypedField(20, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new CNE(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new DT(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new TS(this.getMessage());
            }
            case 13: {
                return new XPN(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new XCN(this.getMessage());
            }
            case 18: {
                return new XON(this.getMessage());
            }
            case 19: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

