/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ACC
extends AbstractSegment {
    public ACC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Accident Date/Time");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Accident Code");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Accident Location");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Auto Accident State");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Accident Job Related Indicator");
            this.add(ID.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(136)}, "Accident Death Indicator");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Entered By");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Accident Description");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Brought In By");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Police Notified Indicator");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "Accident Address");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ACC - this is probably a bug in the source code generator.", e);
        }
    }

    public TS getAccidentDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getAcc1_AccidentDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAccidentCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAcc2_AccidentCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getAccidentLocation() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getAcc3_AccidentLocation() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getAutoAccidentState() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAcc4_AutoAccidentState() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getAccidentJobRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getAcc5_AccidentJobRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getAccidentDeathIndicator() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getAcc6_AccidentDeathIndicator() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public XCN getEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN getAcc7_EnteredBy() {
        XCN retVal = (XCN)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getAccidentDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getAcc8_AccidentDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getBroughtInBy() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getAcc9_BroughtInBy() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPoliceNotifiedIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getAcc10_PoliceNotifiedIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD getAccidentAddress() {
        XAD retVal = (XAD)this.getTypedField(11, 0);
        return retVal;
    }

    public XAD getAcc11_AccidentAddress() {
        XAD retVal = (XAD)this.getTypedField(11, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 6: {
                return new XCN(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 10: {
                return new XAD(this.getMessage());
            }
        }
        return null;
    }
}

