/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ABS
extends AbstractSegment {
    public ABS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Discharge Care Provider");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Transfer Medical Service Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Severity of Illness Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of Attestation");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Attested By");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Triage Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Abstract Completion Date/Time");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Abstracted By");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Case Category Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Caesarian Section Indicator");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Gestation Category Code");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Gestation Period - Weeks");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Newborn Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Stillborn Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ABS - this is probably a bug in the source code generator.", e);
        }
    }

    public XCN getDischargeCareProvider() {
        XCN retVal = (XCN)this.getTypedField(1, 0);
        return retVal;
    }

    public XCN getAbs1_DischargeCareProvider() {
        XCN retVal = (XCN)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getTransferMedicalServiceCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAbs2_TransferMedicalServiceCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getSeverityOfIllnessCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getAbs3_SeverityOfIllnessCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getDateTimeOfAttestation() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getAbs4_DateTimeOfAttestation() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getAttestedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public XCN getAbs5_AttestedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getTriageCode() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getAbs6_TriageCode() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getAbstractCompletionDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getAbs7_AbstractCompletionDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN getAbstractedBy() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public XCN getAbs8_AbstractedBy() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getCaseCategoryCode() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getAbs9_CaseCategoryCode() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getCaesarianSectionIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getAbs10_CaesarianSectionIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getGestationCategoryCode() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getAbs11_GestationCategoryCode() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getGestationPeriodWeeks() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getAbs12_GestationPeriodWeeks() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getNewbornCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getAbs13_NewbornCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getStillbornIndicator() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getAbs14_StillbornIndicator() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new XCN(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

