/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.RAR_RAR_DEFINITION;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RAR_RAR
extends AbstractMessage {
    public RAR_RAR() {
        this(new DefaultModelClassFactory());
    }

    public RAR_RAR(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(RAR_RAR_DEFINITION.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RAR_RAR - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public RAR_RAR_DEFINITION getDEFINITION() {
        return this.getTyped("DEFINITION", RAR_RAR_DEFINITION.class);
    }

    public RAR_RAR_DEFINITION getDEFINITION(int rep) {
        return this.getTyped("DEFINITION", rep, RAR_RAR_DEFINITION.class);
    }

    public int getDEFINITIONReps() {
        return this.getReps("DEFINITION");
    }

    public List<RAR_RAR_DEFINITION> getDEFINITIONAll() throws HL7Exception {
        return this.getAllAsList("DEFINITION", RAR_RAR_DEFINITION.class);
    }

    public void insertDEFINITION(RAR_RAR_DEFINITION structure, int rep) throws HL7Exception {
        super.insertRepetition("DEFINITION", structure, rep);
    }

    public RAR_RAR_DEFINITION insertDEFINITION(int rep) throws HL7Exception {
        return (RAR_RAR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }

    public RAR_RAR_DEFINITION removeDEFINITION(int rep) throws HL7Exception {
        return (RAR_RAR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

