/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.PPG_PCJ_PATHWAY;
import ca.uhn.hl7v2.model.v23.group.PPG_PCJ_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPG_PCJ
extends AbstractMessage {
    public PPG_PCJ() {
        this(new DefaultModelClassFactory());
    }

    public PPG_PCJ(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PPG_PCJ_PATIENT_VISIT.class, false, false);
            this.add(PPG_PCJ_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPG_PCJ - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PPG_PCJ_PATIENT_VISIT getPATIENT_VISIT() {
        return this.getTyped("PATIENT_VISIT", PPG_PCJ_PATIENT_VISIT.class);
    }

    public PPG_PCJ_PATHWAY getPATHWAY() {
        return this.getTyped("PATHWAY", PPG_PCJ_PATHWAY.class);
    }

    public PPG_PCJ_PATHWAY getPATHWAY(int rep) {
        return this.getTyped("PATHWAY", rep, PPG_PCJ_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PPG_PCJ_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPG_PCJ_PATHWAY.class);
    }

    public void insertPATHWAY(PPG_PCJ_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", structure, rep);
    }

    public PPG_PCJ_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPG_PCJ_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPG_PCJ_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPG_PCJ_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

