/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.BAR_P05_VISIT;
import ca.uhn.hl7v2.model.v23.segment.EVN;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.PD1;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class BAR_P05
extends AbstractMessage {
    public BAR_P05() {
        this(new DefaultModelClassFactory());
    }

    public BAR_P05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(BAR_P05_VISIT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BAR_P05 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public BAR_P05_VISIT getVISIT() {
        return this.getTyped("VISIT", BAR_P05_VISIT.class);
    }

    public BAR_P05_VISIT getVISIT(int rep) {
        return this.getTyped("VISIT", rep, BAR_P05_VISIT.class);
    }

    public int getVISITReps() {
        return this.getReps("VISIT");
    }

    public List<BAR_P05_VISIT> getVISITAll() throws HL7Exception {
        return this.getAllAsList("VISIT", BAR_P05_VISIT.class);
    }

    public void insertVISIT(BAR_P05_VISIT structure, int rep) throws HL7Exception {
        super.insertRepetition("VISIT", structure, rep);
    }

    public BAR_P05_VISIT insertVISIT(int rep) throws HL7Exception {
        return (BAR_P05_VISIT)super.insertRepetition("VISIT", rep);
    }

    public BAR_P05_VISIT removeVISIT(int rep) throws HL7Exception {
        return (BAR_P05_VISIT)super.removeRepetition("VISIT", rep);
    }
}

