/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class URD
extends AbstractSegment {
    public URD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "R/U DATE/TIME");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(109)}, "REPORT PRIORITY");
            this.add(ST.class, true, 0, 20, new Object[]{this.getMessage()}, "R/U WHO SUBJECT DEFINITION");
            this.add(ID.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(48)}, "R/U WHAT SUBJECT DEFINITION");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U WHAT DEPARTMENT CODE");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U DISPLAY/PRINT LOCATIONS");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(108)}, "R/U RESULTS LEVEL");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating URD - this is probably a bug in the source code generator.", e);
        }
    }

    public TS getRUDATETIME() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getUrd1_RUDATETIME() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getREPORTPRIORITY() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getUrd2_REPORTPRIORITY() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ST[] getRUWHOSUBJECTDEFINITION() {
        ST[] retVal = (ST[])this.getTypedField(3, new ST[0]);
        return retVal;
    }

    public ST[] getUrd3_RUWHOSUBJECTDEFINITION() {
        ST[] retVal = (ST[])this.getTypedField(3, new ST[0]);
        return retVal;
    }

    public int getRUWHOSUBJECTDEFINITIONReps() {
        return this.getReps(3);
    }

    public ST getRUWHOSUBJECTDEFINITION(int rep) {
        ST retVal = (ST)this.getTypedField(3, rep);
        return retVal;
    }

    public ST getUrd3_RUWHOSUBJECTDEFINITION(int rep) {
        ST retVal = (ST)this.getTypedField(3, rep);
        return retVal;
    }

    public int getUrd3_RUWHOSUBJECTDEFINITIONReps() {
        return this.getReps(3);
    }

    public ST insertRUWHOSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(3, rep);
    }

    public ST insertUrd3_RUWHOSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(3, rep);
    }

    public ST removeRUWHOSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(3, rep);
    }

    public ST removeUrd3_RUWHOSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(3, rep);
    }

    public ID[] getRUWHATSUBJECTDEFINITION() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public ID[] getUrd4_RUWHATSUBJECTDEFINITION() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public int getRUWHATSUBJECTDEFINITIONReps() {
        return this.getReps(4);
    }

    public ID getRUWHATSUBJECTDEFINITION(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public ID getUrd4_RUWHATSUBJECTDEFINITION(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public int getUrd4_RUWHATSUBJECTDEFINITIONReps() {
        return this.getReps(4);
    }

    public ID insertRUWHATSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID insertUrd4_RUWHATSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID removeRUWHATSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID removeUrd4_RUWHATSUBJECTDEFINITION(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ST[] getRUWHATDEPARTMENTCODE() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getUrd5_RUWHATDEPARTMENTCODE() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getRUWHATDEPARTMENTCODEReps() {
        return this.getReps(5);
    }

    public ST getRUWHATDEPARTMENTCODE(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getUrd5_RUWHATDEPARTMENTCODE(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getUrd5_RUWHATDEPARTMENTCODEReps() {
        return this.getReps(5);
    }

    public ST insertRUWHATDEPARTMENTCODE(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertUrd5_RUWHATDEPARTMENTCODE(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeRUWHATDEPARTMENTCODE(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeUrd5_RUWHATDEPARTMENTCODE(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST[] getRUDISPLAYPRINTLOCATIONS() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getUrd6_RUDISPLAYPRINTLOCATIONS() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getRUDISPLAYPRINTLOCATIONSReps() {
        return this.getReps(6);
    }

    public ST getRUDISPLAYPRINTLOCATIONS(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getUrd6_RUDISPLAYPRINTLOCATIONS(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getUrd6_RUDISPLAYPRINTLOCATIONSReps() {
        return this.getReps(6);
    }

    public ST insertRUDISPLAYPRINTLOCATIONS(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertUrd6_RUDISPLAYPRINTLOCATIONS(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeRUDISPLAYPRINTLOCATIONS(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeUrd6_RUDISPLAYPRINTLOCATIONS(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ID getRURESULTSLEVEL() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getUrd7_RURESULTSLEVEL() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(109));
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(48));
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(108));
            }
        }
        return null;
    }
}

