/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.concurrent.Service;
import ca.uhn.hl7v2.util.SocketFactory;
import ca.uhn.hl7v2.util.StandardSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AcceptorThread
extends Service {
    @Deprecated
    static final int TIMEOUT = 500;
    private static final Logger log = LoggerFactory.getLogger(AcceptorThread.class);
    private int port;
    private boolean tls = false;
    private ServerSocket ss;
    private final BlockingQueue<AcceptedSocket> queue;
    private final SocketFactory socketFactory;

    public AcceptorThread(ServerSocket serverSocket, int port, ExecutorService service, BlockingQueue<AcceptedSocket> queue) throws IOException, SocketException {
        this(port, false, service, queue);
        this.ss = serverSocket;
    }

    public AcceptorThread(int port, ExecutorService service, BlockingQueue<AcceptedSocket> queue) throws IOException, SocketException {
        this(port, false, service, queue);
    }

    public AcceptorThread(int port, boolean tls, ExecutorService service, BlockingQueue<AcceptedSocket> queue) throws IOException, SocketException {
        this(port, tls, service, queue, null);
    }

    public AcceptorThread(int port, boolean tls, ExecutorService service, BlockingQueue<AcceptedSocket> queue, SocketFactory socketFactory) {
        super("Socket Acceptor", service);
        this.port = port;
        this.queue = queue;
        this.tls = tls;
        if (socketFactory == null) {
            socketFactory = new StandardSocketFactory();
        }
        this.socketFactory = socketFactory;
    }

    @Override
    protected void afterStartup() {
        super.afterStartup();
        try {
            this.ss = this.tls ? this.socketFactory.createTlsServerSocket() : this.socketFactory.createServerSocket();
            this.ss.bind(new InetSocketAddress(this.port));
            this.ss.setSoTimeout(500);
        }
        catch (IOException e) {
            String message = String.format("Unable to create ServerSocket on port %d", this.port);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    protected void handle() {
        try {
            Socket s = this.ss.accept();
            this.socketFactory.configureNewAcceptedSocket(s);
            if (!this.queue.offer(new AcceptedSocket(s))) {
                log.error("Denied enqueuing server-side socket {}", (Object)s);
                s.close();
            } else {
                log.debug("Enqueued server-side socket {}", (Object)s);
            }
        }
        catch (SocketTimeoutException e) {
            log.trace("No connection established while waiting");
        }
        catch (IOException e) {
            log.error("Error while accepting connections", e);
        }
    }

    @Override
    protected void afterTermination() {
        super.afterTermination();
        try {
            if (this.ss != null && !this.ss.isClosed()) {
                this.ss.close();
            }
        }
        catch (IOException e) {
            log.warn("Error during stopping the thread", e);
        }
    }

    class AcceptedSocket {
        Socket socket;
        AcceptorThread origin;

        public AcceptedSocket(Socket socket) {
            if (socket == null) {
                throw new IllegalArgumentException("Socket must not be null");
            }
            this.socket = socket;
            this.origin = AcceptorThread.this;
        }
    }
}

