/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7.tools;

import ca.infodata.util1.date.LocaleProvider;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Messages {
    private static final Logger logger = Logger.getLogger(Messages.class.getName());
    private static final String BUNDLE_NAME = "ca.infodata.readhl7.tools.messages";
    public static final ResourceBundle EN = ResourceBundle.getBundle("ca.infodata.readhl7.tools.messages", Locale.ENGLISH);
    public static final ResourceBundle FR = ResourceBundle.getBundle("ca.infodata.readhl7.tools.messages", Locale.FRENCH);
    public static final ResourceBundle ES = ResourceBundle.getBundle("ca.infodata.readhl7.tools.messages", new Locale("es"));

    private Messages() {
        throw new UnsupportedOperationException();
    }

    public static String getString(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key) {
        try {
            return Messages.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    private static ResourceBundle getResourceBundle() {
        if (LocaleProvider.isFrench()) {
            return FR;
        }
        if (LocaleProvider.isEnglish()) {
            return EN;
        }
        if (LocaleProvider.isSpanish()) {
            return ES;
        }
        logger.log(Level.WARNING, "No ressource bundle for locale " + LocaleProvider.getLocale() + ". Use default FR");
        return FR;
    }
}

