/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7.tools;

import ca.infodata.readhl7.Gender;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DataTypeUtils {
    private static final Logger logger = Logger.getLogger(DataTypeUtils.class.getName());
    public static final String HEALTH_NUMBER = "HEALTH_NUMBER";
    public static final String CHART_NUMBER = "CHART_NUMBER";
    public static final String HL7_VERSION_ID = "2.6";
    public static final int NTE_COMMENT_MAX_SIZE = 65536;
    public static final String ACTION_ROLE_SENDER = "SENDER";
    public static final String ACTION_ROLE_RECEIVER = "RECEIVER";
    private static final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyyMMddHHmmss");

    private DataTypeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAsHl7FormattedString(Date date) {
        SimpleDateFormat simpleDateFormat = dateTimeFormatter;
        synchronized (simpleDateFormat) {
            return dateTimeFormatter.format(date);
        }
    }

    public static GregorianCalendar getCalendarFromDTM(DTM dtm) throws DataTypeException {
        if (dtm.getYear() == 0 || dtm.getMonth() == 0 || dtm.getDay() == 0) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(0L);
        cal.set(1, dtm.getYear());
        cal.set(2, dtm.getMonth() - 1);
        cal.set(5, dtm.getDay());
        cal.set(11, dtm.getHour());
        cal.set(12, dtm.getMinute());
        cal.set(13, dtm.getSecond());
        cal.getTimeInMillis();
        return cal;
    }

    public static GregorianCalendar getCalendarFromDTM(TS ts) throws DataTypeException {
        if (ts.getTimeOfAnEvent().getYear() == 0 || ts.getTimeOfAnEvent().getMonth() == 0 || ts.getTimeOfAnEvent().getDay() == 0) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(0L);
        cal.set(1, ts.getTimeOfAnEvent().getYear());
        cal.set(2, ts.getTimeOfAnEvent().getMonth() - 1);
        cal.set(5, ts.getTimeOfAnEvent().getDay());
        cal.set(11, ts.getTimeOfAnEvent().getHour());
        cal.set(12, ts.getTimeOfAnEvent().getMinute());
        cal.set(13, ts.getTimeOfAnEvent().getSecond());
        cal.getTimeInMillis();
        return cal;
    }

    public static String getHl7GenderFromOscarGender(String oscarGender) {
        Gender gender = null;
        try {
            gender = Gender.valueOf(oscarGender);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Missed gender or dirty data in database. demographic.sex=" + oscarGender);
        }
        return DataTypeUtils.getHl7GenderFromOscarGender(gender);
    }

    public static String getHl7GenderFromOscarGender(Gender oscarGender) {
        if (oscarGender == null) {
            return "U";
        }
        if (Gender.M == oscarGender) {
            return "M";
        }
        if (Gender.F == oscarGender) {
            return "F";
        }
        if (Gender.O == oscarGender) {
            return "O";
        }
        if (Gender.T == oscarGender) {
            return "A";
        }
        if (Gender.U == oscarGender) {
            return "N";
        }
        logger.log(Level.SEVERE, "Missed gender or dirty data in database. demographic.sex=" + (Object)((Object)oscarGender));
        return "U";
    }

    public static Gender getOscarGenderFromHl7Gender(String hl7Gender) {
        if (hl7Gender == null) {
            return null;
        }
        if ("M".equals(hl7Gender = hl7Gender.toUpperCase())) {
            return Gender.M;
        }
        if ("F".equals(hl7Gender)) {
            return Gender.F;
        }
        if ("O".equals(hl7Gender)) {
            return Gender.O;
        }
        if ("A".equals(hl7Gender)) {
            return Gender.T;
        }
        if ("N".equals(hl7Gender)) {
            return Gender.U;
        }
        if ("U".equals(hl7Gender)) {
            return null;
        }
        throw new IllegalArgumentException("Missed gender : " + hl7Gender);
    }
}

