/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProviderData {
    private static final Logger log = Logger.getLogger(ProviderData.class.getName());
    private static Connection conn;
    public String referringDoctor;
    public String consultingDoctor;
    public String admittingDoctor;

    public ProviderData(String refDoctor, String conDoctor, String admDoctor, Connection con) {
        this.referringDoctor = ProviderData.beautifyProviderName(refDoctor);
        this.consultingDoctor = ProviderData.beautifyProviderName(conDoctor);
        this.admittingDoctor = ProviderData.beautifyProviderName(admDoctor);
        conn = con;
    }

    public static String beautifyProviderName(String name) {
        if (name.length() > 0) {
            try {
                String[] subStrings = name.split("\\^");
                if (subStrings.length >= 18) {
                    return subStrings[5] + " " + subStrings[1] + ", " + subStrings[17] + " " + subStrings[13];
                }
                if (subStrings.length >= 14) {
                    return subStrings[5] + " " + subStrings[1] + ", " + subStrings[13];
                }
                if (subStrings.length >= 6) {
                    return subStrings[5] + " " + subStrings[1];
                }
                return subStrings[1];
            }
            catch (Exception e) {
                log.log(Level.FINE, "Error in ProviderData: " + e.toString());
                return name.replace('^', ' ');
            }
        }
        return "";
    }

    public static ArrayList<ArrayList<String>> getProviderList() {
        try {
            ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
            String sql = "select provider_no, first_name, last_name from provider where provider_type='doctor' order by last_name , first_name";
            PreparedStatement pstmt = conn.prepareStatement("select provider_no, first_name, last_name from provider where provider_type='doctor' order by last_name , first_name");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ArrayList<String> provider = new ArrayList<String>();
                provider.add(rs.getString("provider_no"));
                provider.add(rs.getString("first_name"));
                provider.add(rs.getString("last_name"));
                result.add(provider);
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.FINE, "exception in ProviderData:" + e);
            return null;
        }
    }

    public static ArrayList<ArrayList<String>> getProviderListWithLabNo() {
        try {
            ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
            String sql = "select provider_no, first_name, last_name from provider where provider_type='doctor'  and ohip_no != '' order by last_name , first_name";
            PreparedStatement pstmt = conn.prepareStatement("select provider_no, first_name, last_name from provider where provider_type='doctor'  and ohip_no != '' order by last_name , first_name");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ArrayList<String> provider = new ArrayList<String>();
                provider.add(rs.getString("provider_no"));
                provider.add(rs.getString("first_name"));
                provider.add(rs.getString("last_name"));
                result.add(provider);
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.FINE, "exception in ProviderData:" + e);
            return null;
        }
    }

    public static String getProviderName(String providerNo) {
        try {
            String sql = "select first_name, last_name from provider where provider_no='" + providerNo + "'";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                return rs.getString("first_name") + " " + rs.getString("last_name");
            }
            return "";
        }
        catch (Exception e) {
            log.log(Level.FINE, "exception in ProviderData:" + e);
            return null;
        }
    }
}

