/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.site2.menu;

import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.site2.menu.SiteElement;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class SubListSiteElement
implements ITreeElements {
    private ITreeElements parent;
    private ITreeElements[] children;
    private List<XSite> sites;
    private String label;

    public SubListSiteElement(ITreeElements parent, List<XSite> sites, String label) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.sites = new ArrayList<XSite>(sites);
        this.label = label;
        this.parent = parent;
    }

    public Object[] getChildren() {
        if (this.children == null) {
            List<ITreeElements> listChild = this.fillSites(this.sites);
            this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        }
        return this.children;
    }

    protected List<ITreeElements> fillSites(List<XSite> list) {
        ArrayList<ITreeElements> listChild = new ArrayList<ITreeElements>(list.size());
        Collections.sort(list, new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                return StringUtils.removeAccent((String)o1.getNameCommon()).compareToIgnoreCase(StringUtils.removeAccent((String)o2.getNameCommon()));
            }
        });
        for (XSite site : list) {
            listChild.add(new SiteElement(this, site));
        }
        return listChild;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return this.label;
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/site16_2.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof SubListSiteElement && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

