/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.site2;

import ca.infodata.dsq.domain.ILocation;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.BaseSubEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.proposal.IAddress;
import ca.infodata.ofys.ui.dsq.ChooseLocationDialog;
import ca.infodata.ofys.ui.dsq.DSQPlugin;
import ca.infodata.ofys.ui.dsq.DsqFormatter;
import ca.infodata.ofys.ui.dsq.FindLocationAction;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.address2.AddressControl2;
import ca.infodata.ofys.ui.site2.SiteControl;
import ca.infodata.ofys.ui.site2.SiteMultiEditor;
import ca.infodata.ofys.ui.site2.address.SiteAddressAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseSiteEditor
extends BaseSubEditor {
    private static final Logger logger = Logger.getLogger(BaseSiteEditor.class.getName());
    private FontAwareSection sectionFacility;
    private FontAwareSection sectionAddress;
    private FontAwareSection sectionSRFax;
    protected SiteControl facility;
    protected AddressControl2 address;
    protected MyButton btnResolveSite;
    protected SiteAddressAdapter siteAddressAdapter;
    protected MyMaskedText txtNoTel;
    protected MyMaskedText txtNoTel2;
    protected MyMaskedText txtSRFaxAccount;
    protected MyMaskedText txtSRFaxUser;
    protected MyMaskedText txtSRFaxPswd;
    protected MyMaskedText txtSRFaxNo;
    protected MyMaskedText txtRrssNiu;

    public BaseSiteEditor(SiteMultiEditor parentEditor) {
        super((BaseMultiEditor)parentEditor);
    }

    public void createMyControl(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.sectionFacility = new FontAwareSection(parent, 64, this.toolkit);
        this.sectionFacility.setText(Messages.getString((String)"SITE", (String[])new String[0]));
        this.facility = new SiteControl((Composite)this.sectionFacility, this.toolkit, (IBaseEditor)this.getParentEditor()){

            @Override
            public XSite getSite() {
                return BaseSiteEditor.this.getSite2();
            }
        };
        this.sectionFacility.setClient((Control)this.facility);
        this.toolkit.createCompositeSeparator((Composite)this.sectionFacility);
        this.sectionFacility.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                BaseSiteEditor.this.facility.setFirstFocus();
            }
        });
        MyLabel lblRrssNiu = new MyLabel(parent, Messages.getString((String)"IDENTIFIANT_RRSS", (String[])new String[0]), 0, this.toolkit);
        this.txtRrssNiu = new MyMaskedText(parent, 0, this.toolkit);
        this.txtRrssNiu.setMask(MyMasks.standardText);
        this.txtRrssNiu.setToolTipText(Messages.getString((String)"IDENTIFIANT_RRSS_TTT", (String[])new String[0]));
        this.sectionAddress = new FontAwareSection(parent, 64, this.toolkit);
        this.sectionAddress.setText(Messages.getString((String)"ADRESSE", (String[])new String[0]));
        this.address = new AddressControl2((Composite)this.sectionAddress, this.toolkit, (IBaseEditor)this.getParentEditor()){

            public void createMyControl(Composite parent, FormToolkit toolkit) {
                super.createMyControl(parent, toolkit);
                this.txtNote.setVisible(false);
                this.lblNote.setVisible(false);
            }
        };
        this.siteAddressAdapter = new SiteAddressAdapter(){

            @Override
            public XSite getSite() {
                return BaseSiteEditor.this.getSite2();
            }
        };
        this.address.setAddress((IAddress)this.siteAddressAdapter);
        this.sectionAddress.setClient((Control)this.address);
        this.toolkit.createCompositeSeparator((Composite)this.sectionAddress);
        MyLabel lblNoTel = new MyLabel(parent, Messages.getString((String)"TELEPHONE", (String[])new String[0]), 0, this.toolkit);
        MyLabel lblNoTel2 = new MyLabel(parent, Messages.getString((String)"TELECOPIE", (String[])new String[0]), 0, this.toolkit);
        this.txtNoTel = new MyMaskedText(parent, 0, this.toolkit);
        this.txtNoTel.setValidStyle(10);
        this.txtNoTel.setMask(MyMasks.phoneNumber);
        this.txtNoTel2 = new MyMaskedText(parent, 0, this.toolkit);
        this.txtNoTel2.setValidStyle(10);
        this.txtNoTel2.setMask(MyMasks.phoneNumber);
        this.btnResolveSite = new MyButton(parent, Messages.getString((String)"RECHERCHER_LE_SITE_AU_DSQ", (String[])new String[0]), 8, this.toolkit);
        this.btnResolveSite.setVisible(DSQPlugin.getDefault().isDsqEnabled());
        boolean isDebug = Application.get().getGlobalInstances().inDebugMode();
        this.sectionSRFax = new FontAwareSection(parent, 64, this.toolkit);
        this.sectionSRFax.setText(Messages.getString((String)"FAX_SRFAX", (String[])new String[0]));
        this.toolkit.createCompositeSeparator((Composite)this.sectionSRFax);
        MyLabel lblSRFaxAccount = new MyLabel(parent, Messages.getString((String)"FAX_ACCOUNT", (String[])new String[0]), 0, this.toolkit);
        MyLabel lblSRFaxUser = new MyLabel(parent, Messages.getString((String)"FAX_USER", (String[])new String[0]), 0, this.toolkit);
        MyLabel lblSRFaxPswd = new MyLabel(parent, Messages.getString((String)"FAX_PSWD", (String[])new String[0]), 0, this.toolkit);
        MyLabel lblSRFaxNo = new MyLabel(parent, Messages.getString((String)"FAX_NUMBER", (String[])new String[0]), 0, this.toolkit);
        this.txtSRFaxAccount = new MyMaskedText(parent, 0, this.toolkit);
        this.txtSRFaxUser = new MyMaskedText(parent, 0, this.toolkit);
        this.txtSRFaxPswd = new MyMaskedText(parent, 0x400000, this.toolkit);
        this.txtSRFaxPswd.setMask(new MyMask('!', 20));
        this.txtSRFaxNo = new MyMaskedText(parent, 0, this.toolkit);
        this.txtSRFaxNo.setMask(MyMasks.phoneNumber);
        FontAwareSection bidSection = new FontAwareSection(parent, 64, this.toolkit);
        this.toolkit.createCompositeSeparator((Composite)bidSection);
        this.sectionSRFax.setVisible(isDebug);
        lblSRFaxAccount.setVisible(isDebug);
        lblSRFaxUser.setVisible(isDebug);
        lblSRFaxPswd.setVisible(isDebug);
        lblSRFaxNo.setVisible(isDebug);
        this.txtSRFaxAccount.setVisible(isDebug);
        this.txtSRFaxUser.setVisible(isDebug);
        this.txtSRFaxPswd.setVisible(isDebug);
        this.txtSRFaxNo.setVisible(isDebug);
        bidSection.setVisible(isDebug);
        this.txtNoTel.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseSiteEditor.this.getSite2().setPhonenumber1(BaseSiteEditor.this.txtNoTel.getText());
            }
        });
        this.txtNoTel2.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseSiteEditor.this.getSite2().setPhonenumber2(BaseSiteEditor.this.txtNoTel2.getText());
            }
        });
        this.txtSRFaxAccount.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseSiteEditor.this.getSite2().setFaxAccount(BaseSiteEditor.this.txtSRFaxAccount.getText());
            }
        });
        this.txtSRFaxUser.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseSiteEditor.this.getSite2().setFaxUser(BaseSiteEditor.this.txtSRFaxUser.getText());
            }
        });
        this.txtSRFaxPswd.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseSiteEditor.this.getSite2().setFaxPasswd(BaseSiteEditor.this.txtSRFaxPswd.getText());
            }
        });
        this.txtSRFaxNo.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseSiteEditor.this.getSite2().setFaxNumber(BaseSiteEditor.this.txtSRFaxNo.getText());
            }
        });
        this.txtRrssNiu.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseSiteEditor.this.getSite2().setRrssNiu(BaseSiteEditor.this.txtRrssNiu.getText());
            }
        });
        this.btnResolveSite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final XSite site = BaseSiteEditor.this.getSite2();
                if (site != null) {
                    final ArrayList locations = new ArrayList();
                    MyProgressMonitorDialog dialog2 = new MyProgressMonitorDialog(BaseSiteEditor.this.getSite().getShell());
                    dialog2.setInterruptOnCancel(true);
                    try {
                        dialog2.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    List list = new FindLocationAction().find(site, monitor);
                                    if (list != null) {
                                        locations.addAll(list);
                                    }
                                }
                                catch (Exception e) {
                                    MessageUtil.show((Shell)BaseSiteEditor.this.getSite().getShell(), (Exception)e);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        logger.log(Level.SEVERE, "Error", e1);
                        MessageUtil.unexpectedExceptionMsg((Shell)BaseSiteEditor.this.getSite().getShell());
                    }
                    catch (InterruptedException interruptedException) {}
                    ILocation location = null;
                    if (locations.size() == 1) {
                        location = (ILocation)locations.get(0);
                        MessageUtil.infoMsg((Shell)BaseSiteEditor.this.getSite().getShell(), (String)("La recherche \u00e0 retourn\u00e9 un seul r\u00e9sultat \n " + DsqFormatter.formatLocation((ILocation)location)));
                    } else if (locations.size() > 0) {
                        ChooseLocationDialog dialog = new ChooseLocationDialog(BaseSiteEditor.this.getSite().getShell(), locations);
                        dialog.open();
                        if (dialog.isOk() && dialog.getSelection() != null) {
                            location = dialog.getSelection();
                        }
                    }
                    if (location != null) {
                        site.setDsqNiu(location.getNIU().value());
                        site.setCode(location.getCode());
                        site.setNameOfficial(location.getName());
                        site.setNameCommon(location.getName());
                        site.setPhonenumber1(location.getAddress().telecom);
                        site.setCity(new XCity(location.getAddress().city));
                        site.setCountry(new XCountry(location.getAddress().country));
                        site.setProvince(new XProvince(location.getAddress().state));
                        site.setPostalCode(location.getAddress().postalCode);
                        site.setStreet(location.getAddress().street);
                        site.setUpdated();
                        BaseSiteEditor.this.checkDirty();
                        BaseSiteEditor.this.showAllDataObject();
                    }
                }
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.sectionFacility.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionFacility);
        data.left = new FormAttachment(0, 5);
        lblRrssNiu.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionFacility);
        data.left = new FormAttachment(lblRrssNiu.getControl(), 5);
        data.width = UI.STANDARD_TEXT_WIDTH;
        this.txtRrssNiu.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblRrssNiu.getControl(), 10);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.sectionAddress.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionAddress);
        data.left = new FormAttachment(0, 5);
        lblNoTel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblNoTel.getControl(), 0);
        data.left = new FormAttachment(lblNoTel.getControl(), 0, 16384);
        data.width = UI.STANDARD_TEXT_WIDTH;
        this.txtNoTel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionAddress);
        data.left = new FormAttachment(this.txtNoTel.getControl());
        lblNoTel2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblNoTel2.getControl());
        data.left = new FormAttachment(lblNoTel2.getControl(), 0, 16384);
        data.width = UI.STANDARD_TEXT_WIDTH;
        this.txtNoTel2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNoTel2.getControl(), 0);
        data.left = new FormAttachment(0, 0);
        this.btnResolveSite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnResolveSite.getControl(), 5);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.sectionSRFax.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionSRFax);
        data.left = new FormAttachment(0);
        lblSRFaxAccount.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblSRFaxUser.getControl());
        data.left = new FormAttachment(0);
        data.width = UI.STANDARD_TEXT_WIDTH;
        this.txtSRFaxAccount.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionSRFax);
        data.left = new FormAttachment(this.txtSRFaxAccount.getControl(), 5);
        lblSRFaxUser.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblSRFaxUser.getControl());
        data.left = new FormAttachment(this.txtSRFaxAccount.getControl(), 5);
        data.width = UI.STANDARD_TEXT_WIDTH * 2;
        this.txtSRFaxUser.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionSRFax);
        data.left = new FormAttachment(this.txtSRFaxUser.getControl(), 5);
        lblSRFaxPswd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblSRFaxPswd.getControl());
        data.left = new FormAttachment(this.txtSRFaxUser.getControl(), 5);
        data.width = UI.STANDARD_TEXT_WIDTH;
        this.txtSRFaxPswd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionSRFax);
        data.left = new FormAttachment(this.txtSRFaxPswd.getControl(), 5);
        lblSRFaxNo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblSRFaxNo.getControl());
        data.left = new FormAttachment(this.txtSRFaxPswd.getControl(), 5);
        data.width = UI.STANDARD_TEXT_WIDTH;
        this.txtSRFaxNo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtSRFaxUser.getControl(), 5);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        bidSection.setLayoutData((Object)data);
    }

    public boolean isInputReadonly() {
        return ((EditorInput)this.getEditorInput()).isReadonly();
    }

    public XSite getSite2() {
        return (XSite)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }
}

