/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.singleview;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.VIEW_MODE;
import ca.infodata.dsq.domain.labo.getreport.LaboReport;
import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportPdf;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.scan.dsq.GetLaboReportController;
import ca.infodata.ofys.ui.scan.dsq.GetLaboReportControllerCallback;
import ca.infodata.ofys.ui.scan.dsq.LaboReportHeaderImageElement;
import ca.infodata.ofys.ui.scan.singleview.BaseScanSingleViewEditor;
import ca.infodata.ofys.ui.scan.singleview.IScanSingleViewEditorSection;
import ca.infodata.ofys.ui.scan.singleview.InfoSection;
import ca.infodata.ofys.ui.scan.singleview.NoteSection;
import ca.infodata.ofys.ui.scan.singleview.ScanSingleViewEditor;
import ca.infodata.util1.MutableBoolean;
import ca.infodata.util1.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaboAndScanSingleViewEditor
extends ScanSingleViewEditor
implements GetLaboReportControllerCallback {
    private static final Logger logger = Logger.getLogger(LaboAndScanSingleViewEditor.class.getName());
    private GetLaboReportController laboController = new GetLaboReportController(this, new BaseDSQAction(), new FindCandidateAction());
    private boolean isDsqLabo;

    protected void setInput(IEditorInput input) {
        this.isDsqLabo = false;
        super.setInput(input);
    }

    @Override
    public void initDataOverride() {
        EditorInput input = (EditorInput)this.getEditorInput();
        IDataObject dataObject = input.getDataObject();
        if (dataObject instanceof XBasePatientImage) {
            XBasePatientImage x = (XBasePatientImage)this.getDataObject();
            this.isDsqLabo = x.valDsq != null;
        }
        this.setPartName(this.getEditorTitle());
        super.initDataOverride();
    }

    @Override
    public void initializeCompleteDataObject(EditableDataObject completeDataObject) {
        if (completeDataObject instanceof XPatientImage) {
            XPatientImage x = (XPatientImage)completeDataObject;
            this.isDsqLabo = x.valDsq != null;
            this.addPrintedByText = !this.isDsqLabo;
        }
        super.initializeCompleteDataObject(completeDataObject);
    }

    @Override
    protected List<IScanSingleViewEditorSection> createSections(BaseScanSingleViewEditor editor, Composite parent, FormToolkit toolkit) {
        ArrayList<IScanSingleViewEditorSection> list = new ArrayList<IScanSingleViewEditorSection>();
        list.add(new NoteSection(editor, parent, toolkit));
        list.add(new InfoSection(editor, parent, toolkit){

            @Override
            public void showDataObject() {
                super.showDataObject();
                XPatientImage x = this.getPatientImage();
                LaboAndScanSingleViewEditor.this.isDsqLabo = x.valDsq != null;
                if (LaboAndScanSingleViewEditor.this.isDsqLabo) {
                    this.txtDocumentDate.setEnabled(false);
                    this.txtName.setEditable(false);
                    this.txtPatient.setEnabled(false);
                }
            }
        });
        return list;
    }

    public static XPatientImage baseToXPatientImage(XBasePatientImage xbase, IPatient patient) {
        XPatientImage ximage = new XPatientImage();
        ximage.setId(null);
        ximage.patient = patient;
        ximage.idPatient = xbase.idPatient;
        ximage.name = "Document";
        ximage.picture = null;
        ximage.labels = new ArrayList();
        ximage.result = xbase.result;
        ximage.datetimeScanned = xbase.dateScanned;
        ximage.documentDate = xbase.documentDate;
        ximage.notesHistory = "";
        ximage.idUserAnchor = null;
        ximage.userName = null;
        ximage.valDsq = xbase.valDsq;
        ximage.dsqImagingResultExam = xbase.dsqImagingResultExam;
        ximage.result = XPatientImageResultType.SO;
        ximage.setProfessionnals((IEditableDataObjectList)new EditableDataObjectList());
        XPatientImageProfessionnal e = new XPatientImageProfessionnal();
        e.professionnal = PersonUiPlugin.getDefault().getSessionProfessionnal().getId();
        ximage.getProfessionnals().add((IMinimalEditableDataObject)e);
        return ximage;
    }

    @Override
    protected void loadFromId(IDataObject dataObject) {
        if (dataObject instanceof XBasePatientImage && dataObject.getId() == null) {
            XBasePatientImage xbase = (XBasePatientImage)dataObject;
            XPatient patient = PatientUtil.getXPatient((Object)xbase.idPatient);
            if (xbase.valDsq != null) {
                this.laboController.setXImage((IPatient)patient, LaboAndScanSingleViewEditor.baseToXPatientImage(xbase, (IPatient)patient));
                this.laboController.get(null);
            }
        } else if (dataObject instanceof IDDataObject) {
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    XPatientImage x;
                    final MutableBoolean isDisposed = new MutableBoolean(true);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            isDisposed.setValue(LaboAndScanSingleViewEditor.this.isDisposed());
                        }
                    });
                    if (!isDisposed.booleanValue() && (x = (XPatientImage)response.getObj()).getDsqImagingResultExam() == null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LaboAndScanSingleViewEditor.this.initializeCompleteDataObject((EditableDataObject)x);
                            }
                        });
                    }
                }
            };
            super.loadFromId(dataObject, (ICallback)callback);
        } else {
            super.loadFromId(dataObject);
        }
    }

    @Override
    public void getLabo(final DsqCallback<LaboReport> dsqCallback, String hostAddr) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (dsqCallback.exception != null) {
                    MessageUtil.show((Shell)LaboAndScanSingleViewEditor.this.getShell(), (Exception)dsqCallback.exception);
                }
                if (StringUtils.isNotBlank((String)dsqCallback.message)) {
                    MessageUtil.warningMsg((Shell)LaboAndScanSingleViewEditor.this.getShell(), (String)dsqCallback.message);
                }
                LaboReport report = (LaboReport)dsqCallback.result;
                XPatientImage ximage = LaboAndScanSingleViewEditor.this.laboController.getPatientImage();
                Candidate candidate = LaboAndScanSingleViewEditor.this.laboController.getCandidate();
                LaboReportPdf laboReportPdf = new LaboReportPdf(candidate, report, ximage.valDsq);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    laboReportPdf.setViewMode(VIEW_MODE.VIEW);
                    laboReportPdf.getPicture((OutputStream)bos);
                    ximage.picture = bos.toByteArray();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to generate view pdf for dsq labo header. ximage.id " + ximage.getId(), e);
                }
                bos.reset();
                try {
                    laboReportPdf.setViewMode(VIEW_MODE.PRINT);
                    laboReportPdf.getPicture((OutputStream)bos);
                    ximage.pictureToPrint = bos.toByteArray();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to generate print pdf for dsq labo header. ximage.id " + ximage.getId(), e);
                }
                ximage.name = report.title;
                LaboAndScanSingleViewEditor.this.initializeCompleteDataObject((EditableDataObject)ximage);
            }
        });
    }

    @Override
    public void print() {
        if (this.isDsqLabo) {
            XPatientImage image = this.getPatientImage();
            if (image != null) {
                PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), (Serializable)this.getDataObject());
                UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
                dialog.open();
            }
        } else {
            super.print();
        }
    }

    @Override
    public String getEditorTitle() {
        XBasePatientImage basePatientImage;
        XPatientImage patientImage = this.getPatientImage();
        if (patientImage != null && patientImage.getValDsq() != null) {
            return LaboReportHeaderImageElement.formatDsqPatientImage(null, patientImage.getValDsq());
        }
        EditorInput input = (EditorInput)this.getEditorInput();
        IDataObject dataObject = input.getDataObject();
        if (dataObject instanceof IDDataObject) {
            return ((IDDataObject)dataObject).getDisplayText();
        }
        if (dataObject instanceof XBasePatientImage && (basePatientImage = (XBasePatientImage)this.getDataObject()) != null && basePatientImage.valDsq != null) {
            return LaboReportHeaderImageElement.formatDsqPatientImage(null, basePatientImage.valDsq);
        }
        return super.getEditorTitle();
    }

    @Override
    protected boolean getAllowPrintingFromPdfViewer() {
        return !this.isDsqLabo;
    }
}

