/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq.imaging;

import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.MySubProgressMonitor;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.scan.dsq.imaging.ListImagingExamControllerCallback;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ListImagingExamController {
    private static final String OBTENTION_DE_LA_LISTE = "Obtention de la liste des rapports d'examen d'imagerie m\u00e9dicale";
    private static final Logger logger = Logger.getLogger(ListImagingExamController.class.getName());
    private final ListImagingExamControllerCallback callback;
    private IPatient patient;
    private LocalDate start = null;
    private LocalDate end = null;
    private int limit = 250;
    private QueryContinuationResult result;
    private Job list;
    private FindCandidateAction findCandidateAction;
    private BaseDSQAction dsq;

    public ListImagingExamController(ListImagingExamControllerCallback callback, BaseDSQAction dsq, FindCandidateAction findCandidateAction) {
        if (dsq == null) {
            throw new NullPointerException("dsq");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.dsq = dsq;
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
    }

    public void list() {
        if (this.list == null) {
            this.list = new Job(OBTENTION_DE_LA_LISTE){

                protected IStatus run(IProgressMonitor monitor) {
                    ListImagingExamController.this.list2(monitor);
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.list.getState() == 4) {
            this.callback.list((DsqCallback<QueryContinuationResult>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.list.schedule();
        }
    }

    public void list2(IProgressMonitor monitor) {
        if (this.result == null) {
            DsqCallback<QueryContinuationResult> r = this.list3(monitor);
            if (r.result != null) {
                this.result = (QueryContinuationResult)r.result;
            }
            this.callback.list(r);
        } else {
            this.callback.list((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)this.result));
        }
    }

    public DsqCallback<QueryContinuationResult> list3(IProgressMonitor monitor) {
        DsqCallback callback = new DsqCallback();
        try {
            if (this.end != null && this.start != null && this.end.before((IPartialDate)this.start)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.patient == null) {
                callback.message = "Veuillez sp\u00e9cifier un client";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            try {
                if (monitor != null) {
                    monitor.beginTask(OBTENTION_DE_LA_LISTE, 2);
                }
                XmlSignatureI signature = null;
                XmlSignatureI signatureNiu = null;
                if (!this.dsq.hasSignatures(this.patient.getId())) {
                    if (!UI.OS_WINDOWS) {
                        throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                    }
                    this.dsq.checkIfActionWasCanceled(monitor);
                    Alias alias = this.dsq.getAlias(monitor);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    String niu = this.findCandidateAction.getNiu(this.patient, (IProgressMonitorWithLog)(monitor == null ? null : new MySubProgressMonitor(monitor, 1)));
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signature = this.dsq.getSignatureI(monitor, alias, null);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, null, niu);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    this.dsq.checkIfActionWasCanceled(monitor);
                }
                if (monitor != null) {
                    monitor.subTask("Recherche");
                }
                XSession session = Application.get().getGlobalInstances().getSession();
                LocalDate start2 = this.start;
                LocalDate end2 = this.end;
                int limit2 = this.limit;
                ReturnObject r = DSQAccessorClient.getInstance().listImagingExam(session, this.patient.getId().intValue(), start2, end2, Integer.valueOf(limit2), signature, signatureNiu, null, null);
                if (r == null) {
                    throw new AbortException("Erreur lors de l'" + OBTENTION_DE_LA_LISTE.toLowerCase());
                }
                this.dsq.manageDsqStatus(r.getStatus());
                callback.result = (QueryContinuationResult)r.getObj();
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                callback.message = MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (AbortException | StatusException e) {
                callback.message = e.getMessage();
            }
            catch (CancelException cancelException) {
            }
            catch (Exception e) {
                callback.exception = e;
                callback.message = e.getMessage();
                logger.log(Level.SEVERE, String.format("Failed to list imaging %s, %s, %s, %s", StringUtils.safeToString((Logger)logger, (Object)this.patient), this.start, this.end, this.limit), e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void setPatient(IPatient patient) {
        this.clear();
        this.patient = patient;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void clear() {
        this.result = null;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.clear();
        this.start = start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.clear();
        this.end = end;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.clear();
        this.limit = limit;
    }
}

