/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq.imaging;

import ca.infodata.dsq.domain.imaging.ImagingResultExam;
import ca.infodata.dsq.domain.imaging.ImagingResultExamReport;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.form.MyTable2;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.scan.dsq.imaging.GetImagingResultExamReportController;
import ca.infodata.ofys.ui.scan.singleview.BaseScanSingleViewSection;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.date.DateUtil;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImagingResultExamReportSection
extends BaseScanSingleViewSection {
    private FormToolkit toolkit;
    private BaseEditor editor;
    private Section section;
    private MyTable2<ImagingResultExamReport> table;
    private GetImagingResultExamReportController imagingController;

    public ImagingResultExamReportSection(final BaseEditor editor, Composite parent, FormToolkit toolkit, final GetImagingResultExamReportController imagingController) {
        this.editor = editor;
        this.toolkit = toolkit;
        this.imagingController = imagingController;
        this.section = this.toolkit.createSection(parent, 2);
        this.section.setText("Rapports disponibles");
        this.toolkit.createCompositeSeparator((Composite)this.section);
        Composite composite = this.toolkit.createComposite((Composite)this.section, 0);
        composite.setLayout((Layout)new FormLayout());
        this.section.setClient((Control)composite);
        this.table = new MyTable2(composite, 67588, toolkit);
        this.table.setHeaderVisible(true);
        this.table.addColumns("Date/Heure", "Date/Heure", 150);
        this.table.addColumns("Statut", "Statut", 500);
        this.table.setLabelProvider((ProviderAR)new ProviderAR<ImagingResultExamReport, String[]>(){

            public String[] get(ImagingResultExamReport e) {
                String code = e.code.code.equalsIgnoreCase("F") ? "Final" : (e.code.code.equalsIgnoreCase("M") ? "Modifi\u00e9" : (e.code.code.equalsIgnoreCase("P") ? "Pr\u00e9liminaire" : e.code.code));
                return new String[]{DateUtil.nonThreadSafeFormat((Long)e.effectiveTime, (String)"yyyy-MM-dd HH:mm:ss"), code};
            }
        });
        this.table.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.editor){

            public void edited(Event e) {
                imagingController.setReportIndex(ImagingResultExamReportSection.this.table.getSelectionIndex());
                editor.doRefresh();
            }
        });
        this.table.setLayoutData((Object)UI.newFillFormData());
    }

    @Override
    public Control getControl() {
        return this.section;
    }

    @Override
    public void showDataObject() {
        XPatientImage patientImage = this.getPatientImage();
        if (patientImage == null) {
            this.table.removeAll();
            this.table.setEnabled(false);
        } else {
            this.table.setEnabled(true);
            ImagingResultExam dsqImagingResultExam = patientImage.getDsqImagingResultExam();
            if (dsqImagingResultExam != null) {
                Collections.sort(patientImage.getDsqImagingResultExam().report, Collections.reverseOrder());
                this.table.setItems((Collection)patientImage.getDsqImagingResultExam().report);
            }
            UI.autoAdjustColumnWidthToContent((Table)this.table.getControl());
            int index = this.imagingController.getReportIndex() == null ? 0 : this.imagingController.getReportIndex();
            this.table.setSelection(index);
        }
    }
}

