/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq.imaging;

import ca.infodata.dsq.domain.labo.getreport.LaboReport;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedDocument;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.dsq.imaging.XImagingResultExamResponse;
import ca.infodata.ofys.data.middle.dataobjects.dsq.imaging.XImagingResultExamWrapper;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.scan.dsq.GetLaboReportControllerCallback;
import ca.infodata.ofys.ui.scan.dsq.LaboReportHeaderImageElement;
import ca.infodata.ofys.ui.scan.dsq.imaging.GetImagingResultExamReportController;
import ca.infodata.ofys.ui.scan.dsq.imaging.GetImagingResultExamReportControllerCallback;
import ca.infodata.ofys.ui.scan.dsq.imaging.ImagingResultExamElement;
import ca.infodata.ofys.ui.scan.dsq.imaging.ImagingResultExamReportSection;
import ca.infodata.ofys.ui.scan.singleview.BaseScanSingleViewEditor;
import ca.infodata.ofys.ui.scan.singleview.IScanSingleViewEditorSection;
import ca.infodata.ofys.ui.scan.singleview.ScanSingleViewEditor;
import ca.infodata.util1.MutableBoolean;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImagingExamEditor
extends ScanSingleViewEditor
implements GetLaboReportControllerCallback,
GetImagingResultExamReportControllerCallback {
    private static final Logger logger = Logger.getLogger(ImagingExamEditor.class.getName());
    private GetImagingResultExamReportController imagingController = new GetImagingResultExamReportController(this, new BaseDSQAction(), new FindCandidateAction());
    private boolean isDsqImaging;
    private ImagingResultExamReportSection imagingSection;

    protected void setInput(IEditorInput input) {
        this.isDsqImaging = false;
        this.imagingController.setReportIndex(null);
        super.setInput(input);
    }

    @Override
    public void initDataOverride() {
        EditorInput input = (EditorInput)this.getEditorInput();
        IDataObject dataObject = input.getDataObject();
        if (dataObject instanceof XBasePatientImage) {
            XBasePatientImage x = (XBasePatientImage)this.getDataObject();
            this.isDsqImaging = x.dsqImagingResultExam != null;
        }
        this.setPartName(this.getEditorTitle());
        super.initDataOverride();
    }

    @Override
    public void initializeCompleteDataObject(EditableDataObject completeDataObject) {
        if (completeDataObject instanceof XPatientImage) {
            XPatientImage x = (XPatientImage)completeDataObject;
            this.isDsqImaging = x.dsqImagingResultExam != null;
            this.addPrintedByText = !this.isDsqImaging;
        }
        super.initializeCompleteDataObject(completeDataObject);
    }

    @Override
    protected List<IScanSingleViewEditorSection> createSections(BaseScanSingleViewEditor editor, Composite parent, FormToolkit toolkit) {
        ArrayList<IScanSingleViewEditorSection> list = new ArrayList<IScanSingleViewEditorSection>();
        this.imagingSection = new ImagingResultExamReportSection((ImagingExamEditor)editor, parent, toolkit, this.imagingController);
        list.add(this.imagingSection);
        return list;
    }

    public static XPatientImage baseToXPatientImage(XBasePatientImage xbase, IPatient patient) {
        XPatientImage ximage = new XPatientImage();
        ximage.setId(null);
        ximage.patient = patient;
        ximage.idPatient = xbase.idPatient;
        ximage.name = "Document";
        ximage.picture = null;
        ximage.labels = new ArrayList();
        ximage.result = xbase.result;
        ximage.datetimeScanned = xbase.dateScanned;
        ximage.documentDate = xbase.documentDate;
        ximage.notesHistory = "";
        ximage.idUserAnchor = null;
        ximage.userName = null;
        ximage.valDsq = xbase.valDsq;
        ximage.dsqImagingResultExam = xbase.dsqImagingResultExam;
        ximage.result = XPatientImageResultType.SO;
        ximage.setProfessionnals((IEditableDataObjectList)new EditableDataObjectList());
        XPatientImageProfessionnal e = new XPatientImageProfessionnal();
        e.professionnal = PersonUiPlugin.getDefault().getSessionProfessionnal().getId();
        ximage.getProfessionnals().add((IMinimalEditableDataObject)e);
        return ximage;
    }

    @Override
    protected void loadFromId(IDataObject dataObject) {
        if (dataObject instanceof XBasePatientImage && dataObject.getId() == null) {
            XBasePatientImage xbase = (XBasePatientImage)dataObject;
            XPatient patient = xbase.patient == null ? PatientUtil.getXPatient((Object)xbase.idPatient) : xbase.patient;
            XPatientImage ximage = ImagingExamEditor.baseToXPatientImage(xbase, (IPatient)patient);
            if (xbase.dsqImagingResultExam != null) {
                this.imagingController.setXImage((IPatient)patient, ximage);
                this.imagingController.get(null);
            }
        } else if (dataObject instanceof IDDataObject) {
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    final MutableBoolean isDisposed = new MutableBoolean(true);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            isDisposed.setValue(ImagingExamEditor.this.isDisposed());
                        }
                    });
                    if (!isDisposed.booleanValue()) {
                        final XPatientImage x = (XPatientImage)response.getObj();
                        if (x.getDsqImagingResultExam() == null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ImagingExamEditor.this.initializeCompleteDataObject((EditableDataObject)x);
                                }
                            });
                        } else {
                            ImagingExamEditor.this.imagingController.setXImage(x.getPatient(), x);
                            ImagingExamEditor.this.imagingController.get2((IProgressMonitor)new NullProgressMonitor(), null);
                        }
                    }
                }
            };
            super.loadFromId(dataObject, (ICallback)callback);
        } else {
            super.loadFromId(dataObject);
        }
    }

    @Override
    public void getLabo(DsqCallback<LaboReport> dsqCallback, String hostAddr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToolBarStatus() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isPrintAllowed() {
        XPatientImage image = this.getPatientImage();
        return image != null && image.dsqImagingResultExam != null;
    }

    @Override
    public void print() {
        XPatientImage image = this.getPatientImage();
        if (image != null) {
            PrintController printController = ImagingExamEditor.getImagingReportPrintController(image, this.imagingController.getReportIndex());
            PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), printController);
            UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
            dialog.open();
        }
    }

    public static PrintController getImagingReportPrintController(XPatientImage image, int reportIndex) {
        XImagingResultExamWrapper wrapper = new XImagingResultExamWrapper();
        wrapper.idPatient = image.idPatient;
        wrapper.imagingResultExam = image.dsqImagingResultExam;
        wrapper.reportIndex = reportIndex;
        wrapper.viewMode = false;
        return new PrintController((Serializable)wrapper, null);
    }

    @Override
    public String getEditorTitle() {
        EditorInput input;
        IDataObject dataObject;
        XPatientImage patientImage = this.getPatientImage();
        if (patientImage != null) {
            if (patientImage.getValDsq() != null) {
                return LaboReportHeaderImageElement.formatDsqPatientImage(null, patientImage.getValDsq());
            }
            if (patientImage.getDsqImagingResultExam() != null) {
                return ImagingResultExamElement.formatDsqPatientImage(null, patientImage.getDsqImagingResultExam());
            }
        }
        if ((dataObject = (input = (EditorInput)this.getEditorInput()).getDataObject()) instanceof IDDataObject) {
            return ((IDDataObject)dataObject).getDisplayText();
        }
        if (dataObject instanceof XBasePatientImage) {
            XBasePatientImage basePatientImage = (XBasePatientImage)this.getDataObject();
            if (basePatientImage != null && basePatientImage.valDsq != null) {
                return ImagingResultExamElement.formatDsqPatientImage(null, basePatientImage.getDsqImagingResultExam());
            }
            if (basePatientImage != null && basePatientImage.dsqImagingResultExam != null) {
                return ImagingResultExamElement.formatDsqPatientImage(null, basePatientImage.getDsqImagingResultExam());
            }
        }
        return super.getEditorTitle();
    }

    @Override
    protected boolean getAllowPrintingFromPdfViewer() {
        return !this.isDsqImaging;
    }

    @Override
    public void getImaging(final DsqCallback<XImagingResultExamResponse> dsqCallback, final int reportIndex, String hostAddr) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (dsqCallback.exception != null) {
                    MessageUtil.show((Shell)ImagingExamEditor.this.getShell(), (Exception)dsqCallback.exception);
                }
                if (StringUtils.isNotBlank((String)dsqCallback.message)) {
                    MessageUtil.warningMsg((Shell)ImagingExamEditor.this.getShell(), (String)dsqCallback.message);
                }
                XImagingResultExamResponse response = (XImagingResultExamResponse)dsqCallback.result;
                XPatientImage ximage = ImagingExamEditor.this.imagingController.getPatientImage();
                if (response != null) {
                    try {
                        ximage.name = response.imagingResultExam.code.text;
                        ximage.dsqImagingResultExam = ((XImagingResultExamResponse)dsqCallback.result).imagingResultExam;
                        ximage.picture = ((XFinishedDocument)response.viewReport.getDocuments().get((int)reportIndex)).data;
                        ximage.pictureToPrint = ((XFinishedDocument)response.viewReport.getDocuments().get((int)0)).data;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to generate print pdf for dsq imaging result exam header. ximage.id " + ximage.getId(), e);
                    }
                }
                ImagingExamEditor.this.initializeCompleteDataObject((EditableDataObject)ximage);
            }
        });
    }
}

