/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.cellediting;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XSecteur;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SecteurCombo
extends MyCombo<XSecteur> {
    private static final Logger logger = Logger.getLogger(SecteurCombo.class.getName());
    private static final List<SecteurCombo> instances = new CopyOnWriteArrayList<SecteurCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<SecteurCombo> toRemoveList = new ArrayList<SecteurCombo>();
                for (SecteurCombo combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill();
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;
    private boolean cnull;
    private XSecteur snull;

    static {
        CompletionComboAccessorClient.addListener((String)XSecteur.type, (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public SecteurCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.cnull = (style | 0x10000) == style;
        this.setAutoComplete(false);
        this.setLabelProvider((ProviderAR)new ProviderAR<XSecteur, String>(){

            public String get(XSecteur c) {
                boolean showId;
                String text = c == null || c.getText() == null ? "" : c.getText();
                boolean bl = showId = Platform.inDebugMode() || Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.INFODATA});
                if (showId && c != null) {
                    text = c.getId() + " " + text;
                }
                return text;
            }
        });
        this.setDisplayPredicate((PredicateA)new PredicateA<XSecteur>(){

            public boolean evaluate(XSecteur c) {
                return c != null && c.isActive();
            }
        });
        this.setTextLimit(100);
        this.fill();
        instances.add(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove((Object)SecteurCombo.this);
            }
        });
    }

    protected void fill() {
        block5: {
            if (Application.get().getGlobalInstances().getSession() == null) {
                this.fill(new ArrayList<XSecteur>(1));
                return;
            }
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SecteurCombo.this.getControl().isDisposed()) {
                                SecteurCombo.this.fill((List)response.getObj());
                            }
                        }
                    });
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(Application.get().getGlobalInstances().getSession(), (ICallback)callback, XSecteur.type);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to fill SiteCombo", e);
                if (callback == null || callback.killed()) break block5;
                callback.kill();
            }
        }
    }

    private void fill(List<XSecteur> sites) {
        String text = this.getText();
        XSecteur selection = this.getSelection();
        this.removeAllNoNotify();
        this.snull = null;
        if (this.cnull) {
            this.snull = new XSecteur();
            this.snull.initialize();
            sites.add(0, this.snull);
        }
        this.setItems(sites);
        if (selection != null) {
            this.selectNoNotify(selection);
        } else {
            this.setTextNoNotify(text);
        }
    }

    public void select(XSecteur item) {
        if (this.contains(item)) {
            super.select((Object)item);
        } else {
            this.add(item);
            super.select((Object)item);
        }
    }

    public XSecteur getSelection() {
        XSecteur selection = (XSecteur)super.getSelection();
        if (selection == null || selection.getId() == null || selection.getId() == -1) {
            return null;
        }
        return selection;
    }
}

