/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientListText;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.BooleanFilterCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.DataObjectListAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnPreferenceLoader;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchControlAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.IPatientList;
import ca.infodata.ofys.ui.person.IPatientReport;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteComboASearchAdapter;
import ca.infodata.ofys.ui.person.simple.ISimplePatientControl;
import ca.infodata.ofys.ui.person.simple.PatientController;
import ca.infodata.ofys.ui.site.ContextSiteProvider;
import ca.infodata.ofys.ui.site.SiteCombo;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.ui.site.WorkSiteCombo;
import ca.infodata.util1.ClosureA;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatientSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(PatientSearchComposite.class.getName());
    public static final String PREFERENCES_COLUMN_KEY = "PatientSearchComposite.columns_preferences";
    private static final String NOMPRENOMNO_DE_DOSSIER = Messages.getString((String)"NOMPRENOMNO_DE_DOSSIER", (String[])new String[0]);
    private static final String STAY_HERE = Messages.getString((String)"PatientSearchView.STAY_HERE", (String[])new String[0]);
    private static final String KEEP_CURSOR_HERE = Messages.getString((String)"PatientSearchView.KEEP_CURSOR_HERE", (String[])new String[0]);
    private static final String MIN_4LETTTERS_2LETTERS = Messages.getString((String)"SearchPtMin4lettersMin2", (String[])new String[0]);
    protected MyLabel lblNameDossier;
    protected MyMaskedText txtNameDossier;
    private MyButton btnRdvsToMove;
    protected MyLabel lblTelephone;
    protected MyMaskedText txtTelephone;
    protected MyLabel lblDate;
    protected MyMaskedText txtDate;
    protected MyLabel lblNote;
    protected MyMaskedText txtNote;
    protected FontAwareSection secPlus;
    private MyButton btnKeepFocus;
    private MyButton btnInMyPatient;
    private MyButton btnInIntervenant;
    private MyDialogSettings patientSearchInfo;
    private MyButton btnFilterBySite;
    private MyLabel lblProfessionnal;
    private ProfessionalBySiteCombo cmbProfessionnal;
    private MyLabel lblDispensateur;
    private ProfessionalBySiteCombo cmbDispensateur;
    protected MyLabel lblSite;
    private SiteCombo siteCombo;
    private ContextSiteProvider contextSiteProvider;
    private SearchColumnChoiceElement[] columnChoice;
    private ArrayList<SearchColumnChoiceElement> sccesToInactive;
    protected BooleanFilterCombo cmbDeleted;
    private boolean simpleSearchMode;
    private IPropertyListener contextSiteListener;

    public PatientSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style, true);
    }

    public PatientSearchComposite(Composite parent, int style) {
        super(parent, style, true);
    }

    public PatientSearchComposite(Composite parent, FormToolkit toolkit, int style, boolean applySoundHelper) {
        super(parent, toolkit, style, applySoundHelper);
    }

    public PatientSearchComposite(Composite parent, int style, boolean applySoundHelper) {
        super(parent, style, applySoundHelper);
    }

    public void setFocus() {
        this.setVisible(true);
        this.txtNameDossier.setFocus();
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = true;
        this.setUiAutoColumnAdjust(false);
        this.templateType = XCompletionProposalType.PATIENT_SEARCH;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        boolean visible;
        if (this.patientSearchInfo == null) {
            this.patientSearchInfo = new MyDialogSettings(".patientSearch.xml", "patientSearch");
        }
        this.setViewSelectInactive();
        this.setIsWithButtonNew(true);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.secPlus = new FontAwareSection(parent, 2050, toolkit);
        toolkit.createCompositeSeparator((Composite)this.secPlus);
        this.secPlus.setText(Messages.getString((String)"RAFFINER", (String[])new String[0]));
        Composite compPlus = toolkit.createComposite((Composite)this.secPlus);
        compPlus.setLayout((Layout)new FormLayout());
        this.secPlus.setClient((Control)compPlus);
        boolean isProf = PersonUiPlugin.getDefault().getSessionProfessionnal() != null && (XProfessionnalType.MD_OMNIPRATICIEN.equals((Object)PersonUiPlugin.getDefault().getSessionProfessionnal().professionalType) || XProfessionnalType.MD_SPECIALISTE.equals((Object)PersonUiPlugin.getDefault().getSessionProfessionnal().professionalType));
        this.lblNameDossier = new MyLabel(parent, NOMPRENOMNO_DE_DOSSIER, 0, toolkit);
        this.lblNameDossier.setToolTipText(NOMPRENOMNO_DE_DOSSIER);
        this.txtNameDossier = new MyMaskedText(parent, 0, toolkit);
        this.txtNameDossier.setMask(MyMasks.standardText);
        this.txtNameDossier.setMessage(NOMPRENOMNO_DE_DOSSIER);
        this.txtNameDossier.addKeyListener(this.enterCtrlEnterListener);
        this.txtNameDossier.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.addSearchControl("txtNameDossier", (IControl)this.txtNameDossier);
        ControlDecorator.decorateWithHelp((Control)this.txtNameDossier.getControl(), (String)Messages.getString((String)"AIDE_RECHERCHE_PATIENT", (String[])new String[0]));
        this.btnKeepFocus = new MyButton(parent, STAY_HERE, 32, toolkit);
        this.btnKeepFocus.setToolTipText(KEEP_CURSOR_HERE);
        this.btnFilterBySite = new MyButton(parent, Messages.getString((String)"FILTER_LES_PATIENTS_PAR_SITE", (String[])new String[0]), 32, toolkit);
        if (this.moreThanOneSite()) {
            final IDialogSettings3 settings = ControlsPlugin.getDefault().getSettings();
            if (settings.hasKey("patient_search_site_filter_on")) {
                this.btnFilterBySite.setSelection(settings.getBoolean("patient_search_site_filter_on"));
            } else {
                settings.put("patient_search_site_filter_on", false);
                this.btnFilterBySite.setSelection(false);
            }
            this.btnFilterBySite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    settings.put("patient_search_site_filter_on", PatientSearchComposite.this.btnFilterBySite.getSelection());
                    if (PatientSearchComposite.this.btnFilterBySite.getSelection()) {
                        if (PatientSearchComposite.this.siteCombo.getSelection() == null) {
                            PatientSearchComposite.this.siteCombo.select(PatientSearchComposite.this.contextSiteProvider.getContextSite());
                        }
                    } else {
                        PatientSearchComposite.this.siteCombo.selectNone();
                    }
                }
            });
            this.addSearchControl("btnFilterBySite", (IControl)this.btnFilterBySite);
        }
        this.lblSite = new MyLabel(compPlus, Messages.getString((String)"LE_PATIENT_APPARTIENT_AU_SITE", (String[])new String[0]), 0, toolkit);
        this.siteCombo = new WorkSiteCombo(compPlus, 65544, toolkit);
        this.contextSiteListener = new IPropertyListener(){

            public void propertyChanged(int propertyId) {
                if (propertyId == 1 && !PatientSearchComposite.this.isDisposed() && PatientSearchComposite.this.moreThanOneSite() && PatientSearchComposite.this.btnFilterBySite.getSelection()) {
                    PatientSearchComposite.this.siteCombo.select(PatientSearchComposite.this.contextSiteProvider.getContextSite());
                }
            }
        };
        this.parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PropertyListenerManager.removeListener((IPropertyListener)PatientSearchComposite.this.contextSiteListener);
            }
        });
        MyButton btnDeleteProf = null;
        MyButton btnDeleteDisp = null;
        if (isProf) {
            this.btnInMyPatient = new MyButton(parent, Messages.getString((String)"RECHERCHER_PARMI_MES_PATIENTS", (String[])new String[0]), 32, toolkit);
            this.addSearchControl("btnInMyPatient", (IControl)this.btnInMyPatient);
            this.btnInIntervenant = new MyButton(parent, Messages.getString((String)"RECHERCHER_PARMI_INTERVENANTS", (String[])new String[0]), 32, toolkit);
            this.addSearchControl("btnInIntervenant", (IControl)this.btnInIntervenant);
        } else {
            this.lblProfessionnal = new MyLabel(parent, Messages.getString((String)"PROF_", (String[])new String[0]), 16384, toolkit);
            this.cmbProfessionnal = new ProfessionalBySiteCombo(parent, 65544, toolkit);
            this.cmbProfessionnal.fill();
            this.addSearchControl("cmbProfessionnal", this.cmbProfessionnal, new ProfessionalBySiteComboASearchAdapter(this.cmbProfessionnal));
            btnDeleteProf = new MyButton(parent, null, 8, toolkit);
            btnDeleteProf.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
            this.lblDispensateur = new MyLabel(parent, Messages.getString((String)"DISP_", (String[])new String[0]), 16384, toolkit);
            this.cmbDispensateur = new ProfessionalBySiteCombo(parent, 65544, toolkit);
            this.cmbDispensateur.fill();
            this.addSearchControl("cmbDispensateur", this.cmbDispensateur, new ProfessionalBySiteComboASearchAdapter(this.cmbDispensateur));
            btnDeleteDisp = new MyButton(parent, null, 8, toolkit);
            btnDeleteDisp.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
            this.cmbProfessionnal.selectNone();
            this.cmbDispensateur.selectNone();
        }
        this.lblDate = new MyLabel(compPlus, Messages.getString((String)"DATE_ACTIVITE", (String[])new String[0]), 0, toolkit);
        this.txtDate = new MyMaskedText(compPlus, 0, toolkit);
        this.txtDate.setMask(new MyMask("9999-99-99;9999-99-99"));
        this.txtDate.addKeyListener(this.enterCtrlEnterListener);
        this.txtDate.setToolTipText(Messages.getString((String)"FORMAT_99999999_OU_9999999999999999", (String[])new String[0]));
        this.addSearchControl("txtDate", (IControl)this.txtDate);
        this.lblTelephone = new MyLabel(compPlus, Messages.getString((String)"CONTACT", (String[])new String[0]), 0, toolkit);
        this.txtTelephone = new MyMaskedText(compPlus, 0, toolkit);
        this.txtTelephone.addKeyListener(this.enterCtrlEnterListener);
        this.txtTelephone.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.addSearchControl("txtTelephone", (IControl)this.txtTelephone);
        this.lblNote = new MyLabel(compPlus, Messages.getString((String)"LA_NOTE_CONTIENT", (String[])new String[0]), 0, toolkit);
        this.txtNote = new MyMaskedText(compPlus, 0, toolkit);
        this.txtNote.setMask(new MyMask(MyMask.toLength((char)'!', (int)40)));
        this.txtNote.addKeyListener(this.enterCtrlEnterListener);
        this.txtNote.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.addSearchControl("txtNote", (IControl)this.txtNote);
        this.setContextSiteProvider((ContextSiteProvider)SitePlugin.getDefault());
        this.addSearchControl("siteCombo", (IControl)this.siteCombo, (SearchControlAdapter)new DataObjectListAdapter(this.siteCombo.getItems()));
        this.btnRdvsToMove = new MyButton(compPlus, StringUtils.capitalize((String)(String.valueOf(Messages.getString((String)"RENDEZVOUS", (String[])new String[0])) + " " + Messages.getString((String)"A_DEPLACER", (String[])new String[0])).toLowerCase()), 32, toolkit);
        this.btnRdvsToMove.setToolTipText(Messages.getString((String)"A_DEPLACER_TTT", (String[])new String[0]));
        this.addSearchControl("btnRdvsToMove", (IControl)this.btnRdvsToMove);
        MyLabel lblDeleted = new MyLabel(compPlus, String.valueOf(Messages.getString((String)"DESACTIVEE", (String[])new String[0])) + " : ", 0, toolkit);
        this.cmbDeleted = new BooleanFilterCombo(compPlus, toolkit);
        this.addSearchControl("cmbDeleted", (IControl)this.cmbDeleted);
        this.txtTelephone.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (PatientSearchComposite.this.txtTelephone.getText().length() == 7) {
                    PatientSearchComposite.this.txtTelephone.setText(String.valueOf(Application.get().getGlobalInstances().getSession().getClientPreferences().getDefaultRegionalCode()) + PatientSearchComposite.this.txtTelephone.getText());
                }
            }
        });
        if (!isProf) {
            btnDeleteProf.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PatientSearchComposite.this.cmbProfessionnal.selectNone();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            btnDeleteDisp.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PatientSearchComposite.this.cmbDispensateur.selectNone();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.height = 0;
        this.lblNameDossier.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNameDossier.getControl(), 3);
        data.right = new FormAttachment(100, 0);
        this.btnKeepFocus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNameDossier.getControl(), 1);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(this.btnKeepFocus.getControl(), -18);
        this.txtNameDossier.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNameDossier.getControl());
        data.left = new FormAttachment(0);
        boolean bl = visible = this.moreThanOneSite() && !this.simpleSearchMode;
        if (!visible) {
            data.height = 0;
        }
        this.btnFilterBySite.setLayoutData((Object)data);
        this.btnFilterBySite.setVisible(visible);
        if (isProf) {
            data = new FormData();
            data.top = new FormAttachment(this.btnFilterBySite.getControl(), 2);
            data.left = new FormAttachment(0);
            this.btnInMyPatient.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(this.btnInMyPatient.getControl(), 2);
            data.left = new FormAttachment(0);
            this.btnInIntervenant.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(this.btnInIntervenant.getControl(), 4);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100, 0);
            this.secPlus.setLayoutData((Object)data);
        } else {
            data = new FormData();
            data.top = new FormAttachment(this.btnFilterBySite.getControl(), 5);
            data.left = new FormAttachment(0);
            this.lblProfessionnal.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(this.btnFilterBySite.getControl(), 5);
            data.right = new FormAttachment(100);
            btnDeleteProf.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(btnDeleteProf.getControl(), 0, 128);
            data.left = new FormAttachment(this.lblProfessionnal.getControl());
            data.right = new FormAttachment(btnDeleteProf.getControl());
            data.bottom = new FormAttachment(btnDeleteProf.getControl(), 0, 1024);
            this.cmbProfessionnal.setLayoutData(data);
            data = new FormData();
            data.top = new FormAttachment(this.lblProfessionnal.getControl(), 5);
            data.left = new FormAttachment(0);
            this.lblDispensateur.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(this.lblProfessionnal.getControl(), 5);
            data.right = new FormAttachment(100);
            btnDeleteDisp.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(btnDeleteDisp.getControl(), 0, 128);
            data.left = new FormAttachment(this.cmbProfessionnal.getControl(), 0, 16384);
            data.right = new FormAttachment(this.cmbProfessionnal.getControl(), 0, 131072);
            data.bottom = new FormAttachment(btnDeleteDisp.getControl(), 0, 1024);
            this.cmbDispensateur.setLayoutData(data);
            data = new FormData();
            data.top = new FormAttachment(this.cmbDispensateur.getControl(), 4);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100, 0);
            this.secPlus.setLayoutData((Object)data);
        }
        if (this.simpleSearchMode) {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            this.secPlus.setVisible(false);
            this.secPlus.setLayoutData((Object)data);
        }
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDate.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.txtDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(50);
        this.lblTelephone.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblTelephone.getControl());
        data.left = new FormAttachment(50);
        data.right = new FormAttachment(98);
        this.txtTelephone.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtTelephone.getControl());
        data.left = new FormAttachment(0);
        this.lblNote.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNote.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(98);
        this.txtNote.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNote.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(98);
        this.lblSite.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSite.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(98);
        this.siteCombo.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbDeleted.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblDeleted.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.siteCombo.getControl(), 5);
        data.left = new FormAttachment(lblDeleted.getControl());
        this.cmbDeleted.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbDeleted.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(98);
        this.btnRdvsToMove.setLayoutData((Object)data);
        this.getPatientSearchChoice();
        this.tblSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (UI.CTRL((KeyEvent)e, (char)'c')) {
                    PatientSearchComposite.this.copyPatientRecordNumber();
                }
            }
        });
    }

    protected boolean moreThanOneSite() {
        return SitePlugin.getDefault().getWorkSites().size() > 1;
    }

    private void copyPatientRecordNumber() {
        if (this.tblSearch.getSelection().length > 0) {
            SearchItem item = (SearchItem)this.tblSearch.getSelection()[0].getData();
            XPatient patient = (XPatient)item.getData();
            Application.get().getGlobalInstances().setPatientCopy(patient == null ? null : patient.getId());
        }
    }

    protected void search() {
        block22: {
            this.putFocusInResultField = !this.btnKeepFocus.getSelection();
            boolean isOk = true;
            if (StringUtils.isBlank((CharSequence)this.txtTelephone.getText()) && StringUtils.isBlank((CharSequence)this.txtNote.getText()) && !this.btnRdvsToMove.getSelection()) {
                String namDos = this.txtNameDossier.getText().trim().toLowerCase();
                String nbLetters = namDos.replace(" ", "");
                boolean bl = isOk = nbLetters.length() > 3;
                if (isOk) {
                    String[] queries = namDos.split(" ");
                    int i = 0;
                    while (i < queries.length) {
                        if (queries[i].trim().length() < 2) {
                            isOk = false;
                            break;
                        }
                        ++i;
                    }
                } else {
                    isOk = nbLetters.matches(".*\\d+.*");
                }
            }
            if (isOk) {
                IStatus statusLastActivity;
                this.disposeTableColumns();
                this.createLoadingTableColumns();
                int idProfTx = -1;
                int idAutreDisp = -1;
                if (this.cmbProfessionnal != null) {
                    idProfTx = this.cmbProfessionnal.getSelection() != null ? this.cmbProfessionnal.getSelection().getId() : -1;
                } else if (this.btnInMyPatient != null) {
                    int n = idProfTx = this.btnInMyPatient.getSelection() ? PersonUiPlugin.getDefault().getSessionProfessionnal().getId() : -1;
                }
                if (this.cmbDispensateur != null) {
                    idAutreDisp = this.cmbDispensateur.getSelection() != null ? this.cmbDispensateur.getSelection().getId() : -1;
                } else if (this.btnInIntervenant != null) {
                    int n = idAutreDisp = this.btnInIntervenant.getSelection() ? PersonUiPlugin.getDefault().getSessionProfessionnal().getId() : -1;
                }
                if (this.getReferenceControl() instanceof IPatientList) {
                    ((IPatientList)this.getReferenceControl()).clear();
                    this.myClass = ((Object)((Object)this)).getClass();
                }
                ArrayList<XSite> sites = new ArrayList<XSite>(0);
                XSite site = this.siteCombo.getSelection();
                if (site != null) {
                    sites.add(site);
                }
                if ((statusLastActivity = this.validateLastActivity()).isOK()) {
                    LocalDate[] datesRecall = new LocalDate[]{};
                    LocalDate[] datesLastActivity = this.getDates(this.txtDate.getText().trim());
                    JobCallback callback = null;
                    try {
                        callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                            public void responseReceived(ReturnObject response) {
                                PatientSearchComposite.this.searchResponse((XPatientListText[])response.getObj());
                            }

                            public void exception(Exception e) {
                                super.exception(e);
                                PatientSearchComposite.this.searchResponse(new XPatientListText[0]);
                            }
                        };
                        PatientAccessorClient.getInstance().findPatient(Application.get().getGlobalInstances().getSession(), (ICallback)callback, false, this.txtNameDossier.getText().trim().toLowerCase(), null, null, this.getDatesAsStrings(datesLastActivity), this.txtTelephone.getText().trim(), this.getDatesAsStrings(datesRecall), this.txtNote.getText().trim(), this.inLastUsed, Integer.valueOf(idProfTx), Integer.valueOf(idAutreDisp), this.btnRdvsToMove.getSelection(), sites, false, (Boolean)this.cmbDeleted.getSelection());
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        MessageUtil.cannotConnectToServerExceptionMsg();
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "", e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block22;
                    }
                }
                String message = statusLastActivity.getMessage();
                this.setMessage(message);
            } else {
                this.txtNameDossier.setFocus();
                this.txtNameDossier.setSelection(this.txtNameDossier.getText().length());
                this.setMessage(MIN_4LETTTERS_2LETTERS);
            }
        }
    }

    private IStatus validateLastActivity() {
        String text = this.txtDate.getText().trim();
        LocalDate[] temp = this.getDates(text);
        LocalDate debut = temp[0];
        LocalDate fin = temp[1];
        IStatus status = Status.OK_STATUS;
        if (debut == null) {
            if (text.length() > 0) {
                status = new Status(IStatus.Severity.ERROR, String.valueOf(Messages.getString((String)"DATES_DE_", (String[])new String[0])) + Messages.getString((String)"DERNIERE_ACTIVITE", (String[])new String[0]) + Messages.getString((String)"_NON_VALIDE", (String[])new String[0]));
            }
        } else if (fin == null) {
            if (text.length() > 8) {
                status = new Status(IStatus.Severity.ERROR, String.valueOf(Messages.getString((String)"DATES_DE_", (String[])new String[0])) + Messages.getString((String)"DERNIERE_ACTIVITE", (String[])new String[0]) + Messages.getString((String)"_NON_VALIDE", (String[])new String[0]));
            }
        } else if (!debut.before((IPartialDate)fin)) {
            status = new Status(IStatus.Severity.ERROR, Messages.getString((String)"LA_PREMIERE_DATE_DOIT_PRECEDER_LA_DEUXIEME", (String[])new String[0]));
        }
        return status;
    }

    private LocalDate[] getDates(String text) {
        int length = text.length();
        LocalDate debut = null;
        LocalDate fin = null;
        if (length == 8) {
            debut = this.getDateFromText(text);
        } else if (length == 16) {
            debut = this.getDateFromText(text.substring(0, 8));
            fin = this.getDateFromText(text.substring(8, 16));
        }
        return new LocalDate[]{debut, fin};
    }

    private LocalDate getDateFromText(String text) {
        try {
            return LocalDateFormat.parse((String)text, (String)"yyyyMMdd");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private String[] getDatesAsStrings(LocalDate[] dates) {
        ArrayList<String> stringDates = new ArrayList<String>();
        LocalDate[] localDateArray = dates;
        int n = dates.length;
        int n2 = 0;
        while (n2 < n) {
            LocalDate date = localDateArray[n2];
            if (date != null) {
                stringDates.add(String.valueOf(LocalDateFormat.format((LocalDate)date, (String)"yyyyMMdd")));
            }
            ++n2;
        }
        return stringDates.toArray(new String[stringDates.size()]);
    }

    public void searchResponse(XPatientListText[] response) {
        if (response == null) {
            this.searchResponse((XPatient[])null);
        } else {
            XPatient[] array = new XPatient[response.length];
            int i = 0;
            while (i < response.length) {
                array[i] = response[i].patient;
                ++i;
            }
            this.searchResponse(array);
        }
    }

    public void searchResponse(XPatient[] response) {
        final XPatient[] patients = response == null ? new XPatient[]{} : response;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!PatientSearchComposite.this.parent.isDisposed()) {
                        boolean fromPatientListControl = PatientSearchComposite.this.getReferenceControl() instanceof IPatientList;
                        IPatientList patientList = null;
                        if (fromPatientListControl) {
                            patientList = (IPatientList)PatientSearchComposite.this.getReferenceControl();
                        }
                        boolean fromPatientReportControl = PatientSearchComposite.this.getReferenceControl() instanceof IPatientReport;
                        IPatientReport patientReport = null;
                        if (fromPatientReportControl) {
                            patientReport = (IPatientReport)PatientSearchComposite.this.getReferenceControl();
                        }
                        PatientSearchComposite.this.disposeTableColumns();
                        if (patients.length > 0) {
                            PatientSearchComposite.this.createTableColumns();
                        }
                        SearchItem[] search = new SearchItem[patients == null ? 0 : patients.length];
                        int i = 0;
                        while (i < search.length) {
                            XPatient patient = patients[i];
                            if (fromPatientListControl) {
                                patientList.addPatient((IPatient)patient);
                            }
                            if (fromPatientReportControl && !patientReport.isDisposed()) {
                                patientReport.addPatient((IPatient)patient);
                            }
                            search[i] = PatientSearchComposite.this.newSearchItem(patient);
                            ++i;
                        }
                        if (Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength() <= i) {
                            PatientSearchComposite.this.setMessage(MSG_TROP_DONNEES);
                        } else if (i == 0) {
                            PatientSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            PatientSearchComposite.this.txtNameDossier.setFocus();
                        } else {
                            PatientSearchComposite.this.setMessage(null);
                        }
                        PatientSearchComposite.this.loadSearchListInTable(search);
                        PatientSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                        if (fromPatientListControl) {
                            IntroPlugin.getDefault().refreshViews((Object)patientList.getElementToRefresh());
                        }
                        if (!PatientSearchComposite.this.putFocusInResultField) {
                            PatientSearchComposite.this.txtNameDossier.setFocus();
                            PatientSearchComposite.this.txtNameDossier.selectAll();
                        }
                        PatientSearchComposite.this.setPatientSearchChoice();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "", e);
                }
                if (PatientSearchComposite.this.sccesToInactive != null) {
                    for (SearchColumnChoiceElement scce : PatientSearchComposite.this.sccesToInactive) {
                        scce.setActive(false);
                    }
                }
            }
        });
    }

    protected void createTableColumns() {
        SearchColumnPreferenceLoader.ColumnOrderAndShow[] defaultPreferences = new SearchColumnPreferenceLoader.ColumnOrderAndShow[]{};
        try {
            defaultPreferences = new SearchColumnPreferenceLoader.ColumnOrderAndShow[]{new SearchColumnPreferenceLoader.ColumnOrderAndShow("ID;false;0;0"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("NOM;true;1;175"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("NO;true;2;85"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("NAM;true;3;115"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("DDN;true;4;80"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("G;true;5;25"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("TEL;true;6;100"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("TELNOTE;false;7;60"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("PROF;true;8;100"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("INSCRIT;true;9;25"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("SCANNED;true;10")};
        }
        catch (Exception e1) {
            logger.log(Level.SEVERE, "Unable to init default column for patientSearchComposite.", e1);
        }
        final SearchColumnPreferenceLoader.ColumnOrderAndShow[] loadPreferences = SearchColumnPreferenceLoader.loadPreferences((String)PREFERENCES_COLUMN_KEY, (SearchColumnPreferenceLoader.ColumnOrderAndShow[])defaultPreferences);
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(true);
        this.tableColumns = new ArrayList();
        ArrayList<SearchColumnChoiceElement> scces = new ArrayList<SearchColumnChoiceElement>();
        this.sccesToInactive = new ArrayList();
        int count = 0;
        SearchColumnPreferenceLoader.ColumnOrderAndShow[] columnOrderAndShowArray = loadPreferences;
        int n = loadPreferences.length;
        int n2 = 0;
        while (n2 < n) {
            final SearchColumnPreferenceLoader.ColumnOrderAndShow cos = columnOrderAndShowArray[n2];
            SearchColumn sc = null;
            if ("ID".equals(cos.name)) {
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    sc = new SearchColumn<XPatient>((Table)this.tblSearch, "ID"){

                        public String getText(XPatient e) {
                            return String.valueOf(e.getId());
                        }
                    };
                }
            } else if ("NOM".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "NOM"){

                    public String getText(XPatient e) {
                        return e.getName();
                    }
                };
                sc.getColumn().setData("maxWidth", (Object)150);
            } else if ("DDN".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "DDN", "DATE DE NAISSANCE"){

                    public String getText(XPatient e) {
                        return LocalDateFormat.nullSafeFormat((LocalDate)e.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString());
                    }
                };
            } else if ("G".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "G", "GENRE"){

                    public String getText(XPatient e) {
                        return e.getGender();
                    }
                };
            } else if ("NO".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "NO", "NO DOSSIER"){

                    public String getText(XPatient e) {
                        return e.getPatientRecordNumber();
                    }
                };
            } else if ("NAM".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "NAM"){

                    public String getText(XPatient e) {
                        return e.getFormatedHealthInsuranceNumber();
                    }
                };
            } else if ("PROF".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "PROF", "PROFESSIONNEL TRAITANT"){

                    public String getText(XPatient e) {
                        XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(e.getTreatingProfessionnal());
                        return prof == null ? "" : prof.getName();
                    }
                };
            } else if ("INSCRIT".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "INSCRIT", Messages.getString((String)"B2B", (String[])new String[0])){

                    public String getText(XPatient e) {
                        XInscriptionStatus s = e.getB2bStatus();
                        return s == null || s != XInscriptionStatus.INSCRIT_CONFIRME ? "" : "\u221a";
                    }
                };
            } else if ("TEL".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "TEL"){

                    public String getText(XPatient e) {
                        String contact = e.getFirstPhoneNumberContact();
                        return contact == null ? "" : contact;
                    }
                };
            } else if ("TELNOTE".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "TELNOTE"){

                    public String getText(XPatient e) {
                        String note = e.getFirstPhoneNumberContactNote();
                        return note == null ? "" : note;
                    }
                };
            } else if ("SCANNED".equals(cos.name)) {
                sc = new SearchColumn<XPatient>((Table)this.tblSearch, "SCANNED"){

                    public String getText(XPatient e) {
                        Boolean isScanned = Boolean.TRUE.equals(e.getIsScanned());
                        return isScanned != false ? "\u221a" : "";
                    }
                };
            }
            if (sc != null) {
                if (cos.width > -1) {
                    sc.getColumn().setWidth(cos.width);
                }
                sc.getColumn().addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        cos.width = ((TableColumn)e.getSource()).getWidth();
                        PatientSearchComposite.this.saveWidthPref(loadPreferences, cos);
                    }
                });
                SearchColumnChoiceElement searchColumnChoiceElement = new SearchColumnChoiceElement(sc, true, count++);
                scces.add(searchColumnChoiceElement);
                this.tableColumns.add(sc);
                if (Boolean.FALSE.equals(cos.show)) {
                    this.sccesToInactive.add(searchColumnChoiceElement);
                }
            }
            ++n2;
        }
        this.columnChoice = new SearchColumnChoiceElement[this.tableColumns.size()];
        this.columnChoice = scces.toArray(this.columnChoice);
    }

    protected void saveWidthPref(SearchColumnPreferenceLoader.ColumnOrderAndShow[] coss, SearchColumnPreferenceLoader.ColumnOrderAndShow c) {
        String[][] prefs = new String[this.columnChoice.length][];
        int[] order = new int[this.columnChoice.length];
        int i = 0;
        while (i < this.columnChoice.length) {
            order[i] = this.columnChoice[i].getOriginalOrder();
            if (this.columnChoice[i].getColumnName().equals(c.name)) {
                this.columnChoice[i].setWidth(c.width);
            }
            prefs[i] = new String[]{this.columnChoice[i].getColumnName(), "" + this.columnChoice[i].isActive(), "" + i, "" + this.columnChoice[i].getWidth()};
            ++i;
        }
        SearchColumnPreferenceLoader.savePref((String)this.getPreferencesKeys(), (String[][])prefs);
    }

    protected void createNew() {
        try {
            XPatient patient = new XPatient();
            patient.initialize();
            if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                PersonMultiEditorFactory.openPatient((IPatient)patient);
            } else {
                BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)patient), (String)PatientMultiEditor.class.getName());
            }
        }
        catch (PartInitException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    private void setPatientSearchChoice() {
        XBaseProfessionnal professional = PersonUiPlugin.getDefault().getSessionProfessionnal();
        if (professional != null && professional.getId() != null && this.btnInMyPatient != null) {
            this.patientSearchInfo.put(professional.getId().toString(), this.btnInMyPatient.getSelection());
            this.patientSearchInfo.save();
        }
    }

    private void getPatientSearchChoice() {
        XBaseProfessionnal professional;
        if (Application.get().getGlobalInstances().getSession() != null && (professional = PersonUiPlugin.getDefault().getSessionProfessionnal()) != null && professional.getId() != null) {
            String id = professional.getId().toString();
            String strCheck = this.patientSearchInfo.get(id);
            if (this.btnInMyPatient != null) {
                this.btnInMyPatient.setSelection("true".equals(strCheck));
            }
        }
    }

    protected void itemSelected(SearchItem item) {
        if (item != null && item.getData() instanceof XPatient) {
            SearchItem item2 = new SearchItem((Object)((XPatient)item.getData()), item.getText());
            super.itemSelected(item2);
        }
    }

    protected void processSelection(SearchItem item) {
        if (this.getReferenceControl() instanceof IReferenceControl) {
            return;
        }
        XPatient patient = (XPatient)item.getData();
        int patientId = patient.getId();
        if (this.getReferenceControl() instanceof ISimplePatientControl) {
            this.getSimplePatient(patientId, new ClosureA<ReturnObject>(){

                public void execute(ReturnObject response) {
                    ((ISimplePatientControl)PatientSearchComposite.this.getReferenceControl()).setController(new PatientController((XPatient)response.getObj()));
                }
            });
        } else {
            this.openPatientMultiEditor((IPatient)patient);
        }
    }

    private void openPatientMultiEditor(IPatient dataObject) {
        try {
            if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                PersonMultiEditorFactory.openPatient(dataObject);
            } else {
                BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)dataObject), (String)PatientMultiEditor.class.getName());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    private void getSimplePatient(int patientId, final ClosureA<ReturnObject> closure) {
        block5: {
            assert (closure != null);
            JobCallback callback = null;
            try {
                callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(final ReturnObject response) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                closure.execute((Object)response);
                            }
                        });
                    }
                };
                PatientAccessorClient.getInstance().getSimplePatient(patientId, Application.get().getGlobalInstances().getSession(), (ICallback)callback, patientId);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                if (callback == null || callback.killed()) break block5;
                callback.kill();
            }
        }
    }

    public void reset() {
        this.txtNameDossier.clear();
        this.txtTelephone.clear();
        this.txtDate.clear();
        this.txtNote.clear();
        super.reset();
    }

    public ContextSiteProvider getContextSiteProvider() {
        return this.contextSiteProvider;
    }

    public void setContextSiteProvider(ContextSiteProvider contextSiteProvider) {
        if (contextSiteProvider == null) {
            throw new NullPointerException("contextSiteProvider");
        }
        if (this.contextSiteProvider != null) {
            PropertyListenerManager.removeListener((IPropertyListener)this.contextSiteListener);
        }
        this.contextSiteProvider = contextSiteProvider;
        PropertyListenerManager.addListener((Object)contextSiteProvider, (IPropertyListener)this.contextSiteListener);
        if (this.moreThanOneSite() && this.siteCombo != null && !this.siteCombo.getControl().isDisposed()) {
            IDialogSettings3 settings = ControlsPlugin.getDefault().getSettings();
            boolean filterOn = settings.getBoolean("patient_search_site_filter_on", false);
            if (filterOn) {
                this.siteCombo.select(contextSiteProvider.getContextSite());
            } else {
                this.siteCombo.selectNone();
            }
        }
    }

    protected String[] getSoundexTextTableFrom(TableItem item) {
        XPatient pat = (XPatient)((SearchItem)item.getData()).getData();
        String[] s = new String[]{pat.firstName, pat.lastName};
        return s;
    }

    protected String getSoundexTextFrom(TableItem item) {
        XPatient pat = (XPatient)((SearchItem)item.getData()).getData();
        return String.valueOf(pat.firstName) + " " + pat.lastName;
    }

    public void setSearchText(String s) {
        this.txtNameDossier.setText(s);
        if (this.txtNameDossier.getText() != null) {
            this.txtNameDossier.setSelection(this.txtNameDossier.getText().length());
        }
    }

    public void doSearch() {
        this.search();
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return this.columnChoice;
    }

    protected String getPreferencesKeys() {
        return PREFERENCES_COLUMN_KEY;
    }

    public boolean isSimpleSearchMode() {
        return this.simpleSearchMode;
    }

    public void setSimpleSearchMode(boolean simpleSearchMode) {
        this.simpleSearchMode = simpleSearchMode;
    }

    public void hideKeepFocus() {
        FormData data = new FormData();
        data.top = new FormAttachment(this.lblNameDossier.getControl(), 3);
        data.right = new FormAttachment(100, 0);
        data.width = 0;
        this.btnKeepFocus.setLayoutData((Object)data);
        this.btnKeepFocus.getParent().pack();
    }
}

